/*  t2dfft.c    CCMATH mathematics library source code.
 *
 *  Copyright (C)  2000   Daniel A. Atkinson    All rights reserved.
 *  This code may be redistributed under the terms of the GNU library
 *  public license (LGPL). ( See the lgpl.license file for details.)
 * ------------------------------------------------------------------------
 */
/*
    Test:  fft2_d
*/
#include "ccmath.h"
#include <math.h>
struct complex *pa;
void main(int na,char **av)
{ int n,nd,f;
  struct complex *p; int i,j;
  double tp=6.28318530717958648;
  if(na!=3){ printf("para: log2(n) cd(0/1)\n"); exit(1);}
  printf("  Test of 2D FFT\n");
  n=atoi(*++av); nd=1<<n; tp/=nd;
  f=atoi(*++av); if(f) f='i'; else f='d';
  pa=(struct complex *)calloc(sizeof(*pa),nd*nd);
  for(i=0,p=pa; i<nd ;++i){
    for(j=0; j<nd ;++j){
       p->re=sin(i*tp)*sin(j*tp);
       (p++)->im=0.;
     }
   }
  fft2_d(pa,n,n,f);
  printf(" %d complex values in output\n",nd*nd);
  for(i=0,p=pa; i<nd ;++i){
    for(j=0; j<nd ;++j,++p)
      printf(" %2d %2d  %10.6f %10.6f\n",i,j,p->re,p->im);
   }
}
/* Test output

  Test of 2D FFT
 64 complex values in output
  0  0    0.000000   0.000000
  0  1    0.000000  -0.000000
  0  2    0.000000   0.000000
  0  3   -0.000000  -0.000000
  0  4    0.000000   0.000000
  0  5   -0.000000   0.000000
  0  6    0.000000  -0.000000
  0  7    0.000000   0.000000
  1  0   -0.000000  -0.000000
  1  1   -0.250000   0.000000
  1  2   -0.000000  -0.000000
  1  3   -0.000000  -0.000000
  1  4    0.000000  -0.000000
  1  5    0.000000  -0.000000
  1  6    0.000000  -0.000000
  1  7    0.250000   0.000000
  2  0   -0.000000   0.000000
  2  1   -0.000000  -0.000000
  2  2   -0.000000  -0.000000
  2  3    0.000000  -0.000000
  2  4    0.000000  -0.000000
  2  5   -0.000000  -0.000000
  2  6    0.000000   0.000000
  2  7    0.000000   0.000000
  3  0    0.000000  -0.000000
  3  1   -0.000000  -0.000000
  3  2   -0.000000  -0.000000
  3  3    0.000000  -0.000000
  3  4   -0.000000   0.000000
  3  5    0.000000   0.000000
  3  6    0.000000   0.000000
  3  7    0.000000   0.000000
  4  0    0.000000   0.000000
  4  1   -0.000000  -0.000000
  4  2    0.000000  -0.000000
  4  3    0.000000   0.000000
  4  4    0.000000   0.000000
  4  5    0.000000  -0.000000
  4  6    0.000000   0.000000
  4  7   -0.000000   0.000000
  5  0    0.000000   0.000000
  5  1    0.000000  -0.000000
  5  2    0.000000   0.000000
  5  3   -0.000000   0.000000
  5  4   -0.000000  -0.000000
  5  5    0.000000  -0.000000
  5  6   -0.000000  -0.000000
  5  7   -0.000000   0.000000
  6  0    0.000000  -0.000000
  6  1    0.000000  -0.000000
  6  2    0.000000   0.000000
  6  3   -0.000000   0.000000
  6  4   -0.000000   0.000000
  6  5    0.000000   0.000000
  6  6   -0.000000  -0.000000
  6  7   -0.000000   0.000000
  7  0   -0.000000   0.000000
  7  1    0.250000   0.000000
  7  2    0.000000   0.000000
  7  3   -0.000000   0.000000
  7  4    0.000000   0.000000
  7  5   -0.000000   0.000000
  7  6   -0.000000   0.000000
  7  7   -0.250000  -0.000000
*/
