#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <linux/dn.h>
#include "dnlib.h"
main()
{
  	int sockfd;
  	int er,i;
	struct 
	{
		char	devname[5]; 
		char	exec_addr[6]; 
	} if_arg;

	char	*exec_dev;
	static  struct	dn_naddr	*binadr;

	if ((exec_dev=getexecdev()) == NULL)
	{
		printf("getexecdev: Invalid line in /etc/decnet.conf\n");
		exit (-1);
	}

	memcpy(&if_arg.devname,exec_dev,5);
	binadr=dnet_addr(getnodeadd());
	if (binadr == NULL)
	{
		printf("dnet_addr: Invalid executor address in decnet.conf\n");
		exit (-1);
	}
	memcpy(&if_arg.exec_addr,binadr->a_addr,6);


  	if ((sockfd=socket(AF_DECnet,SOCK_SEQPACKET,1)) == -1) {
    		perror("socket");
    		exit(-1);
  	}

	if ((er=ioctl(sockfd, SIOCSIFADDR, (unsigned long)&if_arg)) < 0) {
		perror("ioctl");
		exit(-1);
	}		
	
  	if (close(sockfd) < 0)
    		perror("close");
  	printf("DECnet socket layer started...\n");
  	return 0;
}

