#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/socket.h>
#include <linux/dn.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include "dnlib.h"


struct	sockaddr_dn		sockaddr;
struct	accessdata_dn		accessdata;
static  struct	dn_naddr	*binadr;
static	char			filname[80];
static	char			volname[80];
static	char			dirname[80];
static	unsigned char		buf[1400];
static	int			buflen,bufptr;
int				sockfd;



/*-------------------------------------------------------------------------*/
static void	dntype_usage(void)
{
	printf("\n\nUSAGE: dntype -sSERVER -uUSER -pPASSWORD -f'FILE'\n");
	printf("Options\n");
	printf("SERVER:		Name of remote decnet node\n");
	printf("USER:		User name on remote node to gain access\n");
	printf("PASSWORD:	Password for USER\n");
	printf("FILE:		File name\n\n");
	printf("Examples:\n\n");
	printf("# dntype -smv3100 -userrat -p r4oie -f'sys$login:login.com'\n");
}

/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
static void	dap_setup_link(void)
{
  	if ((sockfd=socket(AF_DECnet,SOCK_SEQPACKET,DNPROTO_NSP)) == -1) 
	{
    		perror("socket");
    		exit(-1);
  	}


	if (setsockopt(sockfd,SOL_SOCKET,SO_CONACCESS,&accessdata,
		sizeof(accessdata)) < 0) 
	{
		perror("setsockopt");
		exit(-1);
	}

	sockaddr.sdn_family = AF_DECnet;
	sockaddr.sdn_flags	= 0x00;
	sockaddr.sdn_objnum	= 0x11;			/* FAL		*/
	sockaddr.sdn_objnamel	= 0x00;
	memcpy(sockaddr.sdn_add.a_addr, binadr->a_addr,6);

	if (connect(sockfd, (struct sockaddr *)&sockaddr, 
		sizeof(sockaddr)) < 0) 
	{
		perror("socket");
		exit(-1);
	}

}
/*-------------------------------------------------------------------------*/
static void	dap_close_link(void)
{
  	if (close(sockfd) < 0)
    		perror("close");
}
/*-------------------------------------------------------------------------*/
static void	dap_exchg_config(void)
{
	int		er;
	unsigned char	buf[100];
	unsigned char	confmsg[17] = {
					0x01,	/* Message type 1 = Conf */
					0x00,	/* Flag Field		 */
					0x2E,0x04, /* BufSiz 		 */
					0x07,	/* OS type = VMS	 */
					0x03,   /* RMS-32		 */
					0,0,0,0,0, /* Version 'stuff'     */
					0xA2,	/* Sequential Org Support*/
					0x80,
					0xB0,   /* Message Blocking. OK  */
					0xFE,   /* Supp Extended Attrib  */
					0xA8,   /* Supp. Seq Access/Del  */
					0x7C	/* WildCrds/Ren/Seg Msgs */
				      };
	if ((er=write(sockfd,confmsg,sizeof(confmsg))) < 0)
	{
		perror("Send DAP config msg");
		exit(-1);
	}
			      
	if ((er=read(sockfd,buf,sizeof(buf))) < 0)
	{
		perror("Recv DAP config msg");
		exit(-1);
	}			      
	/* Assume that Peer Supports the minimal characteristis we
	   setup here
	*/
	if (buf[0] == 0x09)
	{
		printf("Local DAP configuration rejected by remote node\n");
		exit(-1);
	}
}
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
static void	adjust_bufptr(void)
{
	if (buflen == bufptr)
	{
		buflen=read(sockfd,buf,sizeof(buf));
		if (buflen < 0) 
		{
			perror("DAP Read Directory Entry");
			exit(-1);
		}
		bufptr=0;
	}
}
/*-------------------------------------------------------------------------*/
static	void	dap_send_access(void)
{
	unsigned	char	buf[100];
	unsigned	char	attmsg[4] = {0x02,	/* Att. Type	*/
				 	     0x02,	/* Len present  */
					     0x01,	/* Length       */
					     0x00 	/* No att field */
					    };
	unsigned	char	acc1[5]   = {0x03,	/* Acc Message  */
					     0x02,	/* Len present  */
					     0x07,	/* Length       */
					     0x01,	/* Open Function*/
					     0x01 	/* no  fatal err*/
					    };
	unsigned	char	acc2[4]    = {0x00,0x00,0x01,0x00};
	int			i,er;

	for (i=0; i < 4; i++) buf[i]       = attmsg[i];
	for (i=0; i < 5; i++) buf[i+4]     = acc1[i];
	buf[6] = buf[6]+strlen(filname);
	buf[9] = strlen(filname);
	for (i=0; i < strlen(filname); i++) buf[i+10] = filname[i];
	for (i=0; i < 4; i++) buf[i+strlen(filname)+10]=acc2[i];
	if ( (er=write(sockfd,buf,strlen(filname)+14)) < 0)
	{
		perror("Send DAP access msg");
		exit(-1);
	}
	buflen = bufptr = 0;
}
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
static int	dap_get_file_entry(int *rfm, int *rat, int *org)

#define	BC	buf[bufptr]
#define MC	menu[0]  
#define MC1	menu[1]
{
	int	retval,len,i,auxptr;
	char	menu[6];

	adjust_bufptr();
	while ( (BC != 0x06) && (BC != 0x07) && (BC != 0x09) )
	{
	   adjust_bufptr();
	   switch(BC)
	   {
		case 0x0F : bufptr += 3;
			    if (BC == 0x08)		/* VOL Name */
			    {
				bufptr += 1;
				memcpy(volname,&buf[bufptr+1],BC);
				bufptr += (BC + 1);
				break;
			    }
			    if (BC == 0x04)		/* DIR Name */
			    {
				bufptr += 1;
				memcpy(dirname,&buf[bufptr+1],BC);
				bufptr += (BC + 1);
				break;
			    }
			    if (BC == 0x02)		/* FileName */
			    {
				memset(filname,0,80);
				bufptr += 1;
				memcpy(filname,&buf[bufptr+1],BC);
				bufptr += (BC + 1);
				break;
			    }
		case 0x02 : bufptr += 2;
			    len = BC + 1;
			    auxptr = bufptr;
			    i=0; bufptr += 1;
			    while (BC & 0x80) 
			    {
				menu[i++]= BC;
				bufptr += 1;
			    }
			    bufptr += 1;
			    if (MC & 1) 		/* Datatype	*/
			    {
				bufptr += BC + 1;
			    }
			    if (MC & 2)			/* ORG		*/
			    {
				*org = BC;
				bufptr += 1;
			    }
			    if (MC & 4)			/* RFM		*/
			    {
				*rfm = BC;
				bufptr += 1;
			    }
			    if (MC & 8)			/* RAT		*/
			    {
				*rat = BC;
				while (BC & 0x80) bufptr += 1;
				bufptr += 1;
			    }
			    bufptr = auxptr + len;
			    break;
		default:    bufptr += 1;
	   }
	}
	if (BC == 0x06)
	{
		bufptr += 1;
		if (BC == 0x02)
			bufptr += 2;
		else    bufptr += 1;
		return	6;
	}
	return -BC;
}
/*-------------------------------------------------------------------------*/
static void	dap_send_connect(void)
{
	unsigned char	conmsg[4]  = {0x04,0x00,0x02,0x00};
	int	er;

	if ((er=write(sockfd,conmsg,4)) < 0)
	{
		perror("Dap Send connect message");
		exit(-1);
	}

	if ( (er=read(sockfd,buf,sizeof(buf))) < 0)
	{
		perror("Dap send connect init");
		exit(-1);
	}
	if (buf[0] != 0x06)
	{
		printf("DAP send connect did not received ACK\n");
		exit(-1);
	}
	buflen = bufptr = 0;
}
/*-------------------------------------------------------------------------*/
static void	dap_send_get(void)
{
	unsigned char	conmsg[5]  = {0x04,0x00,0x01,0x01,0x03};
	int	er;

	if ((er=write(sockfd,conmsg,5)) < 0)
	{
		perror("Dap Send get message");
		exit(-1);
	}
	buflen = bufptr = 0;
}
/*-------------------------------------------------------------------------*/
static void	dap_send_accomp(void)
{
	unsigned char	acomsg[4] = {0x07,0x00,0x01,0x00};
	int	er;

	if ((er=write(sockfd,acomsg,4)) < 0)
	{
		perror("Dap Access complete message");
		exit(-1);
	}
}
/*-------------------------------------------------------------------------*/
static int	dap_get_record(char *rec,int *reclen)
{
	int	len;

	adjust_bufptr();
	if (BC == 0x09) return -BC;

 	bufptr += 2;
	len = BC-1;
	bufptr += 2;
	*reclen = len;
	memset(rec,0,1060);
	memcpy(rec,&buf[bufptr],*reclen);
	bufptr += len;
	return 0;
}
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
main(argc, argv)
	int	argc;
	char	*argv[];
{
	int	opt,retval,rfm,rat,org;
	int	reclen;
	char	rec[1060];

	/*	Zero Structure	AccessData			*/
	memset(&accessdata,0,sizeof(accessdata));
	/*	Process Input command options			*/

	if (argc < 4) {
		dntype_usage();
		exit();
	}
	opterr = 0;
	while ((opt=getopt(argc,argv,"s:u:p:f:")) != EOF)
	{
	   switch(opt) {
	      case '?': dntype_usage();
			exit();
	      case 's':	if (getnodebyname(optarg) == NULL)
			{
			   printf("No entry in /etc/decnet.conf for %s\n",
                                   optarg);
			   exit();
			}
			binadr = dnet_addr(getnodebyname(optarg));
			if (binadr == NULL) {
			   printf("Server %s address invalid.\n",optarg);
			   exit();
			}
	      case 'u': accessdata.acc_accl = strlen(optarg);
			memcpy(accessdata.acc_acc,optarg,strlen(optarg));
			break;
	      case 'p': accessdata.acc_passl = strlen(optarg);
			memcpy(accessdata.acc_pass,optarg,strlen(optarg));
			break;
	      case 'f': memcpy(filname,optarg,strlen(optarg));
			break;
	   }
	}

	dap_setup_link();			/*Setup link for DAP	*/

	dap_exchg_config();

	dap_send_access();			/*send Attrib/Access msg*/

	while ((retval=dap_get_file_entry(&rfm,&rat,&org)) > 0)
	{
	   printf("\n%s%s%s\n",volname,dirname,filname);
	   if (org == 00)
	   {
		dap_send_connect();		/* Initiate Stream	*/
		dap_send_get();			/* Read Records		*/
		buflen = bufptr = 0;
		while ((retval=dap_get_record(rec,&reclen)) == 0)
		{
	/*			printf("%s\n",rec);*/
			rec[reclen]=10;
			fputs(rec,stdout);
		}
		buflen = bufptr = 0;
		dap_send_accomp();
	    }
	    else
	    {
		printf("dntype: File organization not supported\n");
		dap_send_accomp();
	    }
	}
	dap_close_link();
}
