#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/socket.h>
#include <linux/dn.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include "dnlib.h"


struct	sockaddr_dn		sockaddr;
struct	accessdata_dn		accessdata;
static  struct	dn_naddr	*binadr;
static	char			dirname[80];
static	unsigned char		buf[1400];
static	int			buflen,bufptr;
int				sockfd;



/*-------------------------------------------------------------------------*/
static void	dndir_usage(void)
{
	printf("\n\nUSAGE: dndir -sSERVER -uUSER -pPASSWORD -d'DIRECTORY'\n");
	printf("Options\n");
	printf("SERVER:		Name of remote decnet node\n");
	printf("USER:		User name on remote node to gain access\n");
	printf("PASSWORD:	Password for USER\n");
	printf("DIRECTORY:	Directory we want to list\n\n");
	printf("Examples:\n\n");
	printf("# dndir -s mv3100 -u serrat -p r4oie -d 'sys$disk:[0,0]*.*'\n");
	printf("# dndir -s vx4106 -u system -p admin -d 'dka0:[users]*.*'\n\n");
}

/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
static void	dap_setup_link(void)
{
  	if ((sockfd=socket(AF_DECnet,SOCK_SEQPACKET,DNPROTO_NSP)) == -1) 
	{
    		perror("socket");
    		exit(-1);
  	}


	if (setsockopt(sockfd,SOL_SOCKET,SO_CONACCESS,&accessdata,
		sizeof(accessdata)) < 0) 
	{
		perror("setsockopt");
		exit(-1);
	}

	sockaddr.sdn_family = AF_DECnet;
	sockaddr.sdn_flags	= 0x00;
	sockaddr.sdn_objnum	= 0x11;			/* FAL		*/
	sockaddr.sdn_objnamel	= 0x00;
	memcpy(sockaddr.sdn_add.a_addr, binadr->a_addr,6);

	if (connect(sockfd, (struct sockaddr *)&sockaddr, 
		sizeof(sockaddr)) < 0) 
	{
		perror("socket");
		exit(-1);
	}

}
/*-------------------------------------------------------------------------*/
static void	dap_close_link(void)
{
  	if (close(sockfd) < 0)
    		perror("close");
}
/*-------------------------------------------------------------------------*/
static void	dap_exchg_config(void)
{
	int		er;
	unsigned char	buf[100];
	unsigned char	confmsg[17] = {
					0x01,	/* Message type 1 = Conf */
					0x00,	/* Flag Field		 */
					0x2E,0x04, /* BufSiz 		 */
					0x07,	/* OS type = VMS	 */
					0x03,   /* RMS-32		 */
					0,0,0,0,0, /* Version 'stuff'     */
					0xA2,	/* Sequential Org Support*/
					0x80,
					0xB0,   /* Message Blocking. OK  */
					0xFE,   /* Supp Extended Attrib  */
					0xA8,   /* Supp. Seq Access/Del  */
					0x7C	/* WildCrds/Ren/Seg Msgs */
				      };

	if ((er=write(sockfd,confmsg,sizeof(confmsg))) < 0)
	{
		perror("Send DAP config msg");
		exit(-1);
	}			      
	if ((er=read(sockfd,buf,sizeof(buf))) < 0)
	{
		perror("Recv DAP config msg");
		exit(-1);
	}			      
	/* Assume that Peer Supports the minimal characteristis we
	   setup here
	*/
	if (buf[0] == 0x09)
	{
		printf("Local DAP configuration rejected by remote node\n");
		exit(-1);
	}
}
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
static	void	dap_directory_lookup(void)
{
	unsigned char	part1[4] = {0x03,		/* Access TYPE	   */
				    0x00,		/* FLAGS	   */
				    0x06,		/* Directory Func  */
				    0x01 		/* I/O err is fatal*/
				   }; 
	unsigned char	part2[4] = {0x00,		/* Default Acc GET */
				    0x00,		/* Share Ops GET   */
				    0x31,		/* Main/Date/Protec*/
				    0x00 		/* Password Length */
				   }; 
	int	i,er;

	for (i = 0; i < 4; i++) buf[i] = part1[i];
	buf[4] = strlen(dirname);
	for (i = 0; i < strlen(dirname); i ++) buf[i+5] = dirname[i];
	for (i = 0; i < 4; i++) buf[i+5+strlen(dirname)] = part2[i];

	if ((er=write(sockfd,buf,(strlen(dirname)+9))) < 0)
	{
		perror("Send DAP Directory Access");
		exit(-1);
	}
	buflen = bufptr = 0;
}
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
static void	dap_send_skip(void)
{	
	unsigned char	contmsg[3] = {0x05,0x00,0x02};
	int		er;

	if ( (er=write(sockfd,contmsg,3)) < 0)
	{
		perror("Send DAP skip message");
		exit(-1);
	}
	buflen = bufptr = 0;
}
/*-------------------------------------------------------------------------*/
static void	adjust_bufptr(void)
{
	if (buflen == bufptr)
	{
		buflen=read(sockfd,buf,sizeof(buf));
		if (buflen < 0) 
		{
			perror("DAP Read Directory Entry");
			exit(-1);
		}
		bufptr=0;
	}
}
/*-------------------------------------------------------------------------*/
static int	dap_get_dir_entry(char *name,long *size,char *cdt, 
				  char *owner, char *prot)
#define	BC	buf[bufptr]
#define MC	menu[0] 
{
	int	retval,len,i,auxptr;
	char	menu[6];

	adjust_bufptr();
	while ((BC != 0x06) && (BC != 0x07) )
	{
		adjust_bufptr();
		switch (BC) {
		  case 0x09 : if ((buf[bufptr+2] == 0x30) && 
				 (buf[bufptr+3] == 0x40) )
			      {
				 printf("%s %s\n",name,
					"(Locked by another user)");
			         dap_send_skip();
			         break;
			      }
			      else return -BC;
		  case 0x0F : bufptr += 3;
			      retval = BC;
			      bufptr += 1;
			      memset(name,0,80);
			      memcpy(name,&buf[bufptr+1],BC);
			      bufptr += (BC + 1);
			      if ((retval == 0x08) || (retval == 0x04))
				  return retval;
		              break;
		  case 0x02 : bufptr += 2;
			      len = BC+1;
			      auxptr = bufptr;
			      i=0; bufptr += 1;
			      while (BC & 0x80)
			      {
				menu[i++] = BC;
				bufptr += 1;
			      }
		      	      bufptr += 1;
			      if (MC & 1)	/* DataType */
			      {
					bufptr += BC+1;
			      }
 			      if (MC & 2)	/* ORG		*/
			      {
					bufptr += 1;
			      }
			      if (MC & 4)	/* RFM		*/
			      {
					bufptr += 1;
			      }
			      if (MC & 8)	/* RAT		*/
			      {
				while (BC & 0x80)
					bufptr += 1;
				bufptr += 1;
			      }
			      if (MC & 16)	/* BLS		*/
			      {
					bufptr += 2;
			      }
			      if (MC & 32)	/* MRS		*/
			      {
					bufptr += 2;
			      }
			      *size=0;
			      if (MC & 64)	/* ALQ		*/
			      {
					memcpy(size,&buf[bufptr+1],BC);
			      } 
			      bufptr = auxptr + len;
			      break;

		  case 0x0D : bufptr += 2;
			      len = BC+1;
			      memcpy(cdt,&buf[bufptr+2],18);
			      bufptr += len;
			      break;
		  case 0x0E : bufptr += 4;
			      memset(owner,0,20);
			      memcpy(owner,&buf[bufptr+1],BC);
			      bufptr += (BC + 1);
			      len = 0;
		              len += sprintf(prot+len,"(");
			      for (i=0; i < 4; i++)
			      {
			         if ((BC & 0x01)==0) len+=sprintf(prot+len,"R");
			         if ((BC & 0x02)==0) len+=sprintf(prot+len,"W");
			         if ((BC & 0x04)==0) len+=sprintf(prot+len,"E");
			         if ((BC & 0x08)==0) len+=sprintf(prot+len,"D");
				 if (i != 3) len+=sprintf(prot+len,",");
				 bufptr += 1;
			      }
		              len += sprintf(prot+len,")");
			      return retval;
		   default  : bufptr += 1;
		}
	}
	return -BC;
}
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------*/
main(argc, argv)
	int	argc;
	char	*argv[];
{
	int	opt,retval;
	char	name[80],cdt[18],owner[20],prot[22];
	long	size;

	/*	Zero Structure	AccessData			*/
	memset(&accessdata,0,sizeof(accessdata));
	/*	Process Input command options			*/

	if (argc < 4) {
		dndir_usage();
		exit();
	}
	opterr = 0;
	while ((opt=getopt(argc,argv,"s:u:p:d:")) != EOF)
	{
	   switch(opt) {
	      case '?': dndir_usage();
			exit();
	      case 's':	if (getnodebyname(optarg) == NULL)
			{
			   printf("No entry in /etc/decnet.conf for %s\n",
                                   optarg);
			   exit();
			}
			binadr = dnet_addr(getnodebyname(optarg));
			if (binadr == NULL) {
			   printf("Server %s address invalid.\n",optarg);
			   exit();
			}
	      case 'u': accessdata.acc_accl = strlen(optarg);
			memcpy(accessdata.acc_acc,optarg,strlen(optarg));
			break;
	      case 'p': accessdata.acc_passl = strlen(optarg);
			memcpy(accessdata.acc_pass,optarg,strlen(optarg));
			break;
	      case 'd': memcpy(dirname,optarg,strlen(optarg));
			break;
	   }
	}

	dap_setup_link();			/*Setup link for DAP	*/

	dap_exchg_config();

	dap_directory_lookup();			/* Look up for directory */

	while ((retval=dap_get_dir_entry(name,&size,cdt,owner,prot)) > 0)
	{
		if (retval == 0x08)
			printf("\nDirectory of %s",name);
		if (retval == 0x04)
			printf("%s\n\n",name);
		if (retval == 0x02)
		{
	 	   if (strlen(name) < 22)
	 	   {
		      printf("%-22s %7d %s %s %s\n",name,size,cdt,owner,prot);		 
		   }
		   else
		   {
		      printf("%s\n",name);
		      printf("%-22s %7d %s %s %s\n","",size,cdt,owner,prot);		 
		   }
		}
	}
	if (retval == -9) printf("Error opening %s\n",dirname);
	dap_close_link();
}
