/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * MODULE/CLASS : mx_cell_d
 *
 * AUTHOR : Andrew Haisley
 *
 * This file 
 *
 * DESCRIPTION:
 *
 *  Formatting table cells
 *
 *
 *
 *
 */

#include <stdio.h>
#include <dirent.h>
#include <errno.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>

#include <Xm/Xm.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
#include <Xm/Form.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>
#include <Xm/Separator.h>
#include <Xm/Protocols.h>
#include <Xm/ComboBox.h>
#include <mx.h>
#include <mx_std.h>
#include <mx_ui_object.h>
#include "mx_dialog.h"
//#include "mx_yes_no_d.h"
//#include "mx_open_d.h"
#include <mx_file_type.h>

#include "mx_cell_d.h"

static void button_cb(
            Widget    widget, 
            XtPointer client_data, 
            XtPointer call_data)
{
    mx_cell_d *d = (mx_cell_d*)client_data;

    if (widget == d->ok_button)
    {
        d->figure_options();
        d->modal_result = yes_e;
    }
    else
    {
        if (widget == d->apply_button)
        {
            d->figure_options();
            d->modal_result = apply_e;
        }
        else
        {
            d->modal_result = cancel_e;
        }
    }
}

static void text_return(
            Widget    widget, 
            XtPointer client_data, 
            XtPointer call_data)
{
    mx_cell_d *d = (mx_cell_d*)client_data;

    d->figure_options();
    d->modal_result = yes_e;
}

mx_cell_d::mx_cell_d(Widget parent) : mx_dialog("formatCells", parent, TRUE, FALSE)
{
    Widget label;

    XtVaSetValues(action_area, XmNfractionBase, 7, NULL);

    label = XtVaCreateManagedWidget(
                "columnWidthLabel",
                xmLabelGadgetClass,
                control_area,
                XmNtopAttachment,    XmATTACH_FORM,
                XmNleftAttachment,   XmATTACH_FORM,
                NULL);

    width_text = XtVaCreateManagedWidget("widthText",
                    xmTextWidgetClass, control_area,
                    XmNleftAttachment, XmATTACH_WIDGET,
                    XmNleftWidget, label,
                    XmNtopAttachment, XmATTACH_FORM,
                    NULL);

    XtAddCallback(width_text, XmNactivateCallback, text_return, this);

    // now, the action buttons
    ok_button = XtVaCreateManagedWidget(
                "ok",
                xmPushButtonGadgetClass, action_area,
                XmNshowAsDefault, True,
                XmNdefaultButtonShadowThickness, 1,
                XmNleftAttachment,   XmATTACH_POSITION,
                XmNleftPosition,     1,
                XmNrightAttachment,   XmATTACH_POSITION,
                XmNrightPosition,     2,
                NULL);

    XtAddCallback(
            ok_button, 
            XmNactivateCallback, 
            button_cb, 
            (XtPointer)this);

    apply_button = XtVaCreateManagedWidget(
                "apply",
                xmPushButtonGadgetClass, action_area,
                XmNshowAsDefault, False,
                XmNdefaultButtonShadowThickness, 1,
                XmNleftAttachment,   XmATTACH_POSITION,
                XmNleftPosition,     3,
                XmNrightAttachment,   XmATTACH_POSITION,
                XmNrightPosition,     4,
                NULL);

    XtAddCallback(
            apply_button, 
            XmNactivateCallback, 
            button_cb, 
            (XtPointer)this);

    cancel_button = XtVaCreateManagedWidget(
                "cancel",
                xmPushButtonGadgetClass, action_area,
                XmNshowAsDefault, False,
                XmNdefaultButtonShadowThickness, 1,
                XmNleftAttachment,   XmATTACH_POSITION,
                XmNleftPosition,     5,
                XmNrightAttachment,   XmATTACH_POSITION,
                XmNrightPosition,     6,
                NULL);

    XtAddCallback(
            cancel_button, 
            XmNactivateCallback, 
            button_cb, 
            (XtPointer)this);


    XtManageChild(action_area);
    XtManageChild(control_area);
    XtManageChild(pane);
}

void mx_cell_d::figure_options()
{
    char *s = XmTextGetString(width_text);
    float f = atof(s);
    XtFree(s);
    width = mx_unit_to_mm(f, units);
}

void mx_cell_d::activate(float w, mx_unit_e u)
{
    char s[20];
    float f;

    units = u;

    if (w < 0.0)
    {
        s[0] = 0;
    }
    else
    {
        f = mx_mm_to_unit(w, units);
        sprintf(s, "%.2f %s", f, mx_unit_name(units));
    }
    XmTextSetString(width_text, s);
}

int mx_cell_d::run(float w, mx_unit_e u)
{
    int res;

    centre();
    activate(w, u);
    res = run_modal();
    deactivate();

    return res;
}
