/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef MX_XFONTNAME_H
#define MX_XFONTNAME_H
/*
 * MODULE/CLASS : mx_xfontname
 *
 * AUTHOR : Tom Newton
 *
 * 
 *
 * DESCRIPTION:
 *
 * Two routines for getting and setting arguments of an X font string
 *
 *
 *
 */

enum mx_xfontname_arg_name
{
    mx_xfontname_foundry_e = 0,
    mx_xfontname_family_e,
    mx_xfontname_weight_e,
    mx_xfontname_slant_e,
    mx_xfontname_s_width_e,
    mx_xfontname_adstyl_e,
    mx_xfontname_pixel_size_e,
    mx_xfontname_point_size_e,
    mx_xfontname_x_res_e,
    mx_xfontname_y_res_e,
    mx_xfontname_spacing_e,
    mx_xfontname_average_width_e,
    mx_xfontname_registry_e,
    mx_xfontname_encoding_e
};

void mx_xfontname_get_arg(int &err, const char *xfontname, uint8 arg_num, 
                          char *argval);

void mx_xfontname_set_arg(int &err, char *xfontname, uint8 arg_num, 
                          const char *argval);

#endif // MX_XFONTNAME_H
