/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * MODULE/CLASS : mx_xfontname
 *
 * AUTHOR : Tom Newton
 *
 * 
 *
 * DESCRIPTION:
 *
 * Two routines for getting and setting arguments of an X font string
 *
 *
 *
 */

#include <mx.h>
#include "mx_xfontname.h"

void mx_xfontname_get_arg(int &err, const char *xfontname, uint8 arg_num, 
                          char *argval) 
{
    uint32 arg_len = 0;
    uint8 arg = 0;
    const char *arg_end_ptr;

    // find a pointer to the start of the argument

    while(arg <= arg_num && *xfontname != '\0')
    {
        if(*xfontname++ == '-') arg++;
    }
    if(*xfontname == '\0') MX_ERROR_THROW(err, MX_XFONTNAME_INVALID);

    // find a pointer to the end of the argument string

    arg_end_ptr = xfontname;
    while(*arg_end_ptr != '-' && *arg_end_ptr != '\0') arg_end_ptr++;
    if(*arg_end_ptr == '\0' && arg_num != mx_xfontname_encoding_e)
    {
        MX_ERROR_THROW(err, MX_XFONTNAME_INVALID);
    }

    // get the length of the old argument

    arg_len = arg_end_ptr - xfontname;

    // copy the argument into the return parameter

    memcpy(argval, xfontname, arg_len);
    argval[arg_len] = '\0';
        
abort:;    
}

// substitute an an argument in an X font description string for our own
// argument.
void mx_xfontname_set_arg(int &err, char *xfontname, uint8 arg_num, 
                          const char *argval) 
{
    uint32 new_arg_len = strlen(argval);
    uint32 old_arg_len = 0;
    uint8 arg = 0;
    const char *arg_end_ptr, *end_str_ptr;
    char *new_arg_end_ptr;

    // find a pointer to the start of the argument

    while(arg <= arg_num && *xfontname != '\0')
    {
        if(*xfontname++ == '-') arg++;
    }
    if(*xfontname == '\0') MX_ERROR_THROW(err, MX_XFONTNAME_INVALID);

    // find a pointer to the end of the old argument string

    arg_end_ptr = xfontname;
    while(*arg_end_ptr != '-' && *arg_end_ptr != '\0') arg_end_ptr++;
    if(*arg_end_ptr == '\0') MX_ERROR_THROW(err, MX_XFONTNAME_INVALID);

    // get the length of the old argument and calculate a pointer to the end of
    // the new argument

    old_arg_len = arg_end_ptr - xfontname;
    new_arg_end_ptr = xfontname + new_arg_len;

    // find a pointer to the first character after the '\0'

    end_str_ptr = arg_end_ptr;
    while (*end_str_ptr++ != '\0');

    // move the end of the font string to the correct place and copy in the argument

    memmove(new_arg_end_ptr, arg_end_ptr, end_str_ptr - arg_end_ptr);
    memcpy(xfontname, argval, new_arg_len);

abort:;
}

