/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <mx.h>
#include <mx_font.h>
#include <mx_font_metrics.h>

char * global_maxhome = NULL;

// this should do more than it does..

int main(int argc, char ** argv)
{
    int err = MX_ERROR_OK;
    mx_font_metrics_store *fms;
    mx_font_family *ff;

    global_maxhome = getenv("MAXHOME");
    if(global_maxhome == NULL) global_maxhome = "/usr/local/maxwell";

    fms = new mx_font_metrics_store;
    ff = fms->get_font_family(err, "Utopia");
    MX_ERROR_CHECK(err);

    ff = fms->get_font_family(err, "Courier");
    MX_ERROR_CHECK(err);

    return 0;
abort:
    global_error_trace->print();
    return 1;
}

