/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * MODULE : metaTest.C
 *
 * AUTHOR : David Miller
 *
 * This file 
 *
 * DESCRIPTION: 

 * Module metaTest.C 
 * 
 *
 */

#include <mx.h>
#include "mx_mxmetafile.h"



int main(int argc, char ** argv)
{
    int err ;
    char  buffer[100000] ;

    if(argc == 2)
    {
        mx_metafile_file_input input1(err, argv[1]);
        MX_ERROR_CHECK(err);

	mx_metafile_output  output1,output2 ;
	mx_metafile metafile1(&input1,&output1) ;

        metafile1.process(err);
        MX_ERROR_CHECK(err);

	FILE *file = fopen(argv[1],"r") ;
	fseek(file,0,SEEK_END) ;
	int size = ftell(file) ;
	
	fseek(file,0,SEEK_SET) ;

	int nread = fread(buffer,size,1,file);

	mx_metafile_buffer_input input2(err,size,buffer);
        MX_ERROR_CHECK(err);
	
	mx_metafile metafile2(&input2,&output2) ;	

        metafile2.process(err);
        MX_ERROR_CHECK(err);

        mx_metafile_file_input input3(err, argv[1]);
        MX_ERROR_CHECK(err);
	mx_mxmetafile_output output3 ;

	mx_metafile metafile3(&input3,&output3) ;	

        metafile3.process(err);
        MX_ERROR_CHECK(err);
    }
    return EXIT_SUCCESS;
abort:
    return EXIT_FAILURE;
}
