/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * MODULE/CLASS : mx_help_toolbar
 *
 * AUTHOR : David Miller
 *
 * DESCRIPTION:
 *
 *
 */


#include <stdlib.h>

#include <Xm/Xm.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleBG.h>
#include <Xm/RowColumn.h>
#include <mx.h>
#include <mx_hash.h>
#include <mx_bar.h>
#include <mx_help.h>
#include <Xm/Form.h>

mx_help_toolbar::mx_help_toolbar(mx_window * aWindow)
: mx_bar("toolBar", aWindow)
{
    backButton = XtVaCreateManagedWidget("backButton", 
                                         xmPushButtonGadgetClass, 
                                         widget, 
                                         NULL);

    forwardButton = XtVaCreateManagedWidget("forwardButton", 
                                            xmPushButtonGadgetClass, 
                                            widget,
                                            NULL);

    findButton = XtVaCreateManagedWidget("findButton", 
                                            xmPushButtonGadgetClass, 
                                            widget,
                                            NULL);

    printButton = XtVaCreateManagedWidget("printButton", 
                                            xmPushButtonGadgetClass, 
                                            widget,
                                            NULL);

    closeButton = XtVaCreateManagedWidget("closeButton", 
                                            xmPushButtonGadgetClass, 
                                            widget,
                                            NULL);

    // add the activate callbacks

    XtAddCallback(backButton, XmNactivateCallback, 
                  &mx_help_toolbar::activateCB, this);

    XtAddCallback(forwardButton, XmNactivateCallback, 
                  &mx_help_toolbar::activateCB, this);

    XtAddCallback(findButton, XmNactivateCallback, 
                  &mx_help_toolbar::activateCB, this);

    XtAddCallback(printButton, XmNactivateCallback, 
                  &mx_help_toolbar::activateCB, this);

    XtAddCallback(closeButton, XmNactivateCallback, 
                  &mx_help_toolbar::activateCB, this);

    // add the arm callbacks (which print up help messages)

    XtAddCallback(backButton, XmNarmCallback,
                  (XtCallbackProc) & mx_help_toolbar::armCB, (XtPointer) this);
    XtAddCallback(forwardButton, XmNarmCallback,
                  (XtCallbackProc) & mx_help_toolbar::armCB, (XtPointer) this);
    XtAddCallback(findButton, XmNarmCallback,
                  (XtCallbackProc) & mx_help_toolbar::armCB, (XtPointer) this);
    XtAddCallback(closeButton, XmNarmCallback,
                  (XtCallbackProc) & mx_help_toolbar::armCB, (XtPointer) this);
    XtAddCallback(printButton, XmNarmCallback,
                  (XtCallbackProc) & mx_help_toolbar::armCB, (XtPointer) this);

    // add the disarm callbacks (which remove help messages)

    XtAddCallback(backButton, XmNdisarmCallback,
                  (XtCallbackProc) & mx_help_toolbar::disarmCB,(XtPointer) this);
    XtAddCallback(forwardButton, XmNdisarmCallback,
                  (XtCallbackProc) & mx_help_toolbar::disarmCB,(XtPointer) this);
    XtAddCallback(findButton, XmNdisarmCallback,
                  (XtCallbackProc) & mx_help_toolbar::disarmCB,(XtPointer) this);
    XtAddCallback(closeButton, XmNdisarmCallback,
                  (XtCallbackProc) & mx_help_toolbar::disarmCB,(XtPointer) this);
    XtAddCallback(printButton, XmNdisarmCallback,
                  (XtCallbackProc) & mx_help_toolbar::disarmCB,(XtPointer) this);
}

void mx_help_toolbar::activateCB(Widget myWidget, XtPointer thisPtr,
                               XtPointer callData)
{
    int err = MX_ERROR_OK;

    mx_help_toolbar *me       = (mx_help_toolbar *) thisPtr;
    mx_help_window  *win      = (mx_help_window *) me->get_window();
    mx_statusbar * st = (mx_statusbar *) win->get_statusbar();
    mx_help_target  *target = win->get_target() ;

    win->set_busy();

    if(myWidget == me->forwardButton) 
    {
      target->forward(err) ;
      MX_ERROR_CHECK(err) ;
    } 
    else if(myWidget == me->backButton)
    {
      target->backward(err) ;
      MX_ERROR_CHECK(err) ;
    }
    else if(myWidget == me->findButton)
    {
      target->find(err);
      MX_ERROR_CHECK(err);
    }
    else if(myWidget == me->printButton)
    {
      target->print();
    }
    else if(myWidget == me->closeButton)
    {
        win->iconsise() ;
    }
    else
    {
      st->update("This button doesn't do anything yet.");
    }

    win->clear_busy();
    return;

  abort:
    win->clear_busy();
    global_error_trace->print();
    MX_ERROR_CLEAR(err);
}

void mx_help_toolbar::armCB(Widget myWidget, XtPointer thisPtr,
                          XtPointer callData)
{
    mx_help_toolbar *me       = (mx_help_toolbar *) thisPtr;
    mx_help_window  *win      = (mx_help_window *) me->get_window();
    mx_statusbar * st = (mx_statusbar *) win->get_statusbar();

    if(myWidget == me->backButton)
    {
        st->update("Go back a page.");
    }
    else if(myWidget == me->forwardButton)
    {
        st->update("Go forward a page.") ;
    }
    else if(myWidget == me->findButton)
    {
        st->update("Find help on a subject.") ;
    }
    else if(myWidget == me->closeButton)
    {
        st->update("Close this window.") ;
    }
    else if(myWidget == me->printButton)
    {
        st->update("Print this topic.") ;
    }
    else
    {
        st->update("No help for this button yet.");
    }
    
    return;
    
}

void mx_help_toolbar::disarmCB(Widget myWidget, XtPointer thisPtr,
                          XtPointer callData)
{
    mx_help_toolbar *me       = (mx_help_toolbar *) thisPtr;
    mx_help_window  *win      = (mx_help_window *) me->get_window();
    mx_statusbar * st = (mx_statusbar *) win->get_statusbar();

    st->update(MX_MAXWELL_VERSION);
    
    return ;
}

void mx_help_toolbar::set_forward_sensitive(bool isSensitive)
{
    XtSetSensitive(forwardButton,isSensitive ? True : False) ;
}

void mx_help_toolbar::set_backward_sensitive(bool isSensitive)
{
    XtSetSensitive(backButton,isSensitive ? True : False) ;
}

