/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * MODULE/CLASS : mx_help_menubar
 *
 * AUTHOR : David Miller
 *
 * DESCRIPTION:
 *
 *
 */

#include <stdlib.h>
#include <mx_menubar.h>
#include <Xm/Xm.h>
#include <Xm/PushB.h>
#include <mx.h>
#include <mx_about_d.h>
#include <mx_dialog_man.h>
#include <mx_help.h>

extern mx_dialog_manager *global_dialog_manager;


mx_help_menubar::mx_help_menubar(mx_window * parent) :
                mx_menubar("menuBar", parent)
{
    mx_menu    *aMenu;

    aMenu = add_sub_menu("fileItem");

    forward_button = aMenu->add_item("forwardItem", 
                                     &mx_help_menubar::fileCB, this) ;
        
    backward_button = aMenu->add_item("backwardItem", 
                                      &mx_help_menubar::fileCB, this) ;

    aMenu->add_item("findItem", &mx_help_menubar::fileCB, this); 

    aMenu->add_separator();

    aMenu->add_item("closeItem", &mx_help_menubar::fileCB, this); 

    aMenu->add_separator();

    aMenu->add_item("printItem", &mx_help_menubar::fileCB, this); 

    return;
}

void mx_help_menubar::fileCB(Widget myWidget, 
                             XtPointer thisPtr, 
                             XtPointer callData)
{
    mx_help_menubar *mb     = (mx_help_menubar *) thisPtr ;
    mx_help_window  *win    = (mx_help_window  *) mb->get_window() ;
    char            *name   = XtName(myWidget);
    mx_help_target  *target = win->get_target() ;
    
    int err = MX_ERROR_OK;

    win->set_busy() ;

    if (strcmp(name, "forwardItem") == 0)
    {
        target->forward(err) ;
        MX_ERROR_CHECK(err) ;
    }
    else if(strcmp(name, "backwardItem") == 0)
    {
        target->backward(err) ;
        MX_ERROR_CHECK(err) ;
    }
    else if(strcmp(name, "closeItem") == 0)
    {
        win->iconsise() ;
    }
    else if(strcmp(name, "printItem") == 0)
    {
        target->print();
    }
    else if(strcmp(name, "findItem") == 0)
    {
        target->find(err);
        MX_ERROR_CHECK(err);
    }

    win->clear_busy();
    return;
    
  abort:
    win->clear_busy();
    global_error_trace->print();
    MX_ERROR_CLEAR(err);
}

void mx_help_menubar::set_forward_sensitive(bool isSensitive)
{
    XtVaSetValues(forward_button->get_widget(), 
                  XmNsensitive, isSensitive ? True : False,NULL);
}

void mx_help_menubar::set_backward_sensitive(bool isSensitive)
{
    XtVaSetValues(backward_button->get_widget(), 
                  XmNsensitive, isSensitive ? True : False,NULL);
}






