/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * MODULE/CLASS :  mx_wp_editor
 *
 * AUTHOR : Andrew Haisley
 *
 * 
 *
 * DESCRIPTION:
 * 
 * help menu routines for wp editor
 *
 *
 *
 *
 */
#include <mx_wp_editor.h>
#include <mx_about_d.h>
#include <mx_help.h>
#include <mx_date_d.h>
#include <mx_open_d.h>
#include <mx_table_d.h>


void mx_wp_editor::help_about(int &err) 
{
    dialog_man.get_about_d()->run();
} 

void mx_wp_editor::help_support(int &err) 
{
    mx_editor::help_support(err);
} 

void mx_wp_editor::help_index(int &err) 
{
    if (help_window == NULL)
    {
        help_window = new mx_help_window(err, "top.rtf", this);
        MX_ERROR_CHECK(err);

        help_window->activate(err);
        MX_ERROR_CHECK(err);
    }

    help_window->deiconise();

abort:;
} 

void mx_wp_editor::help_window_closing()
{
    help_window = NULL;
}
