/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <mx.h>
#include <mx_font.h>
#include <mx_char_style.h>
#include <mx_para_style.h>

char *global_maxhome = NULL;

test1()
{
    int err = MX_ERROR_OK;

    global_maxhome = mx_string_copy("/usr/local/maxwell");

    mx_font *f;
    mx_paragraph_style *p;
    mx_char_style      *c;
    mx_line_style   *ls;
    mx_border_style *bs;
    mx_ruler *r;

    mx_font f1;
    mx_paragraph_style p1;
    mx_char_style      c1;
    mx_line_style   ls1;
    mx_border_style bs1, bs2;
    mx_ruler        r1;

    mx_font_mod            fm1, fm2;
    mx_char_style_mod      cm1, cm2;
    mx_paragraph_style_mod pm1, pm2;
    mx_border_style_mod    bm1, bm2;

    mx_tabstop tab(mx_left, 10);


    unsigned char buf[8000], *s;
    uint32 n;

    ls = new mx_line_style(mx_solid, 10);
    bs = new mx_border_style();
    r = new mx_ruler();

    f = new mx_font(err, "Utopia", 12, mx_normal);
    MX_ERROR_CHECK(err);

    c = new mx_char_style(*f);
    MX_ERROR_CHECK(err);

    p = new mx_paragraph_style();
    MX_ERROR_CHECK(err);

    p->set_char_style(*c);
    p->set_name("default");


    printf("line style serialised size:%ld\n", n = ls->get_serialised_size(err));
    MX_ERROR_CHECK(err);

    s = buf;
    ls->serialise(err, &s);
    MX_ERROR_CHECK(err);

    if ((s - buf) != n)
    {
        printf("line style serialised size wrong on serialise\n");
    }

    s = buf;
    ls1.unserialise(err, &s);
    MX_ERROR_CHECK(err);

    if ((s - buf) != n)
    {
        printf("line style serialised size wrong on unserialise\n");
    }

    if (ls1 != *ls)
    {
        printf("unserialised line style not equal to old line style\n");
    }



    printf("border style serialised size:%ld\n", n = bs->get_serialised_size(err));
    MX_ERROR_CHECK(err);

    s = buf;
    bs->serialise(err, &s);
    MX_ERROR_CHECK(err);

    if ((s - buf) != n)
    {
        printf("border style serialised size wrong on serialise\n");
    }

    s = buf;
    bs1.unserialise(err, &s);
    MX_ERROR_CHECK(err);

    if ((s - buf) != n)
    {
        printf("border style serialised size wrong on unserialise\n");
    }

    if (bs1 != *bs)
    {
        printf("unserialised border style not equal to old line style\n");
    }

    r->add_tab(err, tab);
    MX_ERROR_CHECK(err);

    printf("ruler serialised size:%ld\n", n = r->get_serialised_size(err));
    MX_ERROR_CHECK(err);

    s = buf;
    r->serialise(err, &s);
    MX_ERROR_CHECK(err);

    if ((s - buf) != n)
    {
        printf("ruler style serialised size wrong on serialise\n");
    }

    s = buf;
    r1.unserialise(err, &s);
    MX_ERROR_CHECK(err);

    if ((s - buf) != n)
    {
        printf("ruler serialised size wrong on unserialise\n");
    }

    if (r1 != *r)
    {
        printf("unserialised ruler not equal to old ruler\n");
    }


    printf("font serialised size:%ld\n", n = f->get_serialised_size(err));
    MX_ERROR_CHECK(err);

    s = buf;
    f->serialise(err, &s);
    MX_ERROR_CHECK(err);

    if ((s - buf) != n)
    {
        printf("font serialised size wrong on serialise\n");
    }

    s = buf;
    f1.unserialise(err, &s);
    MX_ERROR_CHECK(err);

    if ((s - buf) != n)
    {
        printf("font serialised size wrong on unserialise\n");
    }

    if (f1 != *f)
    {
        printf("unserialised font not equal to old font\n");
    }

    printf("char style serialised size:%ld\n", n = c->get_serialised_size(err));
    MX_ERROR_CHECK(err);

    s = buf;
    c->serialise(err, &s);
    MX_ERROR_CHECK(err);

    if ((s - buf) != n)
    {
        printf("char style serialised size wrong on serialise\n");
    }

    s = buf;
    c1.unserialise(err, &s);
    MX_ERROR_CHECK(err);

    if ((s - buf) != n)
    {
        printf("char style serialised size wrong on unserialise\n");
    }

    if (c1 != *c)
    {
        printf("unserialised char style not equal to old font\n");
    }

    printf("para style serialised size:%ld\n", n = p->get_serialised_size(err));
    MX_ERROR_CHECK(err);

    s = buf;
    p->serialise(err, &s);
    MX_ERROR_CHECK(err);

    if ((s - buf) != n)
    {
        printf("para style serialised size wrong on serialise\n");
    }

    s = buf;
    p1.unserialise(err, &s);
    MX_ERROR_CHECK(err);

    if ((s - buf) != n)
    {
        printf("para style serialised size wrong on unserialise\n");
    }

    if (p1 != *p)
    {
        printf("unserialised para style not equal to old para style\n");
    }


    printf("font mod serialised size:%ld\n", n = fm1.get_serialised_size(err));
    MX_ERROR_CHECK(err);

    s = buf;
    fm1.serialise(err, &s);
    MX_ERROR_CHECK(err);

    if ((s - buf) != n)
    {
        printf("font mod serialised size wrong on serialise\n");
    }

    s = buf;
    fm2.unserialise(err, &s);
    MX_ERROR_CHECK(err);

    if ((s - buf) != n)
    {
        printf("font mod serialised size wrong on unserialise\n");
    }

#if 0
    if (fm1 != fm2)
    {
        printf("unserialised font mod not equal to old font mod\n");
    }
#endif


    printf("char mod serialised size:%ld\n", n = cm1.get_serialised_size(err));
    MX_ERROR_CHECK(err);

    s = buf;
    cm1.serialise(err, &s);
    MX_ERROR_CHECK(err);

    if ((s - buf) != n)
    {
        printf("char mod serialised size wrong on serialise\n");
    }

    s = buf;
    cm2.unserialise(err, &s);
    MX_ERROR_CHECK(err);

    if ((s - buf) != n)
    {
        printf("char mod serialised size wrong on unserialise\n");
    }

#if 0
    if (cm1 != cm2)
    {
        printf("unserialised char mod not equal to old char mod\n");
    }
#endif


    printf("para mod serialised size:%ld\n", n = pm1.get_serialised_size(err));
    MX_ERROR_CHECK(err);

    s = buf;
    pm1.serialise(err, &s);
    MX_ERROR_CHECK(err);

    if ((s - buf) != n)
    {
        printf("para mod serialised size wrong on serialise\n");
    }

    s = buf;
    pm2.unserialise(err, &s);
    MX_ERROR_CHECK(err);

    if ((s - buf) != n)
    {
        printf("para mod serialised size wrong on unserialise\n");
    }

#if 0
    if (pm1 != pm2)
    {
        printf("unserialised para mod not equal to old para mod\n");
    }
#endif



    bs2.top_style.line_type = mx_solid;
    bs2.top_style.width = 2;
    bs2.top_style.colour.name = "blue";
    bs2.right_style.line_type = mx_solid;
    bs2.right_style.width = 2;
    bs2.right_style.colour.name = "blue";

    bm1 = mx_border_style_mod(bs1, bs2);

    printf("border mod serialised size:%ld\n", n = bm1.get_serialised_size(err));
    MX_ERROR_CHECK(err);

    s = buf;
    bm1.serialise(err, &s);
    MX_ERROR_CHECK(err);

    if ((s - buf) != n)
    {
        printf("border mod serialised size wrong on serialise\n");
    }

    s = buf;
    bm2.unserialise(err, &s);
    MX_ERROR_CHECK(err);

    if ((s - buf) != n)
    {
        printf("border mod serialised size wrong on unserialise\n");
    }

#if 0
    if (bm1 != bm2)
    {
        printf("unserialised border mod not equal to old border mod\n");
    }
#endif

    return 0;
abort:
    global_error_trace->print();
}

void test2()
{
    mx_font *f;
    mx_ruler *r;

    mx_paragraph_style *p;
    mx_char_style      *c;
    mx_line_style      *ls;
    mx_border_style    *bs;

    mx_paragraph_style_mod *pm;
    mx_char_style_mod      *cm;
    mx_font_mod *fm;

	while (TRUE)
	{
		f = new mx_font;
		r = new mx_ruler;
		p = new mx_paragraph_style;
		c = new mx_char_style;
		ls = new mx_line_style;
		bs = new mx_border_style;
		pm = new mx_paragraph_style_mod;
		cm = new mx_char_style_mod;
		fm = new mx_font_mod;

		delete f;
		delete r;
		delete p;
		delete c;
		delete ls;
		delete bs;
		delete pm;
		delete cm;
		delete fm;
	}
}

int main(int argc, char *argv[])
{
    int i;

    global_maxhome = new char[100];

    strcpy(global_maxhome, "/usr/local/maxwell");

    while (TRUE)
    {
        printf("serialise.........1\n");
        printf("create thrash.....2\n");

        printf("which>");
        scanf("%d", &i);

        switch (i)
        {
            case 1 : test1();
            case 2 : test2();
        }
    }
}
