/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef MX_SIZES_H
#define MX_SIZES_H

// paper sizes
#define MX_NUM_PAPER_SIZES 11
extern char  *mx_paper_size_names[MX_NUM_PAPER_SIZES];
extern float mx_paper_widths[MX_NUM_PAPER_SIZES];
extern float mx_paper_heights[MX_NUM_PAPER_SIZES];

// envelope sizes
#define MX_NUM_ENVELOPE_SIZES 10
extern char  *mx_envelope_size_names[MX_NUM_ENVELOPE_SIZES];
extern float mx_envelope_widths[MX_NUM_ENVELOPE_SIZES];
extern float mx_envelope_heights[MX_NUM_ENVELOPE_SIZES];

char *mx_paper_size_name(float w, float h);
char *mx_envelope_size_name(float w, float h);

#endif
