/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * MODULE/CLASS : mx_doc_file
 *
 * AUTHOR : Andrew Haisley
 *
 * 
 *
 * DESCRIPTION:
 * document file access
 *
 *
 *
 */
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <grp.h>
#include <pwd.h>
#include <fcntl.h>
#include <netinet/in.h>

#include <mx.h>
#include <mx_doc_file.h>

mx_doc_file::mx_doc_file()
{
}

mx_doc_file::~mx_doc_file()
{
}

void mx_doc_file::get_permissions(int &err, int fd)
{
    struct stat fs;
    struct passwd *pwd;
    struct group  *grp;

    err = MX_ERROR_OK;

    if (fstat(fd, &fs) == -1)
    {
        err = mx_translate_file_error(errno);
        return;
    }

    perm.owner_read  = ((fs.st_mode & S_IRUSR) != 0) ? 1 : 0;
    perm.owner_write = ((fs.st_mode & S_IWUSR) != 0) ? 1 : 0;
    perm.group_read  = ((fs.st_mode & S_IRGRP) != 0) ? 1 : 0;
    perm.group_write = ((fs.st_mode & S_IWGRP) != 0) ? 1 : 0;
    perm.other_read  = ((fs.st_mode & S_IROTH) != 0) ? 1 : 0;
    perm.other_write = ((fs.st_mode & S_IWOTH) != 0) ? 1 : 0;

    pwd = getpwuid(fs.st_uid);
    if (pwd == NULL)
    {
        err = MX_FILE_CANT_GET_PWD;
        return;
    }
    strcpy(owner.owner, pwd->pw_name);

    grp = getgrgid(fs.st_gid);
    if (grp== NULL)
    {
        err = MX_FILE_CANT_GET_GRP;
        return;
    }
    strcpy(owner.group, grp->gr_name);
}

// get owner information
const mx_owner_t *mx_doc_file::get_owner(int &err)
{
    err = MX_ERROR_OK;
    return &owner;
}

// get access information
const mx_access_permissions_t *mx_doc_file::get_perm(int &err)
{
    err = MX_ERROR_OK;
    return &perm;
}

void mx_doc_file::duplicate(int &err, char *new_file_name)
{
}
