/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * MODULE/CLASS : mx_permission
 *
 * AUTHOR : Andrew Haisley
 *
 * 
 *
 * DESCRIPTION:
 *
 * Types and structures used to describe ownership and access
 * permissions for database objects.
 *
 *
 *
 *
 */
#ifndef MX_PERMISSIONS_H
#define MX_PERMISSIONS_H

#include <mx.h>

#define MX_MAX_OWNER_LENGTH 50
#define MX_MAX_GROUP_LENGTH 50

typedef struct 
{
    char    owner[MX_MAX_OWNER_LENGTH];
    char    group[MX_MAX_GROUP_LENGTH];
} 
mx_owner_t;

typedef struct 
{
    int        owner_read : 1;
    int        owner_write: 2;
    int        group_read : 3;
    int        group_write: 4;
    int        other_read : 5;
    int        other_write: 6;
} 
mx_access_permissions_t;

typedef enum 
{ 
    mx_unlocked,        // not locked by anyone 
    mx_locked_self,     // locked by this user
    mx_locked_other     // locked by another user
} 
mx_lock_state_t;

typedef struct 
{
    mx_lock_state_t    lock;
    char            locked_by[MX_MAX_OWNER_LENGTH];
} 
mx_lock_t;

#endif
