/*
 *  This file is part of the Maxwell Word Processor application.
 *  Copyright (C) 1996, 1997, 1998 Andrew Haisley, David Miller, Tom Newton
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * MODULE/CLASS : node.C
 *
 * AUTHOR : David Miller
 *
 * This file 
 *
 * DESCRIPTION:
 * Module node.C
 * 
 *
 * 
 *
 */

#include "node.h"


/*-------------------------------------------------
 * FUNCTION: node::node
 *
 * DESCRIPTION: node constructor to create node and
 * add to tree
 *
 */

node::node(node *p, bool add_right) 
{
   count  = 1 ;
   parent = p ; 
   left   = NULL ; 
   right  = NULL ; 
   colour = NODE_RED  ;
   if(add_right) 
   {
      p->right = this ;
   }
   else
   {
      p->left = this ;
   }
}

/*-------------------------------------------------
 * FUNCTION: node::node
 *
 * DESCRIPTION: Standard node constructor
 */

node::node() 
{
   count  = 1 ;
   parent = NULL ; 
   left   = NULL ; 
   right  = NULL ; 
   colour = NODE_RED  ;
}
