#! /sbin/sh
# Purpose:
#	Extract the error messages from the checking.m4 sendmail rules and
#	convert them into a series of awk patterns for analysis of the log file
#
# Options:
#	NONE
#
# Parameters:
#	$1	name of file containing the HACK(checking) macro
#
# Exit Codes:
#	0	All OK
#	1	Cant access the checking source
#
# Comments:
#	Run the resulting program thus:
#	  nawk -f program logfile | sort -nr
#
# Revision History:
#	2.5	Andy Harper	May 1998	First version

# Defaults
  SRC=checking.m4

# Get parameter
  if [ "$1" != "" ]; then SRC=$1; fi

# Check access
  if [ ! -r "$SRC" ]; then
    echo "$0: no access to checking source" >&2
    exit 1
  fi

# select the rejection lines, modify text into awk patterns, add program actions too
  echo "{matched=0}"
  egrep "#error|# error" $SRC | cut -f2- | cut -d':' -f2- | tr -d "\"" | sed -e 's/$&{[a-zA-Z0-9_]*}/.*/g' -e 's/$&./.*/g' -e 's/$./.*/g' -e 's/\.\*\.\*/.*/g' -e 's/[]()?\/<>[]/\\&/g' | sort -u | cat -n | sed -e 's/^ *\([0-9]*\)[ 	]*[0-9]* *\(.*\)$/\/\2\/ {var\1++; matched=1}; BEGIN {var\1=0}; END {if (var\1 > 0) printf "%5d %s\\n", var\1, "\2"}/'
  echo "matched == 0 {other++} BEGIN {other=0} END {if (other > 0) printf \"%5d %s\\\n\", other, \"other\"}"
  exit 0
