.TH "figure" 2 " 04 June 1998" "Fractales Group" "Scilab Function"
.so ../sci.an
.SH NAME
figure - create a figure
.sp
Author: Bertrand Guiheneuf
.sp
This routine allows to create a tksci figure (window). 
.sp
.sp
.SH Usage
figure(\f(CR[\fPh\f(CR[\fP, \f(CR[\fPprop1, value1 \f(CR[\fP ...)
.SH Input parameter
.nr ll +1
.nr t\n(ll 0
.if \n(ll>1 .RS
.nr bi 1
.TP
o 
\fBh\fP : integer
Handle of the window to create. If not specified, the first free
handle is used
.nr bi 1
.TP
o 
 \fBprop{1, 2 ...}\fP : character string
name of a property to set
.nr bi 1
.TP
o 
 \fBval{1, 2 ...}\fP : scilab object
value to give to the corresponding property
.if \n(ll>1 .RE
.nr ll -1
.SH Output parameters
handle of the newly created window
.SH Description
This routine creates a tksci figure (toplevel window). If a handle is 
given, the figure corresponding to this handle is created . 
Otherwise, the window is created with the first free handle, that is the 
lowest integer not already used by a window.
The property named 'position' allows to control the geometrical aspect of the control. 
It is a \f(CR[\fP 1,4\f(CR]\fP real vector x y w h where the letters stand for the x location of the left bottom corner, the y location of the left bottom corner, the width and the height of the uicontrol.
 
One can also set this property by giving a string where the fields are separated by a '|', ie "x|y|w|h".
.SH EXAMPLE
.nf
h=figure(3);
// creates  figure number 1.
uicontrol( h, 'style','text', ...
 'string','This is a figure', ...
 'position',[50 70 100 100], ...
 'fontsize',15);
// put a  text in figure 3
figure();
// create figure 1
uicontrol( 'style','text', ...
 'string','Another figure', ...
 'position',[50 70 100 100], ...
 'fontsize',15);
// put a text in figure 1
close();
// close the current graphic window (ie fig. 1)
close(h);
// close figure 3
.fi 
.ec
.ft P
.sp
.SH See also
close, gcf
