.TH strong_con_nodes 1 "September 1995" "Scilab Group" "Scilab function"
.so ../sci.an
.SH NAME
strong_con_nodes - set of nodes of a strong connected component
.SH CALLING SEQUENCE
.nf
ns = strong_con_nodes(i,g)
.fi
.SH PARAMETERS
.TP 2
i
: integer, number of the strong connected component
.TP 2
g
: graph list
.TP 3
ns
: row vector, node numbers of the strong connected component
.SH DESCRIPTION
\fVstrong_con_nodes\fR returns the row vector \fVns\fR of the numbers of the
nodes which belong to the strong connected component number \fVi\fR.
.SH EXAMPLE
.nf
ta=[1 1 2 2 2 3 4 4 5 6 6 6 7 7 7 8 9 10 12 12 13 13 13 14 15];
he=[2 6 3 4 5 1 3 5 1 7 10 11 5 8 9 5 8 11 10 11 9 11 15 13 14];
g=make_graph('foo',1,15,ta,he);
g('node_x')=[197 191 106 194 296 305 305 418 422 432 552 550 549 416 548]; 
g('node_y')=[76 181 276 278 276 83 174 281 177 86 175 90 290 397 399];
show_graph(g);
ncomp=strong_con_nodes(3,g);
n=g('node_number');
nodecolor=0*ones(1,n); nodecolor(ncomp)=11*ones(ncomp);
g('node_color')=nodecolor;
nodediam=20*ones(1,n); nodediam(ncomp)=40*ones(ncomp);
g('node_diam')=nodediam;
x_message('Set of nodes of the strong connected component #3');
show_graph(g);
.fi
.SH SEE ALSO
connex, con_nodes, strong_connex
