.TH graph_power 1 "September 1996" "Scilab Group" "Scilab function"
.so ../sci.an
.SH NAME
graph_power - kth power of a directed 1-graph
.SH CALLING SEQUENCE
.nf
g1 = graph_power(g,k)
.fi
.SH PARAMETERS
.TP 2
g
: graph list of the graph
.TP 2
k
: integer
.TP 3
g1
: graph list of the new graph
.SH DESCRIPTION
\fVgraph_power\fR computes the directed graph \fVg1\fR which is the kth power 
of directed 1-graph \fVg\fR.
There is an arc between two nodes in \fVg1\fR if there exists a path between 
these nodes of length at most k in \fVg\fR.
\fVgraph_power(g,1)\fR is graph \fVg\fR.

If such a graph does not exist, an empty vector is returned.
.SH EXAMPLE
.nf
ta=[1 1 2 4 4 5 6 7 2 3 5 1];
he=[2 6 3 6 7 8 8 8 4 7 3 5];
g=make_graph('foo',1,8,ta,he);
g('node_x')=[285  284  335  160  405  189  118  45];
g('node_y')=[266  179   83  176  368  252  64  309];
show_graph(g);
g1=graph_power(g,2);
show_graph(g1,'new');
.fi
