.TH chol 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
chol - Cholesky factorization
.SH CALLING SEQUENCE
.nf
[R]=chol(X)
.fi
.SH PARAMETERS  
.TP
X 
: a symmetric positive definite real or complex matrix.
.SH DESCRIPTION
If \fVX\fR is positive definite, then \fVR = chol(X)\fR produces an upper 
triangular matrix \fVR\fR such that \fVR'*R = X\fR.
.LP
\fVchol(X)\fR uses only the diagonal and upper triangle of \fVX\fR.
The lower triangular is assumed to be the (complex conjugate) 
transpose of the upper.
.SH EXAMPLE
.nf
W=rand(5,5)+%i*rand(5,5);
X=W*W';
R=chol(X);
norm(R'*R-X)
.fi
.SH SEE ALSO 
spchol, qr, svd, bdiag, fullrf

