.TH plot3d 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
plot3d - 3D plot of a surface
.SH CALLING SEQUENCE
.nf
plot3d(x,y,z,[theta,alpha,leg,flag,ebox])
plot3d(xf,yf,zf,[theta,alpha,leg,flag,ebox])
plot3d(xf,yf,list(zf,colors),[theta,alpha,leg,flag,ebox])
.fi
.SH PARAMETERS
.TP 13
x,y
: row vectors of sizes n1 and n2 (x-axis and y-axis coordinates). These
coordinates must be monotone.
.TP 13
z
: matrix of size (n1,n2). \fVz(i,j)\fR is the value of the surface at the point
(x(i),y(j)).
.TP
xf,yf,zf
: matrices of size (nf,n). 
They define the facets used to draw the surface. There are \fVn\fR
facets.
Each facet \fVi\fR is defined by a polygon with \fVnf\fR points. 
The x-axis, y-axis and z-axis coordinates of the points of the ith
facet
are given respectively by \fVxf(:,i)\fR, \fVyf(:,i)\fR and
\fVzf(:,i)\fR.

You can give a specific 
color for each facet by using \fVlist(zf,colors)\fR instead of \fVzf\fR,
where \fVcolors\fR is a vector of size \fVn\fR. \fVcolors(i)\fR is the
color of facet \fVi\fR. If \fVcolors(i)\fR is negative, color id
\fV-colors(i)\fR is used and the boundary of the facet is drawn.
Use \fVxset()\fR to see the ids of the colors.
.TP
theta, alpha 
: real values giving in degree the spherical coordinates of 
the observation point.
.TP
leg 
: string defining the captions for each axis with @ as a field
separator, for example "X@Y@Z".
.TP
flag
: a real vector of size three \fVflag=[mode,type,box]\fR.
.RS 
.TP 5
mode 
: string (treatment of hidden parts).
.RS
.TP 
mode>0 
the hidden parts of the surface are removed and the surface is painted 
with color \fVmode\fR.
.TP
mode=0
the hidden parts of the surface are drawn.
.TP
mode<0
only the shadow of the surface is painted with color or pattern id
\fV-mode\fR. Use \fVxset()\fR to see the meaning of the ids.
.RE
.TP
type 
: an integer (scaling).
.RS 
.TP 8
type=0
the plot is made using the current 3D scaling (set by a previous call to
\fVparam3d\fR, \fVplot3d\fR, \fVcontour\fR or \fVplot3d1\fR).
.TP
type=1
the boundaries are specified by the value of the optional argument \fVebox\fR.
.TP
other values
the boundaries are computed using the given data.
.RE
.TP
box
: an integer (frame around the plot).
.RS
.TP
box=0 
nothing is drawn around the plot.
.TP
box=1 
unimplemented (like box=0).
.TP
box=2 
only the axes behind the surface are drawn.
.TP
box=3 
a box surrounding the surface is drawn and captions are added.
.TP
box=4
a box surrounding the surface is drawn, captions and axes are added.
.RE
.RE
.TP
ebox
: used when \fVtype\fR in \fVflag\fR is 1. It specifies the boundaries
of the plot as the vector \fV[xmin,xmax,ymin,ymax,zmin,zmax]\fR.
.SH DESCRIPTION
\fVplot3d(x,y,z,[theta,alpha,leg,flag,ebox])\fR draws the surface
\fVz=f(x,y)\fR.

\fVplot3d(xf,yf,zf,[theta,alpha,leg ,flag,ebox])\fR draws a
surface defined by a set of facets. You can draw multiple plots by replacing
\fVxf\fR, \fVyf\fR and \fVzf\fR by multiple matrices assembled by rows
as \fV[xf1 xf2 ...]\fR, \fV[yf1 yf2 ...]\fR and \fV[zf1 zf2 ...]\fR.

You can use the function \fVgenfac3d\fR to compute four sided facets
from the surface \fVz=f(x,y)\fR. \fVeval3dp\fR can also be used.

Enter the command  \fVplot3d()\fR to see a demo.
.SH EXAMPLE
.nf
// simple plot using z=f(x,y)
t=[0:0.3:2*%pi]'; z=sin(t)*cos(t');
plot3d(t,t,z)
// same plot using facets computed by genfac3d
[xx,yy,zz]=genfac3d(t,t,z);
xbasc()
plot3d(xx,yy,zz)
// multiple plots
xbasc()
plot3d([xx xx],[yy yy],[zz 4+zz])
// multiple plots using colors
xbasc()
plot3d([xx xx],[yy yy],list([zz zz+4],[4*ones(1,400) 5*ones(1,400)]))
// simple plot with viewpoint and captions
xbasc()
plot3d(1:10,1:20,10*rand(10,20),35,45,"X@Y@Z",[2,2,3])
// plot of a sphere using facets computed by eval3dp
deff("[x,y,z]=sph(alp,tet)",["x=r*cos(alp).*cos(tet)+orig(1)*ones(tet)";..
  "y=r*cos(alp).*sin(tet)+orig(2)*ones(tet)";..
  "z=r*sin(alp)+orig(3)*ones(tet)"]);
r=1; orig=[0 0 0];
[xx,yy,zz]=eval3dp(sph,linspace(-%pi/2,%pi/2,40),linspace(0,%pi*2,20));
xbasc()
plot3d(xx,yy,zz)
.fi
.SH SEE ALSO
eval3dp, genfac3d, geom3d, param3d, plot3d1, xset
.SH AUTHOR
J.Ph.C.
