.TH projsl 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
projsl - linear system projection
.SH CALLING SEQUENCE
.nf
[slp]=projsl(sl,Q,M)
.fi
.SH PARAMETERS
.TP 15
sl,slp
: \fVsyslin\fR lists
.TP 15
Q,M
: matrices (projection factorization)
.SH DESCRIPTION
\fVslp\fR= projected model of \fVsl\fR where \fVQ*M\fR is the full rank 
factorization of the projection.
.LP
If \fV(A,B,C,D)\fR is the representation of \fVsl\fR, the projected model
is given by \fV(M*A*Q,M*B,C*Q,D)\fR.
.LP
Usually, the projection \fVQ*M\fR is obtained as the spectral projection
of an appropriate auxiliary matrix \fVW\fR e.g. \fVW\fR = product
of (weighted) gramians or product of Riccati equations.
.SH EXAMPLE
.nf
rand('seed',0);sl=ssrand(2,2,5);[A,B,C,D]=abcd(sl);poles=spec(A)
[Q,M]=pbig(A,0,'c');  //keeping unstable poles
slred=projsl(sl,Q,M);spec(slred('A'))
sl('D')=rand(2,2);  //making proper system
trzeros(sl)  //zeros of sl
wi=inv(sl);  //wi=inverse in state-space
[q,m]=psmall(wi('A'),2,'d');  //keeping small zeros (poles of wi) i.e. abs(z)<2
slred2=projsl(sl,q,m);
trzeros(slred2)  //zeros of slred2 = small zeros of sl
//  Example keeping second order modes
A=diag([-1,-2,-3]);
sl=syslin('c',A,rand(3,2),rand(2,3));[nk2,W]=hankelsv(sl)
[Q,M]=pbig(W,nk2(2)-%eps,'c');    //keeping 2 eigenvalues of W
slr=projsl(sl,Q,M);  //reduced model
hankelsv(slr)
.fi
.SH SEE ALSO
pbig
.SH AUTHOR
F. D.

