/* gread.c     read in data from a GIF format file    -jpb 6/25/95    */

/* gread.c   uses routines from the gd 1.1.1 library:
   ----------------------------------------------------------------------
   gd 1.1.1 is copyright 1994, Quest Protein Database Center, Cold Spring
   Harbor Labs. Permission granted to copy and distribute this work
   provided that this notice remains intact.

	Tom Boutell, boutell@netcom.com
	http://sunsite.unc.edu/boutell/index.html
	116 14th Ave E Apt 2
	Seattle, WA 98102
*/

#include <stdio.h>                      /* fopen() sprintf() etc. */
#include <stdlib.h>                     /* strtod() */
#include <string.h>                     /* strcpy() */

#include <gd.h>
#include <gdfontl.h>
#include <gdfonts.h>
#include "hcon.h"

extern unsigned int xsize, ysize;     /* size of hf array (input xsize+2) */
extern float *hf;                            /* height field array */

/* ---------------------------------------------------------------------- */
/* gread() --   read in data to hf array (xsize x ysize) from a GIF file  */
/*              <fname>, interpreting the index as the value, ignoring    */
/*              the color pallette entirely.                              */
/* ---------------------------------------------------------------------- */

int gread(char *fname)
{
    FILE *pin;
    gdImagePtr im;
    int x,y;
    long unsigned hsize;

    pin = fopen(fname, "rb");
    if (pin == NULL) {
      fprintf(stderr,"Could not open %s.\n",fname);
    }
    im = gdImageCreateFromGif(pin);
    fclose(pin);

    xsize = gdImageSX(im);
    ysize = gdImageSY(im);

   hsize = xsize * ysize * sizeof(PTYPE);
   if ( (hf = (PTYPE *) malloc((size_t)hsize) ) == NULL)   {
     fprintf(stderr,"Could not allocate %lu bytes for image.\n",hsize);
     exit(1);
   }
   memset(hf,(char) 0, (size_t) hsize);

    for (x=0;x<xsize;x++) {    /* transfer pixel array to hf data  */
      for (y=0;y<ysize;y++) {
	  El(hf,x,y) = (float) (im->pixels[x][y]) / 255.0;
      }
    }
    gdImageDestroy(im);         /* free up memory */
    return(0);
}

/* ---------------------------------------------------------------------- */
/* gread1() --   same as gread() but take heightfield and size arguments  */
/*              as passed, rather than globals.                           */
/* ---------------------------------------------------------------------- */

int gread1(PTYPE **hh, unsigned int *xs, unsigned int *ys, char *fname)
{
    FILE *pin;
    gdImagePtr im;
    int x,y;
    long unsigned hsize;
    unsigned int xsize, ysize;         /* needed for El() macro */

    pin = fopen(fname, "rb");
    if (pin == NULL) {
      fprintf(stderr,"Could not open %s.\n",fname);
    }
    im = gdImageCreateFromGif(pin);
    fclose(pin);

    xs[0] = gdImageSX(im);
    ys[0] = gdImageSY(im);
    xsize = xs[0];
    ysize = ys[0];

   hsize = xsize * ysize * sizeof(PTYPE);
   if ( (hh[0] = (PTYPE *) malloc((size_t)hsize) ) == NULL)   {
     fprintf(stderr,"Could not allocate %lu bytes for image.\n",hsize);
     exit(1);
   }
   memset(hh[0],(char) 0, (size_t) hsize);

    for (x=0;x<xsize;x++) {    /* transfer pixel array to hf data  */
      for (y=0;y<ysize;y++) {
	  El(hh[0],x,y) = (float) (im->pixels[x][y]) / 255.0;
      }
    }
    gdImageDestroy(im);         /* free up memory */
    return(0);
}
