/*****************************************************************************
 * Name:            aeromat2.inc
 * Author:	    Hartmut Keller
 * Last Change:     8. Apr 94
 * AERO version:    V1.5 and newer
 * 
 * Description:
 * ------------
 * This is a sample POV-Ray V2.x include file for materials used by AERO. This
 * file is included by aeropov2.inc and describes all default materials within
 * AERO.
 *
 * When AERO creates a POV-Ray V2.x scene file it uses the following layered 
 * texture for any given material:
 *
 *    texture
 *    {
 *       pigment 
 *       {
 *          color red <redval> green <greenval> blue <blueval>
 *                filter aero<mat>filter
 *       }
 *    }
 *    texture
 *    {
 *       aero<mat>
 *    }
 *
 * There, <mat> is the appropriate material name, <redval>, <greenval>, and
 * <blueval> are the color values set from AERO. The idea is to get a solid
 * texture with the desired color as grounding and a texture with grains,
 * roughness and light effects as surface. At every place where you want the
 * solid color to shine through you define a filter value >0 in the surface
 * texture. 
 *
 * So you have to #declare two items for each used material here in this file:
 *  1.) a filter value for the solid texture to describe the material
 *      transparency (e.g. objects permeable to light like glass)
 *  2.) a surface texture describing the finish of the object including grain,
 *      roughness, etc.
 *
 * If you add a new material to the material list of AERO you also have to add
 * another material filter and texture to this file to describe this new
 * material to the Raytracer. If you use a whole new material table then you
 * most probably like to use a whole new material include file for POV-Ray V2.x 
 * also. Then you have to change the appropriate #include command in the
 * aeropov2.inc file.
 *
 * Remark: The method used in AERO when outputting POV-Ray V2.x code differs
 * strongly from the one used when creating POV-Ray V1.0 code. So the
 * instructions described above are only applicable when working with POV-Ray
 * V2.x.
 *****************************************************************************/


/***********************************************
 * IRON:
 * Default-Color: 	R: 0.35686275
 * 			G: 0.41176471
 *                      B: 0.56078431
 ***********************************************/

#declare aeroironfilter = 0.0		/* Transparency 0% */

#declare aeroiron =			/* Iron Surface design */
texture
{
    pigment {color red 1 green 1 blue 1 filter 1.0}
    finish
    {
	ambient 0.3
	metallic
	diffuse 0.6
	brilliance 5.0  /* war 7.0 */
	specular 1.0
	roughness 0.01
    }
}



/***********************************************
 * PLASTIC:
 * Default-Color:  	R: 0.24705882
 *			G: 0.77254902
 *			B: 0.16862745
 ***********************************************/

#declare aeroplasticfilter = 0.0	/* Transparency 0% */

#declare aeroplastic =			/* Plastic Surface Design */
texture
{
    pigment {color red 1 green 1 blue 1 filter 1.0}
    finish
    {
	ambient 0.15
	diffuse 0.6
	specular 1.0
	roughness 0.05
	brilliance 1.0
    }
}



/***********************************************
 * CORK:
 * Default-Color:     	R: 0.57647059
 *                      G: 0.45098039
 *			B: 0.31764706
 ***********************************************/

#declare aerocorkfilter = 0.0		/* Transparency 0% */

#declare aerocork =			/* Cork Surface Design */
texture
{
    pigment
    {
	granite
	color_map
	{
	    [0.4  color red 0 green 0 blue 0 filter 0.0]
	    [0.4  color red 0.85 green 0.85 blue 0.95 filter 0.2]
	    [0.45 color red 0.85 green 0.85 blue 0.95 filter 0.2]
	    [0.5  color red 0.752941 green 0.752941 blue 0.752941 filter 0.2]
	    [0.55 color red 0.82 green 0.57 blue 0.46 filter 1.0]
            [0.9  color red 0.82 green 0.57 blue 0.46 filter 1.0]
	    [0.9  color red 1.0 green 1.0 blue 1.0 filter 0.2]
	}
    	turbulence 0
	scale <0.12 0.12 0.12>
    }
    finish
    {
	specular 0.1
    }
}



/***********************************************
 * ICE:
 * Default-Color:     	R: 0.80392157
 *			G: 0.96862745
 *			B: 1.0
 ***********************************************/

#declare aeroicefilter = 0.9		/* Transparency 90% */

#declare aeroice =			/* Ice Surface Design */
texture
{
    pigment
    { 
	agate
	agate_turb 0.5
	color_map
	{
	    [0.9  color red 1.0 green 1.0 blue 1.0 filter 1.0]
	    [0.95 color red 1.0 green 1.0 blue 1.0 filter 0.8]
	    [1.0  color red 1.0 green 1.0 blue 1.0 filter 1.0]
	}
    }
    finish
    {
	ambient 0.0
	diffuse 0.7
	specular 0.3
        reflection 0.03
	refraction 1.0
	ior 1.3
        roughness 0.1
    }
}



/***********************************************
 * GLASS:
 * Default-Color:   	R: 1.0
 *       		G: 0.91372549
 *			B: 1.0
 ***********************************************/

#declare aeroglassfilter = 1.0		/* Transparency 100% */

#declare aeroglass =			/* Glass Surface Design */
texture
{
    pigment {color red 1.0 green 1.0 blue 1.0 filter 1.0}
    finish
    {
	specular 1.0
	roughness 0.0005
	ambient 0.0
	diffuse 0.0
	reflection 0.1
	refraction 1.0
	ior   1.5
    }
}



/***********************************************
 * GRANITE:
 * Default-Color:    	R: 0.39607843
 *			G: 0.36470588
 *			B: 0.3254902
 ***********************************************/

#declare aerogranitefilter = 0.0	/* Transparency 0% */

#declare aerogranite =			/* Granite Surface Design */
texture
{
    pigment
    {
	granite
	color_map
	{
	    [0.4  color red 0.0 green 0.0 blue 0.0 filter 0.3]
            [0.4  color red 0.85 green 0.85 blue 0.95 filter 0.3]
	    [0.45 color red 0.85 green 0.85 blue 0.95 filter 0.3]
	    [0.5  color red 0.752941 green 0.752941 blue 0.752941 filter 0.3]
	    [0.55 color red 0.82 green 0.57 blue 0.46 filter 1.0]
	    [0.8  color red 0.82 green 0.57 blue 0.46 filter 1.0]
	    [1.0  color red 1 green 0.5 blue 0.0 filter 1.0]
	}
	turbulence 0
    }
}



/***********************************************
 * GOLD:
 * Default-Color:     	R: 0.8
 *			G: 0.49803922
 *			B: 0.19607843
 ***********************************************/

#declare aerogoldfilter = 0.0		/* Transparency 0% */

#declare aerogold =			/* Gold Surface Design */
texture
{
    pigment {color red 0.8 green 0.498039 blue 0.196078 filter 0.5}
    finish
    {
	metallic
	ambient 0.2
	diffuse 0.7
	brilliance 6.0
	reflection 0.25
	phong 0.75
	phong_size 80
    }
}



/***********************************************
 * ALU: 
 * Default-Color:     	R: 0.85882353
 *			G: 0.84313725
 *			B: 0.86666667
 ***********************************************/

#declare aeroalufilter = 0.0		/* Transparency 0% */

#declare aeroalu =			/* Alu Surface Design */
texture
{
    pigment {color red 0.85882353 green 0.84313725 blue 0.86666667 filter 0.4}
    finish
    {
	ambient .15
	reflection 0.05
	roughness 0.3
	phong 0.05
	phong_size 80
    }
}



/***********************************************
 * WOOD:
 * Default-Color:     	R: 0.59215686
 *			G: 0.37254902
 *			B: 0.0
 ***********************************************/

#declare aerowoodfilter = 0.0		/* Transparency 0% */

#declare aerowood =			/* Wood Surface Design */
texture
{
    pigment
    {
	wood
	color_map
    	{
	    [0.7  color red 1 green 1 blue 1 filter 1.0]
	    [0.7  color red 0.1 green 0.1 blue 0.1 filter 0.5]
            [1.0  color red 0.0 green 0.0 blue 0.0 filter 0.0]
    	}
	quick_color filter 1.0
	turbulence .04	
	rotate <0 0 70>
	rotate <0 20 0>
	scale <.01 .03 .01>
	translate <0 3 0>
    }
    finish
    {
    	ambient .15
    }
}


/***********************************************
 * CONCRETE:
 * Default-Color:     	R: 0.49803922
 *			G: 0.52941176
 *			B: 0.56862745
 ***********************************************/

#declare aeroconcretefilter = 0.0	/* Transparency 0% */

#declare aeroconcrete =			/* Concrete Surface Design */
texture
{
    pigment
    {
	granite
	color_map
	{
	    [ 0.0  color red 0.1 green 0.1 blue 0.1 filter 0.0]
	    [ 0.25 color red 0.5 green 0.53 blue 0.57 filter 0.4]
	}
	scale 0.03
    }
    finish
    {
	ambient 0.1
	reflection 0.0
	specular 0.1
	roughness 0.8
    }
}



/***********************************************
 * BRICK:
 * Default-Color:      	R: 1.0
 *			G: 0.2
 *			B: 0.023529412
 ***********************************************/

#declare aerobrickfilter = 0.0		/* Transparency 0% */

#declare aerobrick =			/* Brick Surface Design */
texture
{
    pigment
    {
	granite
	color_map
	{
	    [ 0.0  color red 0.0 green 0.0 blue 0.0 filter 0]
	    [ 0.15 color red 0.2 green 0.04 blue 0.0 filter 0.3]
	    [ 0.15 color red 1.0 green 0.2 blue 0.02353 filter 0.6]
	}
	scale 0.1
    }
    finish
    {
	ambient 0.1
	diffuse 0.7
	reflection 0.0
	specular 0.1
	roughness 0.8
    }
}


/***********************************************
 * RUBBER:
 * Default-Color:     	R: 0.74117647
 *			G: 0.67058824
 *			B: 0.55294118
 ***********************************************/

#declare aerorubberfilter = 0.0		/* Transparency 0% */

#declare aerorubber =			/* Rubber Surface Design */
texture
{
    pigment {color red 0.74117647 green 0.67058824 blue 0.55294118 filter 0.8}
    finish
    {
	ambient 0.15
	diffuse 0.7
	roughness 0.6
	reflection 0.0
    }
}





