
/*--------------------------------------------------------------*/
/* 								*/
/* xmsql version 0.4						*/
/*								*/
/* xmsql is a X interface to the mSQL database			*/
/*								*/
/* xmsql is distributed WITHOUT ANY WARRENTY; 			*/
/* see README for details.					*/
/* Copyright (C) 1995 Stefan Dupont-Christ			*/
/* Heavily modified by Debursky Ko (debursky@deb.lumax.com.tw)  */
/*--------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/BulletinB.h>
#include <Xm/ArrowB.h>
#include <Xm/Frame.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/PushB.h>
#include <Xm/FileSB.h>
#include <Xm/Label.h>
#include <Xm/PushBG.h>
#include <Xm/SeparatoG.h>
#include <Xm/MenuShell.h>
#include <Xm/MainW.h>
#include <Xm/MessageB.h>
#include <Xm/FileSB.h>
#include <Xm/DialogS.h>
#include <Xm/TextF.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>

#include "common.h"

/*
extern void connectRemoteServer(Widget, XEvent*, String*, Cardinal*);
*/

XtAppContext     theAPP;
Display          *appDisplay = NULL;
CWidgets         cWidgets; 
Widget           cmBox;
CmList           *cmList;

void setStatusLine(String msg)
{
  XmTextFieldSetString(cMsql.status, msg);
}

Pixel GetNamedColor(widget, colorname)
Widget widget;
String colorname;
{
        Display  *display;
        Colormap cmap;
        XColor   alloc_color, exact_color;

        display = XtDisplay(widget);
        XtVaGetValues(widget, XtNcolormap, &cmap, NULL);

        if ( XAllocNamedColor(display, cmap, colorname,
             &alloc_color, &exact_color))
                return alloc_color.pixel;
        else {
                setStatusLine("Can't allocate color");
                return (Pixel) NULL;
        }
}                

Pixel FreeColor(widget, pixel_value)
Widget widget;
Pixel pixel_value;
{

        Colormap cmap;

        XtVaGetValues(widget, XtNcolormap, &cmap, NULL);

        XFreeColors(XtDisplay(widget), cmap, &pixel_value,1, 0);
}                



void activate(Widget w, XtPointer client, XtPointer call)
{
        char *name,*value;

        name=(char *)client;
        value=XmTextFieldGetString(w);
if (debug)
        fprintf(debugfp,"activate %s: value=%s\n",name,value);
        XtFree(value);
}

void Print(Widget w, XtPointer client, XtPointer call)
{
	XmCommandCallbackStruct *p = (XmCommandCallbackStruct *)call;
	char			*t;

	XmStringGetLtoR(p->value, XmFONTLIST_DEFAULT_TAG, &t);
	fprintf(stderr, "Command : '%s'\n", t);
	XtFree(t);
}

void Quit(Widget w, XtPointer client, XtPointer call)
{
        FreeColor(toplevel,blue);
        FreeColor(toplevel,black);
        FreeColor(toplevel,green);
        FreeColor(toplevel,grey);
        FreeColor(toplevel,red);
	exit(0);
}

void SetError(Widget w, XtPointer client, XtPointer call)
{
	Widget		c = (Widget)client;
	XmString	xms = XmStringCreateSimple("This is error text");

	XmCommandError(c, xms);
	XmStringFree(xms);
}


static void event_handler(Widget w, XtPointer client, XEvent* event,
                          Boolean* dispatching)
{
        Widget menuPopup;

        menuPopup = (Widget) client;

        if (menuPopup == NULL) 
                return;

        if (event->xbutton.button == Button3) {
                XmMenuPosition(menuPopup, 
                              (XButtonPressedEvent*) event);
                XtManageChild(menuPopup);
        }
}

void okCB(Widget w, XtPointer client, XtPointer call)
{
}

void cancelCB(Widget w, XtPointer client, XtPointer call)
{
}

void helpCB(Widget w, XtPointer client, XtPointer call)
{
}

void filecancelCB(Widget w, XtPointer client, XtPointer call)
{
        XtDestroyWidget(w);
}

void insertLst(CmList *head, CmList *flist)
{     
    flist->next = head;
    flist->prev = head->prev;
    head->prev->next = flist;
    head->prev = flist;
  
    cMsql.cmCount++;
}          

void removeLst(CmList *flist)
{
    flist->prev->next = flist->next;
    flist->next->prev = flist->prev;
}          

void emptyLsts(CmList *flist)
{
    while (cMsql.cmCount-- > 0) {
          removeLst(flist);
    } 
}          

void insertFld(Flist *head, Flist *flist)
{     
    flist->next = head;
    flist->prev = head->prev;
    head->prev->next = flist;
    head->prev = flist;
}          

void removeFld(Flist *flist)
{
    flist->prev->next = flist->next;
    flist->next->prev = flist->prev;
}          

void emptyFlds(Flist *flist)
{
    while (cMsql.currentFld-- > 0) {
          removeFld(flist);
    } 
}          

void rewindFlds(Flist *flist)
{

    cMsql.flist = cMsql.flist->prev;

    while (cMsql.flist->type > 0)
             cMsql.flist = cMsql.flist->prev;

    cMsql.flist = cMsql.flist->next;
}

void openDbase()
{

    static char  record[400];
    static char  fstring[48];
    static char  qstr[1024];
    static char  tmp[80];
    static char  nulstr[40];
    static char  isnull[40];
    static char  *tmpstr;

    static int   i, field;
    static int   rec_len;
    static int   rec_no;
  
    FILE         *fptr;
    FILE         *ofptr;

    fprintf(debugfp,"Enter OpenDbase !\n");
    sprintf(qstr,"cp %s tmp.dbf",cMsql.file);
    system(qstr);
    fptr=fopen("tmp.dbf","rb");
    if (fptr == NULL) fprintf(debugfp,"\nOPEN Failed !");

    ofptr=fopen("xmsql.log","w");

    fread(fstring,1, 32, fptr);

    printf("VER: %d\tmm/dd/yy: %d/%d/%d\n",fstring[0],
           fstring[1],fstring[2],fstring[3]);
    printf("NDR: %x/%x/%x/%x\n",fstring[4],
           fstring[5],fstring[6],fstring[7]);
    printf("HSZ: %x/%x\tDRS: %x/%x\n",fstring[8],
           fstring[9],fstring[10],fstring[11]);

    emptyFlds(cMsql.flist);
    cMsql.currentFld = 0;
    
    field = 0;        
    while (fread(fstring,1,32,fptr) > 0)  {
         Flist   *flist = (Flist *)malloc(sizeof(Flist));
         if (fstring[0] == 0xd) break;

         i = 0;
         while (fstring[i++] != 0);
 
         flist->fld = (char *)malloc(i+1);
         strncpy (flist->fld,fstring,i+1);
         flist->type    = fstring[11];
         flist->length  = fstring[16];
         flist->decimal = fstring[17];
         insertFld(cMsql.flist,flist);
         cMsql.currentFld++;
         cMsql.fldsCount++;
         rec_len += fstring[16];
    }
    
    sprintf(qstr,"drop table %s",cMsql.table);
    fprintf(debugfp,"Start %s\n",qstr);
    if (msqlQuery(cMsql.connection, qstr) == -1)
         fprintf(debugfp,"Query Failed !\n");

    fprintf(debugfp,"After drop table, Rec_len : %d\n",rec_len);
    bzero(qstr,sizeof(qstr));
    sprintf(qstr,"create table %s(",cMsql.table);
    
    rewindFlds(cMsql.flist);

    for (i=0; i < cMsql.fldsCount; i++) {
         switch (cMsql.flist->type)  {
         case 'C': sprintf(tmp, " %s char(%d)",cMsql.flist->fld,
                                               cMsql.flist->length);
                   break;
         case 'N': if (cMsql.flist->decimal == 0)
                       sprintf(tmp, " %s int",cMsql.flist->fld);
                   else
                       sprintf(tmp, " %s real",cMsql.flist->fld);
                   break;
         default : break;
         }
         strcat (qstr, tmp);
         if (i == (field-1)) 
              strcat (qstr, ")");
         else strcat (qstr, ",");
         
         cMsql.flist = cMsql.flist->next; 
    }     
    
    msqlQuery(cMsql.connection, qstr);
    fprintf(ofptr,"\nAfter %s", qstr);
    
    rewindFlds(cMsql.flist);
    fseek(fptr,-30,SEEK_CUR);
    i = rec_no = 0; 
    while ((fread(record,1,cMsql.flist->length,fptr))>0)  {
          if (i == 0)  { 
                 rec_no++;
                 bzero(qstr,sizeof(qstr));
                 sprintf(qstr,"insert into %s values (",cMsql.table);
          }    
          if (i > 0) 
                 strcat (qstr, ",");
          
          tmpstr = strtok(record,"  ");

          if (cMsql.flist->type == 'C') {
                 sprintf(isnull,"%s",tmpstr);
                 if (!strcmp(isnull,"(null)")) 
                     sprintf(nulstr,"'!n'");
                 else
                     sprintf(nulstr,"'%s'",tmpstr);
	  }

/* Type Real is included here. No code needed! */

          if (cMsql.flist->type == 'N')  
                 if (record[cMsql.flist->length - 1] == ' ') 
                     sprintf(nulstr,"%s","0");
                 else
                     sprintf(nulstr,"%s",tmpstr);
          strcat(qstr, nulstr);
          i++;       
          if (i == field) {
                 i = 0;
                 strcat(qstr, ")");
                 if (msqlQuery(cMsql.connection, qstr) == -1) {
                      fprintf(ofptr,"\nInsert Failed %s",qstr);
                 }
                 fseek(fptr,1,SEEK_CUR);
          }   

          bzero(record,sizeof(record));
          bzero(isnull,sizeof(isnull));
          bzero(nulstr,sizeof(nulstr));
          
          cMsql.flist = cMsql.flist->next;    
    }
    
    cMsql.currentFld = cMsql.fldsCount;

    fclose(fptr);
    fclose(ofptr);

}   


void fileCB(Widget w, XtPointer client, XtPointer call)
{
        XmFileSelectionBoxCallbackStruct* ptr = 
        (XmFileSelectionBoxCallbackStruct*) call;

        char*                             string;
        char*                             tmptbl;
        char                              tmp[50];
        int                               dir_pos;
        int                               i;
        int                               table_len;


        XmStringGetLtoR(ptr->value, XmSTRING_DEFAULT_CHARSET, &string);
      
        cMsql.file = string;
        table_len = strlen(string);
        strcpy(tmp , string);

        i = 1;
        while (i < 50 )  
              if (tmp[i++] == '/') dir_pos=i-1;
           
        for (i=0; i < (table_len - dir_pos); i++)
                tmp[i] = tmp[i+dir_pos+1] ;

        tmp[i+1] = 0x0d;        
        tmptbl = (char*)malloc((dir_pos + 1)* sizeof(char));
        strncpy(tmptbl, tmp, dir_pos);
        cMsql.table = strtok(tmptbl,".");
        fprintf(debugfp,"Opened table: %s\tFile : %s\n",cMsql.table,cMsql.file);
        free (tmptbl);
        XtFree(string);
        XtDestroyWidget(w);
        
        openDbase();

}

void createSQLtable(table,type)
char *table;
int  type;
{

        static char      tmpstr[50];
        static char      qstr[1024];

        int              i, j, k;
        int              len;  

        fprintf(debugfp,"Start to do Table %s\n",table);
        bzero(qstr,sizeof(qstr));
        if (type == SQL_type) {
                strcpy(qstr,"drop table ");
                strcat(qstr,table);
                fprintf(debugfp,"Start %s\n",qstr);
                if (msqlQuery(cMsql.connection, qstr) == -1)
                        setStatusLine(msqlErrMsg);
                bzero(qstr,sizeof(qstr));
                fprintf(debugfp,"After drop table\n");
                sprintf(qstr,"create table ");
                strcat(qstr,table);
                strcat(qstr,"(");
        }
        fprintf(debugfp,"Start analyze field data\n");

        rewindFlds(cMsql.flist);

        for (i = 0; i < cMsql.fldsCount; i++) {

                switch (cMsql.flist->type) {
                case 'C' : sprintf(tmpstr, " %s char(%d)",cMsql.flist->fld
                                                         ,cMsql.flist->length);
                           break;
                case 'N' : sprintf(tmpstr, " %s int",cMsql.flist->fld);
                           break;
                case 'R' : sprintf(tmpstr, " %s real",cMsql.flist->fld);
                           break;
                default  : 
if (debug)
                           fprintf(debugfp,"Field in cMsql: %s/%d\n",
                                  cMsql.flist->fld,cMsql.flist->type);
                           break;
                }
                strcat (qstr, tmpstr);
if (debug)
                fprintf(debugfp,"tmpstr: %s\n",tmpstr);
                if (i == (cMsql.fldsCount-1)) 
                        strcat (qstr, ")");
                else strcat (qstr, ",");
                
                cMsql.flist = cMsql.flist->next; 
        }        

        if (type == SQL_type) {
                msqlQuery(cMsql.connection, qstr);
                fprintf(debugfp,"After %s\n", qstr);
        }
        
}

void insertSQLtable(table)
char *table;
{

        char             *nullstr = "''";
        char             tmpstr[50];

        static char      qstr[1024];
        int              i,j;
    
        FILE  *ofptr;

        ofptr=fopen("xmsql.log","wb");

        fprintf(debugfp,"Start to insert Table %s,C:%d/R:%d\n",table,
                        cMsql.fldsCount,cMsql.rowsCount);

        bzero(qstr,sizeof(qstr));
        for (i=0; i < cMsql.rowsCount; i++) {
                  sprintf(tmpstr,"insert into %s values(",table);
                  strcpy(qstr,tmpstr);
                  rewindFlds(cMsql.flist);
                  for (j=0; j < cMsql.fldsCount; j++) {
		            cMsql.tempCell=XbaeMatrixGetCell(tableMW,i,j);
                            if (j > 0) strcat(qstr,",");
		            switch (cMsql.flist->type) {
                            case 'C' : sprintf(tmpstr,"'%s'",cMsql.tempCell);
                                       if (!strcmp(tmpstr,nullstr)) 
                                                strcat(qstr,"'!n'");
                                       else     strcat(qstr,tmpstr);
                                       break;
                            case 'N' :           
                            case 'R' : sprintf(tmpstr,"%s",cMsql.tempCell);
                                       if (!strcmp(tmpstr,"")) 
                                                strcat(qstr,"0");
                                       else     strcat(qstr,tmpstr);
                                       break;
                            default  : 
if (debug)
                                       fprintf(debugfp,"Why an unknown type %d(%s) ?\n",
                                               cMsql.flist->type,
                                               cMsql.flist->fld);
                                       break;           
                                       
                            }
                            cMsql.flist = cMsql.flist->next;
                  }
                  strcat(qstr,")");
                  if (msqlQuery(cMsql.connection, qstr) == -1) {
                          fprintf(ofptr,"\nInsert Failed %s",qstr);
                  }
                  bzero(qstr,sizeof(qstr));
        }
        
        fclose(ofptr);
}

void updateSQL(table,type)
char *table;
int  type;
{

        cMsql.fldsCount = XbaeMatrixNumColumns(tableMW);
        cMsql.rowsCount = XbaeMatrixNumRows(tableMW);
        fprintf(debugfp,"Start to do Table %s,C:%d/R:%d\n",table,
                        cMsql.fldsCount,cMsql.rowsCount);

        if ((cMsql.fldsCount == -1) || (cMsql.rowsCount == -1))
                return;

        createSQLtable(table,type);

        insertSQLtable(table);
}

void saveCB(Widget w, XtPointer client, XtPointer call)
{
        char tmp[21];

        sprintf(tmp,"%s",cMsql.tbls[cMsql.currentTbl]);
        fprintf(debugfp,"saveCB: %s %d\n",tmp,cMsql.currentTbl);
        updateSQL(tmp,SQL_type);
}

void save_bkpCB(Widget w, XtPointer client, XtPointer call)
{
        char tmp[21];

        sprintf(tmp,"%sbck",cMsql.tbls[cMsql.currentTbl]);
        fprintf(debugfp,"save_bkpCB: %s %d\n",tmp,cMsql.currentTbl);
        updateSQL(tmp,SQL_type);
}

void saveDB(table)
char *table;
{
/* 
        char             *nullstr = "''";
        char             fldstr[32];
        char             *tmpflds;
        char             tmpstr[50];
        char             *tmplen;
        static char      tmptok[50];
        static int       fldstype[50];
        static int       fldslen[50];

        static char      qstr[1024];
        int              i, j, k;
        int              len;
        int              hsz,drs;
        int              ver=3,dd=24,mm=8,yy=97;

        FILE  *ofptr;

        ofptr=fopen("xmsql.dbf","wb");

        cMsql.fldsCount = XbaeMatrixNumColumns(tableMW);
        cMsql.rowsCount = XbaeMatrixNumRows(tableMW);

        fprintf(ofptr,"\n%c%c%c%c",ver,yy,mm,dd);
        fprintf(ofptr,"\n%d%d%d%d",ver,yy,mm,dd);
        
        fprintf(debugfp,"Start to do Table %s,C:%d/R:%d\n",table,
                        cMsql.fldsCount,cMsql.rowsCount);

        fprintf(debugfp,"Start to do Table %s\n",table);
        bzero(fldstr,sizeof(fldlstr));
        fprintf(debugfp,"Start analyze field data\n");
        for (i = 0; i < cMsql.fldsCount; i++) {
                strcpy(tmpstr , cMsql.fldslist[i]);
                len = strlen(tmpstr);
                tmpflds = strtok(tmpstr,":");
                j = strlen(tmpflds);
                if (j > 11) j=11; 
                hsz += 32;
                
                tmplen = &tmpstr[j+2];
                fldslen[i]=atoi(tmplen);

                drs += fldslen[i];
        }        

        i = cMsql.rowsCount;
        j = i/256;
        k = i - 256*j; 
        fprintf(ofptr,"%c%c%c%c",k,j,0,0);
        i = hsz;
        j = i/256;
        k = i - 256*j; 
        fprintf(ofptr,"%c%c",k,j);
        i = drs;
        j = i/256;
        k = i - 256*j; 
        fprintf(ofptr,"%c%c",k,j);

        for (i=12; i<32; i++)
                 fprintf(ofptr,"%c",0);

        for (i = 0; i < cMsql.fldsCount; i++) {
                strcpy(tmpstr , cMsql.fldslist[i]);
                len = strlen(tmpstr);
                tmpflds = strtok(tmpstr,":");
                k = j = strlen(tmpflds);
                if (k > 11) k=11; 
                
                strncpy(fldstr,tmpflds,j);
                fprintf(ofptr,"%s",fldstr);
                for (;k<11;k++)
                         fprintf(ofptr,"%c",0);
       
                tmplen = &tmpstr[j+2];
                fldslen[i]=atoi(tmplen);

                fldstype[i]=tmpstr[j+1];
                switch(tmpstr[j+1]) {
                case 'R' :
                case 'C' : fprintf(ofptr,"%c",0x43);  
                           break;
                case 'N' : fprintf(ofptr,"%c",0x45);  
                           break;
                default  : break;
                }
                for (k=12;k<16;k++)
                         fprintf(ofptr,"%c",0);
                fprintf(ofptr,"%c", tmplen);
                for (k=17;k<32;k++)
                         fprintf(ofptr,"%c",0);
                bzero(tmptok, sizeof(tmptok));
        }        
        fprintf(ofptr,"%c",0x0d);

        bzero(qstr,sizeof(qstr));
        for (i=0; i < cMsql.rowsCount; i++) {
                  for (j=0; j < cMsql.fldsCount; j++) {
		            cMsql.tempCell=XbaeMatrixGetCell(tableMW,i,j);
		            if (fldstype[j]==0x43) {
                                    sprintf(tmpstr,"'%s'",cMsql.tempCell);
                                    if (!strcmp(tmpstr,nullstr)) strcat(qstr,"'!n'");
                                    else              strcat(qstr,tmpstr);
                            }
                            if (fldstype[j]==0x4e) {
                                    sprintf(tmpstr,"%s",cMsql.tempCell);
                                    if (!strcmp(tmpstr,"")) strcat(qstr,"0");
                                    else              strcat(qstr,tmpstr);
                            }
                  }
                  bzero(qstr,sizeof(qstr));
        }
        
        fclose(ofptr);
*/
}

void Open(Widget w, XtPointer client, XtPointer call)
{
        Widget       button;
        Arg          args[5];
        Cardinal     n;

        n = 0;
        button = XmCreateFileSelectionDialog(toplevel, "filesb", args, n);
   
        XtAddCallback(button, XmNokCallback, fileCB, NULL); 
        XtAddCallback(button, XmNcancelCallback, filecancelCB, NULL); 

        XtManageChild(button);
}

void okPromptCB(Widget w, XtPointer client, XtPointer call)
{
        XmSelectionBoxCallbackStruct*  ptr;
        char*                          string;
        int                            type = (int) client;
        
        ptr = (XmSelectionBoxCallbackStruct*) call;
        
        XmStringGetLtoR(ptr->value, XmSTRING_DEFAULT_CHARSET,&string);
        fprintf(debugfp,"Prompted Value: %s\n",string);

        switch (type) 
        {
        case SQL_type   : 
        case APPEND_type: updateSQL(string,type);
                          break;
        case DBASE_type : saveDB(string);
                          break;
        default         : break;
        }                  
                        
        XtFree(string);
}

void AddPromptDlgCB(w, name, type)
Widget  w;
char    *name;
int     type;
{
        XtAddCallback(w, XmNokCallback, okPromptCB, (XtPointer)type);
        XtAddCallback(w, XmNapplyCallback, okPromptCB, (XtPointer)type);
        XtAddCallback(w, XmNcancelCallback, cancelCB, NULL);
        XtAddCallback(w, XmNhelpCallback, helpCB, NULL);
}

void AddDlgCB(w, name)
Widget  w;
char    *name;
{
        XtAddCallback(w, XmNokCallback, okCB, NULL);
        XtAddCallback(w, XmNcancelCallback, cancelCB, NULL);
        XtAddCallback(w, XmNhelpCallback, helpCB, NULL);
}

void CreatePromptDialog(w, name, type)
Widget  w;
char    *name;
int     type;
{
        Widget    prompt;
        Arg       args[5];
        Cardinal  n;
        XmString  item;
        
        item = XmStringCreateSimple(name);
        n = 0;
        XtSetArg(args[n], XmNselectionLabelString, item); n++;
        prompt = XmCreatePromptDialog(w, "Prompt", args, n);

        AddPromptDlgCB(prompt, name, type);

        XtManageChild(prompt);
        XmStringFree(item);
        return;
}

void CreateInfoDialog(w, name)
Widget  w;
char    *name;
{
        Widget    info, cancel;
        Arg       args[5];
        Cardinal  n;
        XmString  item;
        
        item = XmStringCreateSimple(name);
        n = 0;
        XtSetArg(args[n], XmNmessageString, item); n++;
        info = XmCreateInformationDialog(w, "Information", args, n);

        AddDlgCB(info, name);
        
        cancel = XmMessageBoxGetChild(info, XmDIALOG_CANCEL_BUTTON);
        XtUnmanageChild(cancel);
 
        XtManageChild(info);
        XmStringFree(item);
        return;
}

void CreateErrorDialog(w, name)
Widget  w;
char    *name;
{
        Widget    info, cancel;
        Arg       args[5];
        Cardinal  n;
        XmString  item;
        
        item = XmStringCreateSimple(name);
        n = 0;
        XtSetArg(args[n], XmNmessageString, item); n++;
        info = XmCreateInformationDialog(w, "Error", args, n);

        AddDlgCB(info, name);
        
        cancel = XmMessageBoxGetChild(info, XmDIALOG_CANCEL_BUTTON);
        XtUnmanageChild(cancel);
 
        XtManageChild(info);
        XmStringFree(item);
        return;
}

void appendCB(Widget w, XtPointer client, XtPointer call)
{
        CreatePromptDialog(w,"Enter Appended Table Name",APPEND_type);
}

void sqlTableCB(Widget w, XtPointer client, XtPointer call)
{
        CreatePromptDialog(w,"Enter Table Name",SQL_type);
}

void dbaseCB(Widget w, XtPointer client, XtPointer call)
{
        CreatePromptDialog(w,"Enter Dbase File Name",DBASE_type);
}

void DecreaseField()
{
   int     i=0;
   
   rewindFlds(cMsql.flist);
 
   while (i <= hs.lastcolumn)  {
        if (i++ == hs.lastcolumn) {
            removeFld(cMsql.flist);
        }    
        cMsql.flist = cMsql.flist->next;
   }     
   
}

void MWHandle(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
   int       type = (int) client;
   String    *rowDatas;
   short     *widths;
   short     rowWidth;
   int       i;

   syslog (LOG_INFO,"Requested ID : %d\n", type);
   
   switch (type)  
   {
        case AddRow  :
        case AddRows : 
                 if (hs.lastrow == -1) hs.lastrow = 0;
                 rowDatas = (String *)malloc((cMsql.fldsCount+1)*sizeof(String));
                 for (i = 0; i < cMsql.fldsCount; i++)
	                  rowDatas[i] = XbaeMatrixGetCell(tableMW, 
                                 hs.lastrow, i);
                 for (i = 0; i < ((type == 1) ? 1 : 5); i++)
                          XbaeMatrixAddRows(tableMW, hs.lastrow+i, rowDatas, 
                                 NULL, NULL, 1);  
                 hs.lastrow += (type == 1) ? 1 : 5;
                 cMsql.rowsCount = XbaeMatrixNumRows(tableMW);
                 free ((String *)rowDatas);
                 break;
        case AddColumn : 
                 ColChoice(AddColumn);
                 break;
        case RelableRows : 
                 rowDatas = (char **)calloc(cMsql.rowsCount+2,sizeof(char *));
                 for (i = 0; i < cMsql.rowsCount; i++) {
       		          rowDatas[i] = (char *)malloc(4);		
	                  sprintf(rowDatas[i], "%d", i+1);
                 }

                 rowWidth = 1;
                 if (i > 9)    rowWidth = 2;
                 if (i > 99)   rowWidth = 3;
                 if (i > 999)  rowWidth = 4;
                 if (i > 9999) rowWidth = 5;
        
                 XtVaSetValues(tableMW,
                          XmNrowLabels,       rowDatas,
                          XmNrowLabelWidth,   rowWidth,
                 	  NULL);
                 free ((char **)rowDatas);
                 break;
        case AddTailColumn : 
                 ColChoice(AddTailColumn);
                 break;
        case SetColumnWidth : 
                 ColChoice(SetColumnWidth);
                 break;
        case SetColumnData : 
                 ColChoice(SetColumnData);
                 break;
        case SetColumnName : 
                 ColChoice(SetColumnName);
                 break;
        case DelRow : 
                 XbaeMatrixDeleteRows(tableMW, hs.lastrow, 1);  
                 cMsql.rowsCount = XbaeMatrixNumRows(tableMW);
                 break;
        case DelColumn : 
                 XbaeMatrixDeleteColumns(tableMW, hs.lastcolumn, 1);  
                 DecreaseField();
                 cMsql.fldsCount = XbaeMatrixNumColumns(tableMW);
                 break;
   } 
   XbaeMatrixRefresh(tableMW);
}

void MWLeave(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
        XbaeMatrixLeaveCellCallbackStruct *cbs =
	       (XbaeMatrixLeaveCellCallbackStruct*) call;
        int    i, j;

if (debug)
        fprintf(debugfp,"Leave row: %d\tcol: %d\n",cbs->row,cbs->column);
}

void MWEnter(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
        XbaeMatrixEnterCellCallbackStruct *cbs =
	      (XbaeMatrixEnterCellCallbackStruct*) call;
        int    i, j;

if (debug)
        fprintf(debugfp,"Enter row: %d\tcol: %d\n",cbs->row,cbs->column);
}

void MWHighLight(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
    XbaeMatrixLabelActivateCallbackStruct *cbs =
	(XbaeMatrixLabelActivateCallbackStruct*) call;
    Pixel row_color[cMsql.fldsCount];
    Pixel column_color[cMsql.rowsCount];
    int   i;

    fprintf(debugfp,"Row/Column: %d/%d\n",cbs->row,cbs->column);

    if (hs.lastrow > -1) {  
            for (i = 0; i < cMsql.fldsCount; i++)
                     row_color[i]=blue;
            XbaeMatrixSetRowBackgrounds(tableMW, hs.lastrow,row_color,
                     1);
            for (i = 0; i < cMsql.fldsCount; i++)
                     row_color[i]=black;
            XbaeMatrixSetRowColors(tableMW, hs.lastrow,row_color,
                     1);
            XbaeMatrixUnhighlightRow(tableMW, hs.lastrow);
    }
    if (hs.lastcolumn > -1) {
            for (i = 0; i < cMsql.rowsCount; i++)
                     column_color[i]=blue;
            XbaeMatrixSetColumnBackgrounds(tableMW, hs.lastcolumn,
                     column_color,1);
            for (i = 0; i < cMsql.fldsCount; i++)
                     column_color[i]=black;
            XbaeMatrixSetColumnColors(tableMW, hs.lastcolumn,
                     column_color,1);
            XbaeMatrixUnhighlightColumn(tableMW, hs.lastcolumn);
    }
    if (cbs->row != -1) {
            for (i = 0; i < cMsql.fldsCount; i++)
                     row_color[i]=black;
            XbaeMatrixSetRowBackgrounds(tableMW, cbs->row,row_color,
                     1);
            for (i = 0; i < cMsql.fldsCount; i++)
                     row_color[i]=green;
            XbaeMatrixSetRowColors(tableMW, cbs->row,row_color,
                     1);
            XbaeMatrixHighlightRow(tableMW, cbs->row);
            hs.lastrow = cbs->row;
    }
    else if (cbs->column != -1) {
            for (i = 0; i < cMsql.fldsCount; i++)
                     column_color[i]=black;
            XbaeMatrixSetColumnBackgrounds(tableMW, cbs->column,
                     column_color,1);
            for (i = 0; i < cMsql.fldsCount; i++)
                     column_color[i]=green;
            XbaeMatrixSetColumnColors(tableMW, cbs->column,
                     column_color,1);
            XbaeMatrixHighlightColumn(tableMW, cbs->column);
            hs.lastcolumn = cbs->column;
    }     
    
}

void LoadMatrix(w)
Widget w;
{
        char   **rowLabels;
        char   **columnLabels;
        short  *columnWidths;
        int    i;
        

        fprintf(debugfp,"Enter LoadMatrix\n");
        if (cMsql.rowsCount == 0) cMsql.rowsCount=1;
	rowLabels = (char **)calloc(cMsql.rowsCount+2,sizeof(char *));
	for (i = 0; i < cMsql.rowsCount; i++) 
        {
		rowLabels[i] = (char *)malloc(4);		
                sprintf(rowLabels[i], "%d",i+1);
	}

	fprintf(debugfp,"fldsCount : %d\n", cMsql.fldsCount);
	fprintf(debugfp,"rowsCount : %d\n", cMsql.rowsCount);
	columnWidths = (short *)malloc((cMsql.fldsCount+1) * sizeof(short));
	columnLabels = (char **)calloc(cMsql.fldsCount+2,sizeof(char *));

        i = cMsql.currentFld;
        while (--i > 0) {
if (debug)
               fprintf(debugfp,"FieldName(%d): %s\n",cMsql.flist->length,cMsql.flist->fld);
               cMsql.flist = cMsql.flist->prev;
        }       
 
	for (i = 0; i < cMsql.fldsCount; i++) 
        {
		columnLabels[i] = (char *)malloc(50 * sizeof (char));
	        sprintf(columnLabels[i] ,"%s", cMsql.flist->fld);	
                columnWidths[i] = cMsql.flist->length;
if (debug)
		fprintf(debugfp,"%s %d\n", columnLabels[i],columnWidths[i]);
		cMsql.flist = cMsql.flist->next; 
	}

        cMsql.flist = cMsql.flist->prev;
        
        XtVaSetValues(w,
                  XmNrowLabels,       rowLabels,
                  XmNcolumns,         cMsql.fldsCount,
                  XmNrows,            cMsql.rowsCount,
                  XmNcolumnLabels,    columnLabels,
                  XmNcolumnWidths,    columnWidths,
		  XmNallowColumnResize,True,
		  XmNcells,           cMsql.cells,
                  XmNbuttonLabels,    True,
		  NULL);

        free((String **)cMsql.cells);

        if (cMsql.rowsCount == 1)
                cMsql.rowsCount=0;
        else if (cMsql.fldsCount > 8)
                XtVaSetValues(w,
                       XmNvisibleRows,     2,
                       XmNvisibleColumns,  2,
                       XmNfixedRows,       1,
                       XmNfixedColumns,    1,
                       XmNtrailingFixedRows,    1,
                       XmNtrailingFixedColumns, 1,
                       XmNtraverseFixedCells,   True,
		       NULL);

        if (cMsql.rowsCount == 0) 
                XbaeMatrixDeleteRows(tableMW, 0, 1);

        free ((short *)columnWidths);
        free ((char **)rowLabels);
        free ((char **)columnLabels);

        XbaeMatrixRefresh(tableMW);
        cMsql.fldsCount = XbaeMatrixNumColumns(tableMW);
}

void countField()
{
  int              i;
  m_field          *field;
  char             tmp[50];

  fprintf(debugfp,"Enter countField\n");

  emptyFlds(cMsql.flist);
  cMsql.currentFld = 0;

  cMsql.fldsCount = msqlNumFields(cMsql.res);
  fprintf(debugfp,"Total %d Fields Saw !\n",cMsql.fldsCount);

  for (i = 0; i < cMsql.fldsCount; i++) {
      Flist  *flist = (Flist *)malloc(sizeof(Flist));
      field = msqlFetchField(cMsql.res);
      flist->fld = (char *)malloc(strlen(field->name)+1);

      strcpy(flist->fld , field->name);

      switch (field->type) {
      case CHAR_TYPE : flist->type = 'C';
                       break;
      case INT_TYPE  : flist->type = 'N';
                       break;          
      case REAL_TYPE : flist->type = 'R';
                       break;
      default  :       break;           
      }

      if ((field->type != CHAR_TYPE) ||
          (field->length < strlen(field->name)))
              flist->length = strlen(field->name);
      else
              flist->length = field->length;

if (debug)
      fprintf(debugfp,"countField : %s %d\n",flist->fld,flist->length);
      insertFld(cMsql.flist, flist);
      cMsql.currentFld++;
  }

  cMsql.flist = cMsql.flist->prev;

}

void dumpTable(index)
        int     index;
{

        char		query[1024], tmp[35];
	m_row 		row;
        char            *space=" ";
        static char     *rows_str[20480][100];
	int		i, j;
        CmList          *flist;
	
if (debug) 
        fprintf(debugfp,"Sending SELECT query...\n");
        
        if (index != inputQuery) {
                sprintf(query, "SELECT * FROM %s", cMsql.tbls[index]);
                 
                flist = (CmList *)malloc(sizeof(CmList));
                flist->list = (char *)malloc(strlen(query)+1); 
                strcpy(flist->list , query);
                flist->length = strlen(flist->list);
                insertLst(cmList,flist);

         	if (msqlQuery(cMsql.connection, query) == -1) {
         	        strcat(query," Failed!");
                        setStatusLine(query);
      		        return;
                }
                
                if (!(cMsql.res=msqlStoreResult())) { 
                        setStatusLine("Store Query Result Failed !");
                  	return;
                }
        }
        else countField();
        
        cMsql.rowsCount = msqlNumRows(cMsql.res);

	sprintf(tmp,"Retrieved %d rows. Processing...\n", 
			cMsql.rowsCount );
        setStatusLine(tmp);

        if (cMsql.rowsCount < 2) cMsql.rowsCount=5; /*Xbae's Fault*/

        cMsql.cells = (String **)malloc((cMsql.rowsCount+2) * 
                      (cMsql.fldsCount+2) * sizeof(String *));

        j = 0;
	while (row=msqlFetchRow(cMsql.res)) 
	{
		for (i = 0; i < msqlNumFields(cMsql.res); i++) 
		{
			rows_str[j][i] = (char *)calloc((strlen(row[i])+1),sizeof(char));
			strcpy(rows_str[j][i], row[i]);	
 		}
	        cMsql.cells[j] = &rows_str[j][0];
	        j++;
	 }

	while (j < cMsql.rowsCount) 
	{
		for (i = 0; i < cMsql.fldsCount; i++) 
		{
			rows_str[j][i] = (char *)calloc((strlen(space)+1),sizeof(char));
			strcpy(rows_str[j][i], space);	
 		}
	        cMsql.cells[j] = &rows_str[j][0];
	        j++;
	 }
	 
         fprintf(debugfp,"Leaving DumpTable !\n"); 
}

void resetComboDB()
{
         XmComboBoxDeleteAllItems(comboDB);
         setStatusLine("Clear DB !");
}

void resetComboTable()
{
         XmComboBoxDeleteAllItems(comboTable);
         setStatusLine("Clear Tables !");
}

void listFields(Widget widget, XtPointer clientData, XtPointer callData)
{
  int              i;
  m_field          *field;
  XmString         item;

/* 
  if (!clientData)
    return;
*/

  if (-1 == cMsql.connection) {
     setStatusLine("Not tableSelected.");
     return;
  }   

  fprintf(debugfp,"Enter Fields Connect for Table\n");

  i = XmComboBoxGetSelectedPos(comboTable);

  if ( i == 0) {
     setStatusLine("Choose the wrong Table !\n");
     return;
  }   		

  fprintf(debugfp,"Fields Connect for Table: %s !\n",cMsql.tbls[--i]);

  cMsql.currentTbl = i;

  cMsql.res = msqlListFields(cMsql.connection, cMsql.tbls[i]);

  if (!cMsql.res) {
     setStatusLine("Fields Connect Fail !");
     return;
  }

  countField();

  msqlFreeResult(cMsql.res);
  dumpTable(cMsql.currentTbl);

  fprintf(debugfp,"After dumpTable\n");

  LoadMatrix (tableMW);
  fprintf(debugfp,"After loadMatrix\n");
  
  hs.lastrow = -1;
  hs.lastcolumn = -1;
}    

void listTables(Widget widget, XtPointer clientData, XtPointer callData)
{  
  m_row row;
  XmString  item;
  int i, n;
  Arg wargs[20];
  char buffer[50];
  char tmp[35]; 

  if (-1 == cMsql.connection) {
    setStatusLine("Not connected.");
    return;
  }   

  cMsql.res = msqlListTables(cMsql.connection);
  if (cMsql.res) {
    
    cMsql.tblsCount = msqlNumRows(cMsql.res);
    cMsql.tbls = (char **)XtMalloc((cMsql.tblsCount+1) * sizeof(char *));
    for (i = 0; i < cMsql.tblsCount; i++) {
      row = msqlFetchRow(cMsql.res);
      cMsql.tbls[i] = (char *)XtCalloc((strlen(row[0])+1), sizeof(char));
      item = XmStringCreateSimple(row[0]);
      XmComboBoxAddItem(comboTable, item, 0);
      XmStringFree(item);
      strcpy(cMsql.tbls[i], row[0]);
    }

    cMsql.tbls[i] = NULL;

    XmStringFree(item); 

    msqlFreeResult(cMsql.res);

    sprintf(tmp,"%d Tables Got! Choose Table Now!",cMsql.tblsCount);
    setStatusLine(tmp);       
  }
  else
    setStatusLine("No info available.");  
}

void handleQuery()
{
  if (msqlQuery(cMsql.connection, cMsql.qbuf) == -1) {
          setStatusLine("Query Failed !");          
	  return;
  }

  if (!(cMsql.res=msqlStoreResult())) {
          setStatusLine("Query Failed !");          
          return;
  }

  dumpTable(inputQuery);

  LoadMatrix (tableMW);
  
  hs.lastrow = -1;
  hs.lastcolumn = -1;
}

void commandInput(Widget w, XtPointer client, XtPointer call)
{
  CmList  *flist = (CmList *)malloc(sizeof(CmList));

  flist->list = XmTextFieldGetString(w);
  flist->length = strlen(flist->list);

  cMsql.qbuf = XmTextFieldGetString(w);
  
  insertLst(cmList,flist);

  handleQuery();
  bzero(cMsql.qbuf,sizeof(cMsql.qbuf));

}

void debugLst(Widget widget, XtPointer clientData, XtPointer callData)
{
  int  i=0;
  FILE *fp;
  
  setStatusLine("On Debugging Xmsql Command Lists!");

  fp = fopen("/xmsql-0.4/xmsql.log","w+");

  fprintf(fp,"Command Input are: %d\n",cMsql.cmCount);
  
  i = cMsql.cmCount;
  cmList = cmList->prev;
  while (cmList->length > 0) {
        fprintf(fp,"%d: Command List: %s\n",
                i--,cmList->list);
        cmList = cmList->prev;
  }

  cmList = cmList->next;
  while (cmList->length > 0) {
        cmList = cmList->next;
  }

  fclose (fp);
  view(widget,clientData,callData);
}  

void selectDB(Widget widget, XtPointer clientData, XtPointer callData)
{
  int i;

  if (cMsql.connection != -1) {

    i = XmComboBoxGetSelectedPos(comboDB);
    if ( i == 0) {
            fprintf(debugfp,"Choose the wrong DB !\n");
            return;
    }   		

    resetComboTable();

    if (-1 == msqlSelectDB(cMsql.connection, cMsql.dbs[--i])) {
      cMsql.currentDB = -1;
      setStatusLine(msqlErrMsg);
      return;
    }
    cMsql.currentDB = i;
    syslog (LOG_INFO,"Before Building comboTables.\n");
    listTables(comboTable, (Arg *)NULL, 0);
  
    setStatusLine("Database selected & Table Updated."); 
  }
}  

void connectDBServer(String hostname)
{
  int sock, dbCount, i;
  m_result *dbs;
  m_row row;
  XmString item;

  sock = msqlConnect(hostname); /* make connection to DB server */
  if (sock == -1) {
    setStatusLine((String)msqlErrMsg);
    return;
  }  
  setStatusLine("Connect Msql OK ! Choose DB Now !!");
  dbs = msqlListDBs(sock);
  if (!dbs) {
    setStatusLine(msqlErrMsg);
    cMsql.connection = -1;
    return;
  }
  
  resetComboDB();
  
  /* set global data */
  cMsql.connection = sock;
  dbCount = msqlNumRows(dbs);
  cMsql.dbs = (char **)XtMalloc((dbCount+1) * sizeof(char *));

  for (i = 0; i < dbCount; i++) {
           row = msqlFetchRow(dbs);
           cMsql.dbs[i] = (char *)XtCalloc((strlen(row[0])+1), sizeof(char));
           item = XmStringCreateSimple(row[0]);
           XmComboBoxAddItem(comboDB, item, 0);
           strcpy(cMsql.dbs[i], row[0]);
  }
  cMsql.dbs[i] = NULL; /* end list with  NULL  */
  cMsql.count = dbCount;  /* number of DBs */
  
  XmStringFree(item); 
  msqlFreeResult(dbs);
    
  setStatusLine("Successfully connected to msql-Server.");     
}  

void connectLocalServer(Widget widget, XtPointer clientData, XtPointer callData)
{
  connectDBServer(NULL);
}  

void connectRemoteServer(Widget widget, XtPointer clientData, XtPointer callData)
{
  connectDBServer(NULL);
}  

void debugOnXmsql(Widget widget, XtPointer clientData, XtPointer callData)
{
  debug = 1;
  
  debugfp = fopen("/xmsql-0.4/xmsql.log","w+");
  setStatusLine("On Debugging Xmsql!");
}  

void debugOffXmsql(Widget widget, XtPointer clientData, XtPointer callData)
{
  debug = 0;
   
  fclose(debugfp);
  setStatusLine("Off Debugging Xmsql!");
}  

void debugField(Widget widget, XtPointer clientData, XtPointer callData)
{
  int  i=0;
  FILE *fp;
  
  setStatusLine("On Debugging Xmsql Fileds!");

  fp = fopen("/xmsql-0.4/xmsql.log","w+");

  rewindFlds(cMsql.flist);
   
  while (cMsql.flist->type > 0) {
        fprintf(fp,"Field: type %d\tname %s\tlen %d\n",
                cMsql.flist->type,
                cMsql.flist->fld,
                cMsql.flist->length);
        cMsql.flist = cMsql.flist->next;
  }
  fclose (fp);
  view(widget,clientData,callData);
}  

void cmPush(Widget w, XtPointer client, XtPointer call)
{
	Widget	dialog = (Widget)client;

	XtManageChild(dialog);
}

String fallbacks[] = { 
  "*fontList: fixed,-*-courier-medium-r-*--*-180-*=LG_LIST_TAG,"
  "fixed,-*-courier-medium-r-*--*-120-*=SM_LIST_TAG",
  "*background: gray",
  "*foreground: black",
  "*cellHighlightThickness: 2",
  "*cellShadowThickness: 2",
  "*cellMarginWidth: 0",
  "*cellMarginHeight: 3",
  "*gridType:		grid_shadow_in",
  "*rowLabelColor:	Red",
  "*columnLabelColor:	Red",
  "*tableMW.gridLineColor: orange",
  "*tableMW.traverseFixedCells:	True",
  NULL };

#define DEFAULT_WIDTH  750
#define DEFAULT_HEIGHT 550

FILE   *debugfp;  
int    debug;

int
main(int argc, char **argv)
{
    XtAppContext theApp;
    Widget shell, menubar, filepane;
    Widget sep, button;
    Widget saveAsPane;
    Widget editpane, controlpane, local, remote;
    Widget cap, frameCombo, frameCD, frameSA, rc, cmButton;
    Widget frameMW, fm, matrixpane, debugpane;
    XmString xmstr, item;

    int width = DEFAULT_WIDTH, height = DEFAULT_HEIGHT;

    Arg          args[5];
    Cardinal     n;

    cMsql.connection = -1;
    cMsql.dbs = NULL;
    cMsql.count = 0;
    cMsql.currentDB = -1;
    cMsql.tbls = NULL;
    cMsql.flist = (Flist *)malloc(sizeof(Flist));
    cMsql.flist->next = cMsql.flist->prev = cMsql.flist;
    cMsql.tblsCount = 0;
    cMsql.fldsCount = 0;
    cMsql.currentFld = 0;
    cMsql.cmCount = 0;

    cmList = (CmList *)malloc(sizeof(CmList));
    cmList->next = cmList->prev = cmList;

    shell = XtVaAppInitialize(&theApp, "mainW", NULL, 0,
				 &argc, argv, fallbacks, NULL);

    if(HeightOfScreen(XtScreen(shell)) < DEFAULT_HEIGHT) 
       height = HeightOfScreen(XtScreen(shell)) * .90;

    if(WidthOfScreen(XtScreen(shell)) < DEFAULT_WIDTH)
       width = WidthOfScreen(XtScreen(shell)) * .90;
       
    toplevel = XtVaCreateWidget("mainW", xmMainWindowWidgetClass,
				 shell,
				 XmNcommandWindowLocation, 
				 XmCOMMAND_BELOW_WORKSPACE,
				 XmNwidth, width,
				 XmNheight, height,
				 NULL);

    XtManageChild(toplevel);

    menubar = XmCreateMenuBar(toplevel,
			      "menuBar",
			      NULL,0);
    XtManageChild(menubar);
    

/********************************************************************/
/*      File Sub-menu                                               */
/********************************************************************/

    filepane = XmCreatePulldownMenu(menubar,
				    "pane",
				    NULL,0);
    xmstr = XmStringCreateSimple("File");
    
    button = XtVaCreateManagedWidget("File",
				     xmCascadeButtonWidgetClass,
				     menubar,
				     XmNsubMenuId, filepane,
                                     XmNlabelString, xmstr,
				     NULL);

    button = XtVaCreateManagedWidget("OpenDBF",
				      xmPushButtonGadgetClass,
				      filepane,
				      NULL);

    XtAddCallback(button,XmNactivateCallback,Open,NULL);


    sep = XtVaCreateManagedWidget("sep",
				  xmSeparatorGadgetClass,
                                  filepane,
                                  NULL);

    button = XtVaCreateManagedWidget("AppendSql",
				      xmPushButtonWidgetClass,
				      filepane,
				      NULL);

    XtAddCallback(button,XmNactivateCallback,appendCB,NULL);

    button = XtVaCreateManagedWidget("Save",
				      xmPushButtonWidgetClass,
				      filepane,
				      NULL);

    XtAddCallback(button,XmNactivateCallback,saveCB,NULL);

    button = XtVaCreateManagedWidget("Save_to_Bkp",
				      xmPushButtonWidgetClass,
				      filepane,
				      NULL);

    XtAddCallback(button,XmNactivateCallback,save_bkpCB,NULL);


    saveAsPane = XmCreatePulldownMenu(filepane,
				      "save_as",
				      NULL, 0);

    button = XtVaCreateManagedWidget("Save As",
				      xmCascadeButtonWidgetClass,
				      filepane,
				      XmNsubMenuId, saveAsPane,
				      NULL);

    button = XtVaCreateManagedWidget("SQL Table",
				      xmPushButtonWidgetClass,
				      saveAsPane,
				      NULL);

    XtAddCallback(button,XmNactivateCallback,sqlTableCB,NULL);

    button = XtVaCreateManagedWidget("Dbase",
				      xmPushButtonWidgetClass,
				      saveAsPane,
				      NULL);

    XtAddCallback(button,XmNactivateCallback,dbaseCB,NULL);

    button = XtVaCreateManagedWidget("LaTeX",
				      xmPushButtonWidgetClass,
				      saveAsPane,
				      NULL);
				      
    button = XtVaCreateManagedWidget("Quit",
				      xmPushButtonWidgetClass,
				      filepane,
				      NULL);
    XtAddCallback(button,XmNactivateCallback,Quit,NULL);
				      
/********************************************************************/
/*      Edit Sub-menu                                               */
/********************************************************************/

    editpane = XmCreatePulldownMenu(menubar,
				    "pane2",
				    NULL, 0);

    button = XtVaCreateManagedWidget("Edit",
				      xmCascadeButtonGadgetClass,
				      menubar,
				      XmNsubMenuId, editpane,
				      NULL);

    button = XtVaCreateManagedWidget("Cut",
				      xmPushButtonGadgetClass,
				      editpane,
				      NULL);

/********************************************************************/
/*      Control Sub-menu                                            */
/********************************************************************/

    controlpane = XmCreatePulldownMenu(menubar,
				    "pane3",
				    NULL, 0);

    button = XtVaCreateManagedWidget("Control",
				      xmCascadeButtonGadgetClass,
				      menubar,
				      XmNsubMenuId, controlpane,
				      NULL);

    local = XtVaCreateManagedWidget("Local Server",
				      xmPushButtonGadgetClass,
				      controlpane,
				      NULL);
				      
    XtAddCallback(local,XmNactivateCallback,connectLocalServer,NULL);

    remote = XtVaCreateManagedWidget("Remote Server",
				      xmPushButtonGadgetClass,
				      controlpane,
				      NULL);
				      
    XtAddCallback(remote,XmNactivateCallback,connectRemoteServer,NULL);

    /*    n = 0;
    XtSetArg(args[n], XmNsubMenuId, controlpane);		n++;
    XtSetArg(args[n], XmNmenuHistory, local);		n++;
    button = XmCreateOptionMenu(menubar, "option", args, n);
    XtManageChild(button);
    */

/********************************************************************/
/*      Dbase List                                                  */
/********************************************************************/
        
    fm = XtVaCreateManagedWidget("fm", 
                        xmFormWidgetClass, toplevel,
                        NULL);			

    frameCombo = XtVaCreateManagedWidget("frame", 
                        xmFrameWidgetClass, fm,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNtopOffset,		4,
		      	XmNleftAttachment,	XmATTACH_FORM,
			XmNleftOffset,		4,
					 /*XmNrightAttachment,	XmATTACH_FORM,
			XmNrightOffset,	4,*/
                        NULL);

    rc = XtVaCreateManagedWidget(
	"rc", xmRowColumnWidgetClass, frameCombo,
	XmNchildType,	    XmFRAME_WORKAREA_CHILD,
	XmNadjustLast,	    False,
	XmNradioBehavior,   True,
	XmNradioAlwaysOne,  True,
	XmNorientation,     XmHORIZONTAL,
	XmNpacking,	    XmPACK_COLUMN,
	NULL);

    item = XmStringCreateSimple("DBASE :");
    cap = XtVaCreateManagedWidget("w",
			xbaeCaptionWidgetClass, rc,
                        XmNlabelOffset, 5,
                        XmNlabelString, item,
			NULL);
    comboDB = XmCreateComboBox(cap, "Dbase", NULL, 0);
    XtManageChild(comboDB);

    XmStringFree(item); 
    XtAddCallback(comboDB,XmNselectionCallback,selectDB,NULL);
  
/********************************************************************/
/*      Dbase Table List                                            */
/********************************************************************/

    item = XmStringCreateSimple("TABLE :");
    cap = XtVaCreateManagedWidget("w",
			xbaeCaptionWidgetClass, rc,
                        XmNlabelOffset, 5,
                        XmNlabelString, item,
			NULL);
    comboTable = XmCreateComboBox(cap, "Table", NULL, 0);
    XtManageChild(comboTable);

    XtAddCallback(comboTable,XmNselectionCallback,listFields,NULL);

    XmStringFree(item); 

    frameCombo = XtVaCreateManagedWidget("frame", 
                        xmFrameWidgetClass, fm,
			XmNtopWidget,    frameCombo,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNtopOffset,		4,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		frameCombo,
			XmNrightAttachment,	XmATTACH_FORM,
                        NULL);

    cMsql.status = XtVaCreateManagedWidget("w",
			xmTextFieldWidgetClass, frameCombo,
                        XmNeditable, False,
                        XmNcolumns, 40,
			NULL);
  
/********************************************************************/
/*      Command Dialog                                              */
/********************************************************************/
    frameCD = XtVaCreateManagedWidget("frame", 
                        xmFrameWidgetClass, fm,
                        XmNtopWidget,    frameCombo,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopOffset,		4,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNleftOffset,		4,
                        NULL);

    rc = XtVaCreateManagedWidget(
        "rc", xmRowColumnWidgetClass, frameCD,
	XmNchildType,	    XmFRAME_WORKAREA_CHILD,
	XmNadjustLast,	    False,
	XmNradioBehavior,   True,
	XmNradioAlwaysOne,  True,
	XmNorientation,     XmHORIZONTAL,
	XmNpacking,	    XmPACK_COLUMN,
	NULL);
				         
    item = XmStringCreateSimple("Command :");

    cap = XtVaCreateManagedWidget("w",
			xbaeCaptionWidgetClass, rc,
                        XmNlabelOffset, 5,
                        XmNlabelString, item,
                        XmNheight, 30,
			NULL);

    XmStringFree(item); 

    cMsql.tf = XtVaCreateManagedWidget("tf",
			xmTextFieldWidgetClass, cap,
                        XmNcolumns, 80,
			NULL);
    XtAddCallback(cMsql.tf,XmNactivateCallback,commandInput,NULL);

    cmButton = XtVaCreateManagedWidget("CommandSel", 
                        xmArrowButtonWidgetClass, fm,
			XmNtopWidget,    frameCombo,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopOffset,		4,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		frameCD,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	80,
                        XmNarrowDirection,      1,
			XmNheight,              38,
                        XmNwidth,               10,
                        XmNborderWidth,         3,
                        NULL);

    XtManageChild(cmButton);

    cmBox = XmCreateSelectionDialog(toplevel, "CommandHistory", 
                        NULL, 0);
			
    XtAddCallback(cmBox, XmNokCallback, Print, NULL);
    XtAddCallback(cmButton, XmNactivateCallback, cmPush, cmBox);
/********************************************************************/
/*      Matrix  Area                                                */
/********************************************************************/
    
    frameMW = XtVaCreateManagedWidget("frame", 
                        xmFrameWidgetClass, fm,
		       	XmNtopWidget,		frameCD,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopOffset,		4,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNleftOffset,		4,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNrightOffset,	4,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNbottomOffset,		4,
                        NULL);

/********************************************************************/
/*      Matrix Area                                                 */
/********************************************************************/

    tableMW = XtVaCreateManagedWidget("tableMW", 
                        xbaeMatrixWidgetClass,  frameMW, 
                        NULL);
			
    XtAddCallback(tableMW, XmNenterCellCallback, MWEnter, NULL);
    XtAddCallback(tableMW, XmNleaveCellCallback, MWLeave, NULL);
    XtAddCallback(tableMW, XmNlabelActivateCallback, MWHighLight, NULL);


/********************************************************************/
/*      Color Area                                                  */
/********************************************************************/

    XtVaGetValues(toplevel,XmNbackground,&blue,NULL);;
    red    = GetNamedColor(toplevel, "red");
    green  = GetNamedColor(toplevel, "green");
    grey   = GetNamedColor(toplevel, "grey");
    black  = GetNamedColor(toplevel, "black");

/********************************************************************/
/*      Matrix PopUp                                                */
/********************************************************************/

/*
    n = 0;
    matrixpane = XmCreatePopupMenu(tableMW, "pane4", args, n);
*/
    matrixpane = XmCreatePulldownMenu(menubar,
				    "pane4",
				    NULL, 0);

    button = XtVaCreateManagedWidget("Matrix",
				      xmCascadeButtonGadgetClass,
				      menubar,
				      XmNsubMenuId, matrixpane,
				      NULL);

    button = XtVaCreateManagedWidget("Add a Row",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)AddRow);

    button = XtVaCreateManagedWidget("Add Rows",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)AddRows);

    button = XtVaCreateManagedWidget("Add a Column",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)AddColumn);

    button = XtVaCreateManagedWidget("Add a tail-Column",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)AddTailColumn);

    sep = XtVaCreateManagedWidget("sep",
				  xmSeparatorGadgetClass,
                                  matrixpane,
                                  NULL);

    button = XtVaCreateManagedWidget("Relabel Rows",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)RelableRows);


    button = XtVaCreateManagedWidget("Set Column Width",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)SetColumnWidth);

    button = XtVaCreateManagedWidget("Set Column Data",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)SetColumnData);

    button = XtVaCreateManagedWidget("Set Column Name",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)SetColumnName);

    sep = XtVaCreateManagedWidget("sep",
				  xmSeparatorGadgetClass,
                                  matrixpane,
                                  NULL);

    button = XtVaCreateManagedWidget("Delete a Row",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)DelRow);

    button = XtVaCreateManagedWidget("Delete a Column",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)DelColumn);


/*
    XtAddEventHandler(tableMW, ButtonPressMask, False,
                     (XtEventHandler)event_handler,
                     (XtPointer)matrixpane);
*/

/********************************************************************/
/*      Status Area                                                 */
/********************************************************************/

/*    frameSA = XtVaCreateManagedWidget("frame", 
                        xmFrameWidgetClass, fm,
                        XmNtopWidget,           frameMW,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopOffset,		4,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNbottomOffset,	4,
                        NULL);

    item = XmStringCreateSimple("Status :  ");

    cap = XtVaCreateManagedWidget("w",
			xbaeCaptionWidgetClass, frameSA,
                        XmNlabelOffset, 5,
                        XmNlabelString, item,
                        XmNheight, 30,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,		50,
			NULL);
    XmStringFree(item); 

    cMsql.status = XtVaCreateManagedWidget("w",
			xmTextFieldWidgetClass, frameSA,
                        XmNeditable, False,
                        XmNcolumns, 40,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,		54,
			NULL);
*/
    setStatusLine("Click Connect Now!");

/*    XmMainWindowSetAreas(toplevel, NULL, frameSA, NULL, NULL, fm);*/

/********************************************************************/
/*      Debug Sub-menu                                              */
/********************************************************************/

    debugpane = XmCreatePulldownMenu(menubar,
				    "pane5",
				    NULL, 0);

    button = XtVaCreateManagedWidget("Debug",
				      xmCascadeButtonGadgetClass,
				      menubar,
				      XmNsubMenuId, debugpane,
				      NULL);

    button = XtVaCreateManagedWidget("Debug Xmsql ON",
				      xmPushButtonGadgetClass,
				      debugpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,debugOnXmsql,NULL);

    button = XtVaCreateManagedWidget("Debug Xmsql OFF",
				      xmPushButtonGadgetClass,
				      debugpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,debugOffXmsql,NULL);

    button = XtVaCreateManagedWidget("Debug Field Data",
				      xmPushButtonGadgetClass,
				      debugpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,debugField,NULL);

    button = XtVaCreateManagedWidget("Debug Command List",
				      xmPushButtonGadgetClass,
				      debugpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,debugLst,NULL);

    sep = XtVaCreateManagedWidget("sep",
				      xmSeparatorGadgetClass,
                                      debugpane,
                                      NULL);

    button = XtVaCreateManagedWidget("ViewLog",
				      xmPushButtonGadgetClass,
				      debugpane,
				      NULL);

    XtAddCallback(button,XmNactivateCallback,view,NULL);

    XtRealizeWidget(shell);

    XtAppMainLoop(theApp);

    exit(0);
}

