/*--------------------------------------------------------------*/
/* 								*/
/* xmsql version 0.4						*/
/*								*/
/* xmsql is a X interface to the mSQL database			*/
/*								*/
/* xmsql is distributed WITHOUT ANY WARRENTY; 			*/
/* see README for details.					*/
/* Copyright (C) 1995 Stefan Dupont-Christ			*/
/* Heavily modified by Debursky Ko (debursky@deb.lumax.com.tw)  */
/*--------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <Xm/Xm.h>
#include <Xm/BulletinB.h>
#include <Xm/ArrowB.h>
#include <Xm/Frame.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/PushB.h>
#include <Xm/FileSB.h>
#include <Xm/Label.h>
#include <Xm/PushBG.h>
#include <Xm/SeparatoG.h>
#include <Xm/MenuShell.h>
#include <Xm/MainW.h>
#include <Xm/MessageB.h>
#include <Xm/FileSB.h>
#include <Xm/DialogS.h>
#include <Xm/TextF.h>

#include "ComboBox.h"
#include <Xbae/Matrix.h>
#include <Xbae/Caption.h>

#include <ctype.h>
#include <stdio.h>
#include <string.h>

#include "common.h"
#include "flist.h"
#include "cmlist.h"
#include "dialog.h"
#include "matrix.h"
#include "dbtool.h"
#include "trans.h"

/*
extern void connectRemoteServer(Widget, XEvent*, String*, Cardinal*);
*/

XtAppContext     theAPP;
Display          *appDisplay = NULL;
CWidgets         cWidgets; 
Widget           cmBox;
CmList           *cmList;
Pixel            blue, red, green, grey, black;
HighlightStruct  hs;

Pixel GetNamedColor(widget, colorname)
Widget widget;
String colorname;
{
        Display  *display;
        Colormap cmap;
        XColor   alloc_color, exact_color;

        display = XtDisplay(widget);
        XtVaGetValues(widget, XtNcolormap, &cmap, NULL);

        if ( XAllocNamedColor(display, cmap, colorname,
             &alloc_color, &exact_color))
                return alloc_color.pixel;
        else {
                setStatusLine("Can't allocate color");
                return (Pixel) NULL;
        }
}                

Pixel FreeColor(widget, pixel_value)
Widget widget;
Pixel pixel_value;
{

        Colormap cmap;

        XtVaGetValues(widget, XtNcolormap, &cmap, NULL);

        XFreeColors(XtDisplay(widget), cmap, &pixel_value,1, 0);
}                


void Print(Widget w, XtPointer client, XtPointer call)
{
	XmCommandCallbackStruct *p = (XmCommandCallbackStruct *)call;
	char			*t;

	XmStringGetLtoR(p->value, XmFONTLIST_DEFAULT_TAG, &t);
	fprintf(stderr, "Command : '%s'\n", t);
	XtFree(t);
}

void Quit(Widget w, XtPointer client, XtPointer call)
{
        FreeColor(toplevel,blue);
        FreeColor(toplevel,black);
        FreeColor(toplevel,green);
        FreeColor(toplevel,grey);
        FreeColor(toplevel,red);
	exit(0);
}

static void event_handler(Widget w, XtPointer client, XEvent* event,
                          Boolean* dispatching)
{
        Widget menuPopup;

        menuPopup = (Widget) client;

        if (menuPopup == NULL) 
                return;

        if (event->xbutton.button == Button3) {
                XmMenuPosition(menuPopup, 
                              (XButtonPressedEvent*) event);
                XtManageChild(menuPopup);
        }
}


void fileCB(Widget w, XtPointer client, XtPointer call)
{
        XmFileSelectionBoxCallbackStruct* ptr = 
        (XmFileSelectionBoxCallbackStruct*) call;

        char*                             string;
        char*                             tmptbl;
        char                              tmp[50];
        int                               dir_pos;
        int                               i;
        int                               table_len;


        XmStringGetLtoR(ptr->value, XmSTRING_DEFAULT_CHARSET, &string);
      
        cMsql.file = string;
        table_len = strlen(string);
        strcpy(tmp , string);

        i = 1;
        while (i < 50 )  
              if (tmp[i++] == '/') dir_pos=i-1;
           
        for (i=0; i < (table_len - dir_pos); i++)
                tmp[i] = tmp[i+dir_pos+1] ;

        tmp[i+1] = 0x0d;        
        tmptbl = (char*)malloc((dir_pos + 1)* sizeof(char));
        strncpy(tmptbl, tmp, dir_pos);
        cMsql.table = strtok(tmptbl,".");
        fprintf(debugfp,"Opened table: %s\tFile : %s\n",cMsql.table,cMsql.file);
        free (tmptbl);
        XtFree(string);
        XtDestroyWidget(w);
        
        openDbase();

}

void saveCB(Widget w, XtPointer client, XtPointer call)
{
        char tmp[21];

        sprintf(tmp,"%s",cMsql.tbls[cMsql.currentTbl]);
        fprintf(debugfp,"saveCB: %s %d\n",tmp,cMsql.currentTbl);
        updateSQL(tmp,SQL_type);
}

void save_bkpCB(Widget w, XtPointer client, XtPointer call)
{
        char tmp[21];

        sprintf(tmp,"%sbck",cMsql.tbls[cMsql.currentTbl]);
        fprintf(debugfp,"save_bkpCB: %s %d\n",tmp,cMsql.currentTbl);
        updateSQL(tmp,SQL_type);
}

void saveDB(table)
char *table;
{
/* 
        char             *nullstr = "''";
        char             fldstr[32];
        char             *tmpflds;
        char             tmpstr[50];
        char             *tmplen;
        static char      tmptok[50];
        static int       fldstype[50];
        static int       fldslen[50];

        static char      qstr[1024];
        int              i, j, k;
        int              len;
        int              hsz,drs;
        int              ver=3,dd=24,mm=8,yy=97;

        FILE  *ofptr;

        ofptr=fopen("xmsql.dbf","wb");

        cMsql.fldsCount = XbaeMatrixNumColumns(tableMW);
        cMsql.rowsCount = XbaeMatrixNumRows(tableMW);

        fprintf(ofptr,"\n%c%c%c%c",ver,yy,mm,dd);
        fprintf(ofptr,"\n%d%d%d%d",ver,yy,mm,dd);
        
        fprintf(debugfp,"Start to do Table %s,C:%d/R:%d\n",table,
                        cMsql.fldsCount,cMsql.rowsCount);

        fprintf(debugfp,"Start to do Table %s\n",table);
        bzero(fldstr,sizeof(fldlstr));
        fprintf(debugfp,"Start analyze field data\n");
        for (i = 0; i < cMsql.fldsCount; i++) {
                strcpy(tmpstr , cMsql.fldslist[i]);
                len = strlen(tmpstr);
                tmpflds = strtok(tmpstr,":");
                j = strlen(tmpflds);
                if (j > 11) j=11; 
                hsz += 32;
                
                tmplen = &tmpstr[j+2];
                fldslen[i]=atoi(tmplen);

                drs += fldslen[i];
        }        

        i = cMsql.rowsCount;
        j = i/256;
        k = i - 256*j; 
        fprintf(ofptr,"%c%c%c%c",k,j,0,0);
        i = hsz;
        j = i/256;
        k = i - 256*j; 
        fprintf(ofptr,"%c%c",k,j);
        i = drs;
        j = i/256;
        k = i - 256*j; 
        fprintf(ofptr,"%c%c",k,j);

        for (i=12; i<32; i++)
                 fprintf(ofptr,"%c",0);

        for (i = 0; i < cMsql.fldsCount; i++) {
                strcpy(tmpstr , cMsql.fldslist[i]);
                len = strlen(tmpstr);
                tmpflds = strtok(tmpstr,":");
                k = j = strlen(tmpflds);
                if (k > 11) k=11; 
                
                strncpy(fldstr,tmpflds,j);
                fprintf(ofptr,"%s",fldstr);
                for (;k<11;k++)
                         fprintf(ofptr,"%c",0);
       
                tmplen = &tmpstr[j+2];
                fldslen[i]=atoi(tmplen);

                fldstype[i]=tmpstr[j+1];
                switch(tmpstr[j+1]) {
                case 'R' :
                case 'C' : fprintf(ofptr,"%c",0x43);  
                           break;
                case 'N' : fprintf(ofptr,"%c",0x45);  
                           break;
                default  : break;
                }
                for (k=12;k<16;k++)
                         fprintf(ofptr,"%c",0);
                fprintf(ofptr,"%c", tmplen);
                for (k=17;k<32;k++)
                         fprintf(ofptr,"%c",0);
                bzero(tmptok, sizeof(tmptok));
        }        
        fprintf(ofptr,"%c",0x0d);

        bzero(qstr,sizeof(qstr));
        for (i=0; i < cMsql.rowsCount; i++) {
                  for (j=0; j < cMsql.fldsCount; j++) {
		            cMsql.tempCell=XbaeMatrixGetCell(tableMW,i,j);
		            if (fldstype[j]==0x43) {
                                    sprintf(tmpstr,"'%s'",cMsql.tempCell);
                                    if (!strcmp(tmpstr,nullstr)) strcat(qstr,"'!n'");
                                    else              strcat(qstr,tmpstr);
                            }
                            if (fldstype[j]==0x4e) {
                                    sprintf(tmpstr,"%s",cMsql.tempCell);
                                    if (!strcmp(tmpstr,"")) strcat(qstr,"0");
                                    else              strcat(qstr,tmpstr);
                            }
                  }
                  bzero(qstr,sizeof(qstr));
        }
        
        fclose(ofptr);
*/
}

void Open(Widget w, XtPointer client, XtPointer call)
{
        Widget       button;
        Arg          args[5];
        Cardinal     n;

        n = 0;
        button = XmCreateFileSelectionDialog(toplevel, "filesb", args, n);
   
        XtAddCallback(button, XmNokCallback, fileCB, NULL); 
        XtAddCallback(button, XmNcancelCallback, filecancelCB, NULL); 

        XtManageChild(button);
}

String fallbacks[] = { 
  "*fontList: fixed,-*-courier-medium-r-*--*-180-*=LG_LIST_TAG,"
  "fixed,-*-courier-medium-r-*--*-120-*=SM_LIST_TAG",
  "*background: gray",
  "*foreground: black",
  "*cellHighlightThickness: 2",
  "*cellShadowThickness: 2",
  "*cellMarginWidth: 0",
  "*cellMarginHeight: 3",
  "*gridType:		grid_shadow_in",
  "*rowLabelColor:	Red",
  "*columnLabelColor:	Red",
  "*tableMW.gridLineColor: orange",
  "*tableMW.traverseFixedCells:	True",
  NULL };

#define DEFAULT_WIDTH  750
#define DEFAULT_HEIGHT 550

FILE   *debugfp;  
int    debug;

int
main(int argc, char **argv)
{
    XtAppContext theApp;
    Widget shell, menubar, filepane;
    Widget sep, button;
    Widget saveAsPane;
    Widget editpane, controlpane, local, remote;
    Widget cap, frameCombo, frameCD, frameSA, rc, cmButton;
    Widget frameMW, fm, matrixpane, transactionpane, debugpane;
    XmString xmstr, item;

    int width = DEFAULT_WIDTH, height = DEFAULT_HEIGHT;

    Arg          args[5];
    Cardinal     n;

    cMsql.connection = -1;
    cMsql.dbs = NULL;
    cMsql.count = 0;
    cMsql.currentDB = -1;
    cMsql.tbls = NULL;
    cMsql.flist = (Flist *)malloc(sizeof(Flist));
    cMsql.flist->fldno = -1;
    cMsql.flist->next = cMsql.flist->prev = cMsql.flist;
    cMsql.tblsCount = 0;
    cMsql.fldsCount = 0;
    cMsql.cmCount = 0;
    cMsql.transCount = 0;

    cmList = (CmList *)malloc(sizeof(CmList));
    cmList->next = cmList->prev = cmList;

    transList = (TransList *)malloc(sizeof(TransList));
    transList->transno = -1;
    transList->next = transList->prev = transList;

    shell = XtVaAppInitialize(&theApp, "mainW", NULL, 0,
				 &argc, argv, fallbacks, NULL);

    if(HeightOfScreen(XtScreen(shell)) < DEFAULT_HEIGHT) 
       height = HeightOfScreen(XtScreen(shell)) * .85;

    if(WidthOfScreen(XtScreen(shell)) < DEFAULT_WIDTH)
       width = WidthOfScreen(XtScreen(shell)) * .85;
       
    toplevel = XtVaCreateWidget("mainW", xmMainWindowWidgetClass,
				 shell,
				 XmNcommandWindowLocation, 
				 XmCOMMAND_BELOW_WORKSPACE,
				 XmNwidth, width,
				 XmNheight, height,
				 NULL);

    XtManageChild(toplevel);

    menubar = XmCreateMenuBar(toplevel,
			      "menuBar",
			      NULL,0);
    XtManageChild(menubar);
    

/********************************************************************/
/*      File Sub-menu                                               */
/********************************************************************/

    filepane = XmCreatePulldownMenu(menubar,
				    "pane",
				    NULL,0);
    xmstr = XmStringCreateSimple("File");
    
    button = XtVaCreateManagedWidget("File",
				     xmCascadeButtonWidgetClass,
				     menubar,
				     XmNsubMenuId, filepane,
                                     XmNlabelString, xmstr,
				     NULL);

    button = XtVaCreateManagedWidget("OpenDBF",
				      xmPushButtonGadgetClass,
				      filepane,
				      NULL);

    XtAddCallback(button,XmNactivateCallback,Open,NULL);


    sep = XtVaCreateManagedWidget("sep",
				  xmSeparatorGadgetClass,
                                  filepane,
                                  NULL);

    button = XtVaCreateManagedWidget("AppendSql",
				      xmPushButtonWidgetClass,
				      filepane,
				      NULL);

    XtAddCallback(button,XmNactivateCallback,appendCB,NULL);

    button = XtVaCreateManagedWidget("Save",
				      xmPushButtonWidgetClass,
				      filepane,
				      NULL);

    XtAddCallback(button,XmNactivateCallback,saveCB,NULL);

    button = XtVaCreateManagedWidget("Save_to_Bkp",
				      xmPushButtonWidgetClass,
				      filepane,
				      NULL);

    XtAddCallback(button,XmNactivateCallback,save_bkpCB,NULL);


    saveAsPane = XmCreatePulldownMenu(filepane,
				      "save_as",
				      NULL, 0);

    button = XtVaCreateManagedWidget("Save As",
				      xmCascadeButtonWidgetClass,
				      filepane,
				      XmNsubMenuId, saveAsPane,
				      NULL);

    button = XtVaCreateManagedWidget("SQL Table",
				      xmPushButtonWidgetClass,
				      saveAsPane,
				      NULL);

    XtAddCallback(button,XmNactivateCallback,sqlTableCB,NULL);

    button = XtVaCreateManagedWidget("Dbase",
				      xmPushButtonWidgetClass,
				      saveAsPane,
				      NULL);

    XtAddCallback(button,XmNactivateCallback,dbaseCB,NULL);

    button = XtVaCreateManagedWidget("LaTeX",
				      xmPushButtonWidgetClass,
				      saveAsPane,
				      NULL);
				      
    button = XtVaCreateManagedWidget("Quit",
				      xmPushButtonWidgetClass,
				      filepane,
				      NULL);
    XtAddCallback(button,XmNactivateCallback,Quit,NULL);
				      
/********************************************************************/
/*      Edit Sub-menu                                               */
/********************************************************************/

    editpane = XmCreatePulldownMenu(menubar,
				    "pane2",
				    NULL, 0);

    button = XtVaCreateManagedWidget("Edit",
				      xmCascadeButtonGadgetClass,
				      menubar,
				      XmNsubMenuId, editpane,
				      NULL);

    button = XtVaCreateManagedWidget("Cut",
				      xmPushButtonGadgetClass,
				      editpane,
				      NULL);

/********************************************************************/
/*      Control Sub-menu                                            */
/********************************************************************/

    controlpane = XmCreatePulldownMenu(menubar,
				    "pane3",
				    NULL, 0);

    button = XtVaCreateManagedWidget("Control",
				      xmCascadeButtonGadgetClass,
				      menubar,
				      XmNsubMenuId, controlpane,
				      NULL);

    local = XtVaCreateManagedWidget("Local Server",
				      xmPushButtonGadgetClass,
				      controlpane,
				      NULL);
				      
    XtAddCallback(local,XmNactivateCallback,connectLocalServer,NULL);

    remote = XtVaCreateManagedWidget("Remote Server",
				      xmPushButtonGadgetClass,
				      controlpane,
				      NULL);
				      
    XtAddCallback(remote,XmNactivateCallback,connectRemoteServer,NULL);

    /*    n = 0;
    XtSetArg(args[n], XmNsubMenuId, controlpane);		n++;
    XtSetArg(args[n], XmNmenuHistory, local);		n++;
    button = XmCreateOptionMenu(menubar, "option", args, n);
    XtManageChild(button);
    */

/********************************************************************/
/*      Dbase List                                                  */
/********************************************************************/
        
    fm = XtVaCreateManagedWidget("fm", 
                        xmFormWidgetClass, toplevel,
                        NULL);			

    frameCombo = XtVaCreateManagedWidget("frame", 
                        xmFrameWidgetClass, fm,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNtopOffset,		4,
		      	XmNleftAttachment,	XmATTACH_FORM,
			XmNleftOffset,		4,
					 /*XmNrightAttachment,	XmATTACH_FORM,
			XmNrightOffset,	4,*/
                        NULL);

    rc = XtVaCreateManagedWidget(
	"rc", xmRowColumnWidgetClass, frameCombo,
	XmNchildType,	    XmFRAME_WORKAREA_CHILD,
	XmNadjustLast,	    False,
	XmNradioBehavior,   True,
	XmNradioAlwaysOne,  True,
	XmNorientation,     XmHORIZONTAL,
	XmNpacking,	    XmPACK_COLUMN,
	NULL);

    item = XmStringCreateSimple("DBASE :");
    cap = XtVaCreateManagedWidget("w",
			xbaeCaptionWidgetClass, rc,
                        XmNlabelOffset, 5,
                        XmNlabelString, item,
			NULL);
    comboDB = XmCreateComboBox(cap, "Dbase", NULL, 0);
    XtManageChild(comboDB);

    XmStringFree(item); 
    XtAddCallback(comboDB,XmNselectionCallback,selectDB,NULL);
  
/********************************************************************/
/*      Dbase Table List                                            */
/********************************************************************/

    item = XmStringCreateSimple("TABLE :");
    cap = XtVaCreateManagedWidget("w",
			xbaeCaptionWidgetClass, rc,
                        XmNlabelOffset, 5,
                        XmNlabelString, item,
			NULL);
    comboTable = XmCreateComboBox(cap, "Table", NULL, 0);
    XtManageChild(comboTable);

    XtAddCallback(comboTable,XmNselectionCallback,listFields,NULL);

    XmStringFree(item); 

    frameCombo = XtVaCreateManagedWidget("frame", 
                        xmFrameWidgetClass, fm,
			XmNtopWidget,    frameCombo,
			XmNtopAttachment,	XmATTACH_FORM,
			XmNtopOffset,		4,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		frameCombo,
			XmNrightAttachment,	XmATTACH_FORM,
                        NULL);

    cMsql.status = XtVaCreateManagedWidget("w",
			xmTextFieldWidgetClass, frameCombo,
                        XmNeditable, False,
                        XmNcolumns, 40,
			NULL);
  
/********************************************************************/
/*      Command Dialog                                              */
/********************************************************************/
    frameCD = XtVaCreateManagedWidget("frame", 
                        xmFrameWidgetClass, fm,
                        XmNtopWidget,    frameCombo,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopOffset,		4,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNleftOffset,		4,
                        NULL);

    rc = XtVaCreateManagedWidget(
        "rc", xmRowColumnWidgetClass, frameCD,
	XmNchildType,	    XmFRAME_WORKAREA_CHILD,
	XmNadjustLast,	    False,
	XmNradioBehavior,   True,
	XmNradioAlwaysOne,  True,
	XmNorientation,     XmHORIZONTAL,
	XmNpacking,	    XmPACK_COLUMN,
	NULL);
				         
    item = XmStringCreateSimple("Command :");

    cap = XtVaCreateManagedWidget("w",
			xbaeCaptionWidgetClass, rc,
                        XmNlabelOffset, 5,
                        XmNlabelString, item,
                        XmNheight, 30,
			NULL);

    XmStringFree(item); 

    cMsql.tf = XtVaCreateManagedWidget("tf",
			xmTextFieldWidgetClass, cap,
                        XmNcolumns, 80,
			NULL);
    XtAddCallback(cMsql.tf,XmNactivateCallback,commandInput,NULL);

    cmButton = XtVaCreateManagedWidget("CommandSel", 
                        xmArrowButtonWidgetClass, fm,
			XmNtopWidget,    frameCombo,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopOffset,		4,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		frameCD,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	80,
                        XmNarrowDirection,      1,
			XmNheight,              38,
                        XmNwidth,               10,
                        XmNborderWidth,         3,
                        NULL);

    XtManageChild(cmButton);

    cmBox = XmCreateSelectionDialog(toplevel, "CommandHistory", 
                        NULL, 0);
			
    XtAddCallback(cmBox, XmNokCallback, execmBox, NULL);
    XtAddCallback(cmButton, XmNactivateCallback, cmPush, cmBox);
/********************************************************************/
/*      Matrix  Area                                                */
/********************************************************************/
    
    frameMW = XtVaCreateManagedWidget("frame", 
                        xmFrameWidgetClass, fm,
		       	XmNtopWidget,		frameCD,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopOffset,		4,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNleftOffset,		4,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNrightOffset,	4,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNbottomOffset,		4,
                        NULL);

/********************************************************************/
/*      Matrix Area                                                 */
/********************************************************************/

    tableMW = XtVaCreateManagedWidget("tableMW", 
                        xbaeMatrixWidgetClass,  frameMW, 
                        NULL);
			
    XtAddCallback(tableMW, XmNenterCellCallback, MWEnter, NULL);
    XtAddCallback(tableMW, XmNleaveCellCallback, MWLeave, NULL);
    XtAddCallback(tableMW, XmNlabelActivateCallback, MWHighLight, NULL);


/********************************************************************/
/*      Color Area                                                  */
/********************************************************************/

    XtVaGetValues(toplevel,XmNbackground,&blue,NULL);;
    red    = GetNamedColor(toplevel, "red");
    green  = GetNamedColor(toplevel, "green");
    grey   = GetNamedColor(toplevel, "grey");
    black  = GetNamedColor(toplevel, "black");

/********************************************************************/
/*      Matrix PopUp                                                */
/********************************************************************/

/*
    n = 0;
    matrixpane = XmCreatePopupMenu(tableMW, "pane4", args, n);
*/
    matrixpane = XmCreatePulldownMenu(menubar,
				    "pane4",
				    NULL, 0);

    button = XtVaCreateManagedWidget("Matrix",
				      xmCascadeButtonGadgetClass,
				      menubar,
				      XmNsubMenuId, matrixpane,
				      NULL);

    button = XtVaCreateManagedWidget("Add a Row",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)AddRow);

    button = XtVaCreateManagedWidget("Add Rows",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)AddRows);

    button = XtVaCreateManagedWidget("Add a Column",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)AddColumn);

    button = XtVaCreateManagedWidget("Add a tail-Column",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)AddTailColumn);

    sep = XtVaCreateManagedWidget("sep",
				  xmSeparatorGadgetClass,
                                  matrixpane,
                                  NULL);

    button = XtVaCreateManagedWidget("Relabel Rows",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)RelableRows);

    button = XtVaCreateManagedWidget("Upcase Column Labels",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)UpColumnLabel);

    button = XtVaCreateManagedWidget("Lowercase Column Labels",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)LowColumnLabel);


    button = XtVaCreateManagedWidget("Set Column Width",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)SetColumnWidth);

    button = XtVaCreateManagedWidget("Set Column Data",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)SetColumnData);

    button = XtVaCreateManagedWidget("Set Column Name",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)SetColumnName);

    sep = XtVaCreateManagedWidget("sep",
				  xmSeparatorGadgetClass,
                                  matrixpane,
                                  NULL);

    button = XtVaCreateManagedWidget("Delete a Row",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)DelRow);

    button = XtVaCreateManagedWidget("Delete a Column",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)DelColumn);

    sep = XtVaCreateManagedWidget("sep",
				  xmSeparatorGadgetClass,
                                  matrixpane,
                                  NULL);

    button = XtVaCreateManagedWidget("Traverse ON",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)TraverseON);

    button = XtVaCreateManagedWidget("Traverse OFF",
				      xmPushButtonGadgetClass,
				      matrixpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,MWHandle,(XtPointer)TraverseOFF);

/*
    XtAddEventHandler(tableMW, ButtonPressMask, False,
                     (XtEventHandler)event_handler,
                     (XtPointer)matrixpane);
*/

/********************************************************************/
/*      Status Area                                                 */
/********************************************************************/

/*    frameSA = XtVaCreateManagedWidget("frame", 
                        xmFrameWidgetClass, fm,
                        XmNtopWidget,           frameMW,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopOffset,		4,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNbottomOffset,	4,
                        NULL);

    item = XmStringCreateSimple("Status :  ");

    cap = XtVaCreateManagedWidget("w",
			xbaeCaptionWidgetClass, frameSA,
                        XmNlabelOffset, 5,
                        XmNlabelString, item,
                        XmNheight, 30,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,		50,
			NULL);
    XmStringFree(item); 

    cMsql.status = XtVaCreateManagedWidget("w",
			xmTextFieldWidgetClass, frameSA,
                        XmNeditable, False,
                        XmNcolumns, 40,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,		54,
			NULL);
*/
    setStatusLine("Click Connect Now!");

/*    XmMainWindowSetAreas(toplevel, NULL, frameSA, NULL, NULL, fm);*/

/********************************************************************/
/*      Transaction menu                                            */
/********************************************************************/

    transactionpane = XmCreatePulldownMenu(menubar,
				    "pane5",
				    NULL, 0);

    button = XtVaCreateManagedWidget("Transaction",
				      xmCascadeButtonGadgetClass,
				      menubar,
				      XmNsubMenuId, transactionpane,
				      NULL);

    button = XtVaCreateManagedWidget("Commit Transaction",
				      xmPushButtonGadgetClass,
				      transactionpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,commitTrans,NULL);

    button = XtVaCreateManagedWidget("Transaction ON",
				      xmPushButtonGadgetClass,
				      transactionpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,transON,NULL);

    button = XtVaCreateManagedWidget("Transaction OFF",
				      xmPushButtonGadgetClass,
				      transactionpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,transOFF,NULL);

    button = XtVaCreateManagedWidget("Debug Transaction",
				      xmPushButtonGadgetClass,
				      transactionpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,debugTLst,NULL);

    sep = XtVaCreateManagedWidget("sep",
				      xmSeparatorGadgetClass,
                                      transactionpane,
                                      NULL);

    button = XtVaCreateManagedWidget("View Transaction",
				      xmPushButtonGadgetClass,
				      transactionpane,
				      NULL);

    XtAddCallback(button,XmNactivateCallback,view,(XtPointer)ViewTrans);

/********************************************************************/
/*      Debug Sub-menu                                              */
/********************************************************************/

    debugpane = XmCreatePulldownMenu(menubar,
				    "pane6",
				    NULL, 0);

    button = XtVaCreateManagedWidget("Debug",
				      xmCascadeButtonGadgetClass,
				      menubar,
				      XmNsubMenuId, debugpane,
				      NULL);

    button = XtVaCreateManagedWidget("Debug Xmsql ON",
				      xmPushButtonGadgetClass,
				      debugpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,debugOnXmsql,NULL);

    button = XtVaCreateManagedWidget("Debug Xmsql OFF",
				      xmPushButtonGadgetClass,
				      debugpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,debugOffXmsql,NULL);

    button = XtVaCreateManagedWidget("Debug Field Data",
				      xmPushButtonGadgetClass,
				      debugpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,debugField,NULL);

    button = XtVaCreateManagedWidget("Debug Command List",
				      xmPushButtonGadgetClass,
				      debugpane,
				      NULL);
				      
    XtAddCallback(button,XmNactivateCallback,debugLst,NULL);

    sep = XtVaCreateManagedWidget("sep",
				      xmSeparatorGadgetClass,
                                      debugpane,
                                      NULL);

    button = XtVaCreateManagedWidget("ViewLog",
				      xmPushButtonGadgetClass,
				      debugpane,
				      NULL);

    XtAddCallback(button,XmNactivateCallback,view,(XtPointer)ViewLog);

    XtRealizeWidget(shell);

    XtAppMainLoop(theApp);

    exit(0);
}

