/* view.c - View text file operations */
/* Borrowed from XMFTP                */
/************************************************************************/

#include <Xm/Text.h>
#include <Xm/DialogS.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/List.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <syslog.h>

extern Widget toplevel;

Widget create_view_window()
{
  Widget output, text;
  Arg args[10];
  int n = 0;

  output = XmCreateFormDialog(toplevel, "View", NULL, 0);
  
  XtSetArg(args[n], XmNrows, 24); n++;
  XtSetArg(args[n], XmNcolumns, 80); n++;
  XtSetArg(args[n], XmNeditable, False); n++;
  XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
  XtSetArg(args[n], XmNcursorPositionVisible, False); n++;
  XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
  XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;

  text = XmCreateScrolledText(output, "text", args, n);
  XtVaSetValues(output, XmNuserData, text, NULL);

  XtVaCreateManagedWidget("OK", xmPushButtonWidgetClass, output,
			  XmNleftAttachment, XmATTACH_POSITION,
			  XmNleftPosition, 40,
			  XmNrightAttachment, XmATTACH_POSITION,
			  XmNrightPosition, 60,
			  XmNtopAttachment, XmATTACH_WIDGET,
			  XmNtopWidget, text,
			  XmNtopOffset, 20,
			  XmNbottomAttachment, XmATTACH_FORM,
			  XmNbottomOffset, 20,
			  NULL);
  return output;
}  

/************************************************************************/
  
int read_file(Widget text_w, char *file)
{
  char *text;
  FILE *fp;
  unsigned long int size;

  if(!(fp = fopen(file, "r")))
      return 0;

  fseek(fp, 0L, SEEK_END);
  size = ftell(fp);
  rewind(fp);
    
  if(!(text = (char *) malloc((sizeof(char) * size) + 1))) {
    fprintf(stderr, "Could not allocate enough memory :(\n");
    fclose(fp);
    return 0;
  }

  fread(text, sizeof(char), size + 1, fp);
  text[size] = 0;

  XmTextSetString(text_w, text);

  free(text);
  fclose(fp);
  return 1;
}

/************************************************************************/

void view(Widget w, XtPointer client_data, XtPointer call_data)
{
  Widget output, text;

  output = create_view_window();
  XtVaGetValues(output, XmNuserData, &text, NULL);

  if(!read_file(text, "/xmsql-0.4/xmsql.log")) {
    syslog(LOG_INFO, "Error viewing file.\n");
  }

  XtManageChild(text);
  XtManageChild(output);
}
