/*--------------------------------------------------------------*/
/* 								*/
/* xmsql version 0.4						*/
/*								*/
/* xmsql is a X interface to the mSQL database			*/
/*								*/
/* xmsql is distributed WITHOUT ANY WARRENTY; 			*/
/* see README for details.					*/
/* Copyright (C) 1995 Stefan Dupont-Christ			*/
/* Heavily modified by Debursky Ko (debursky@deb.lumax.com.tw)  */
/*--------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <Xm/Xm.h>
#include <Xm/TextF.h>

#include "ComboBox.h"
#include <Xbae/Matrix.h>
#include <Xbae/Caption.h>

#include <ctype.h>
#include <stdio.h>
#include <string.h>

#include "common.h"
#include "flist.h"
#include "matrix.h"
#include "trans.h"

/*
extern void connectRemoteServer(Widget, XEvent*, String*, Cardinal*);
*/

void setStatusLine(String msg)
{
  XmTextFieldSetString(cMsql.status, msg);
}

void MWHandle(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
   int       type = (int) client;
   String    *rowDatas;
   short     *widths;
   short     rowWidth;
   Flist     *flist;
   int       i;

   switch (type)  
   {
        case AddRow  :
        case AddRows : 
                 if (hs.lastrow == -1) hs.lastrow = 0;
                 rowDatas = (String *)malloc((cMsql.fldsCount+1)*sizeof(String));
                 for (i = 0; i < cMsql.fldsCount; i++)
	                  rowDatas[i] = XbaeMatrixGetCell(tableMW, 
                                 hs.lastrow, i);
                 for (i = 0; i < ((type == 1) ? 1 : 5); i++)
                          XbaeMatrixAddRows(tableMW, hs.lastrow+i, rowDatas, 
                                 NULL, NULL, 1);  
                 hs.lastrow += (type == 1) ? 1 : 5;
                 cMsql.rowsCount = XbaeMatrixNumRows(tableMW);
                 free ((String *)rowDatas);
                 break;
        case AddColumn : 
                 ColChoice(AddColumn);
                 break;
        case AddTailColumn : 
                 ColChoice(AddTailColumn);
                 break;
        case RelableRows : 
                 rowDatas = (char **)calloc(cMsql.rowsCount+2,sizeof(char *));
                 for (i = 0; i < cMsql.rowsCount; i++) {
       		          rowDatas[i] = (char *)malloc(4);		
	                  sprintf(rowDatas[i], "%d", i+1);
                 }

                 rowWidth = 1;
                 if (i > 9)    rowWidth = 2;
                 if (i > 99)   rowWidth = 3;
                 if (i > 999)  rowWidth = 4;
                 if (i > 9999) rowWidth = 5;
        
                 XtVaSetValues(tableMW,
                          XmNrowLabels,       rowDatas,
                          XmNrowLabelWidth,   rowWidth,
                 	  NULL);
                 free ((char **)rowDatas);
                 break;
        case UpColumnLabel  :  
                 break;
        case LowColumnLabel  :  
                 break;
        case SetColumnWidth : 
                 ColChoice(SetColumnWidth);
                 break;
        case SetColumnData : 
                 ColChoice(SetColumnData);
                 break;
        case SetColumnName : 
                 ColChoice(SetColumnName);
                 break;
        case DelRow : 
                 XbaeMatrixDeleteRows(tableMW, hs.lastrow, 1);  
                 cMsql.rowsCount = XbaeMatrixNumRows(tableMW);
                 break;
        case DelColumn : 
                 XbaeMatrixDeleteColumns(tableMW, hs.lastcolumn, 1);  
                 DecreaseField(cMsql.flist);
                 cMsql.fldsCount = XbaeMatrixNumColumns(tableMW);
                 rewindFlds();
                 reorderFlds();
                 break;
        case TraverseON : 
                 XtVaSetValues(tableMW,
                       XmNvisibleRows,     2,
                       XmNvisibleColumns,  2,
                       XmNfixedRows,       1,
                       XmNfixedColumns,    1,
                       XmNtrailingFixedRows,    1,
                       XmNtrailingFixedColumns, 1,
                       XmNtraverseFixedCells,   True,
		       NULL);
                 XbaeMatrixRefresh(tableMW);
                 break;
        case TraverseOFF : 
                 XtVaSetValues(tableMW,
                       XmNvisibleRows,     2,
                       XmNvisibleColumns,  2,
                       XmNfixedRows,       0,
                       XmNfixedColumns,    0,
                       XmNtrailingFixedRows,    0,
                       XmNtrailingFixedColumns, 0,
                       XmNtraverseFixedCells,   True,
		       NULL);
                 XbaeMatrixRefresh(tableMW);
                 break;
        default :
                 break;
   } 
   XbaeMatrixRefresh(tableMW);
}

void makeEnterSql(XbaeMatrixEnterCellCallbackStruct *cbs, char *tmpstr)
{
        char tmpstr2[40];
        int  row    = cbs->row;
        int  column = cbs->column;

        cMsql.tempCell=XbaeMatrixGetCell(tableMW,row,column);
        seekFld(column);
        switch(cMsql.flist->type) {
	case 'C' : sprintf(tmpstr,"update %s set %s = '%s' ",
                         cMsql.table,cMsql.flist->fld,cMsql.tempCell); 
                   break;
        case 'R' : 
        case 'N' : sprintf(tmpstr,"update %s set %s = %s ",
                         cMsql.table,cMsql.flist->fld,cMsql.tempCell); 
        default  : break;
        }

        cMsql.tempCell=XbaeMatrixGetCell(tableMW,row,0);
        rewindFlds();
        switch(cMsql.flist->type) {
	case 'C' : sprintf(tmpstr2,"where %s = '%s' ",
                         cMsql.flist->fld,cMsql.tempCell); 
                   break;
        case 'R' : 
        case 'N' : sprintf(tmpstr2,"where %s = %s ",
                         cMsql.flist->fld,cMsql.tempCell); 
        default  : break;
        }
        strcat(tmpstr, tmpstr2);
         
}

void makeLeaveSql(XbaeMatrixLeaveCellCallbackStruct *cbs, char *tmpstr)
{
        char tmpstr2[40];
        int  row    = cbs->row;
        int  column = cbs->column;

        cMsql.tempCell=cbs->value;
        seekFld(column);
        switch(cMsql.flist->type) {
	case 'C' : sprintf(tmpstr,"update %s set %s = '%s' ",
                         cMsql.table,cMsql.flist->fld,cMsql.tempCell); 
                   break;
        case 'R' : 
        case 'N' : sprintf(tmpstr,"update %s set %s = %s ",
                         cMsql.table,cMsql.flist->fld,cMsql.tempCell); 
        default  : break;
        }

        cMsql.tempCell=XbaeMatrixGetCell(tableMW,row,0);
        rewindFlds();
        switch(cMsql.flist->type) {
	case 'C' : sprintf(tmpstr2,"where %s = '%s' ",
                         cMsql.flist->fld,cMsql.tempCell); 
                   break;
        case 'R' : 
        case 'N' : sprintf(tmpstr2,"where %s = %s ",
                         cMsql.flist->fld,cMsql.tempCell); 
        default  : break;
        }
        strcat(tmpstr, tmpstr2);
         
}

void MWLeave(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
        XbaeMatrixLeaveCellCallbackStruct *cbs =
	       (XbaeMatrixLeaveCellCallbackStruct*) call;
        char   tmpstr[80];
        int    i, j;

        TransList  *tlist = (TransList *)malloc(sizeof(TransList));

if (transFlg)
        fprintf(debugfp,"Leave row: %d\tcol: %d\n",cbs->row,cbs->column);

        bzero(tmpstr,sizeof(tmpstr));
        makeLeaveSql(cbs, tmpstr);

        sprintf(tlist->list,"%s",tmpstr);
        tlist->transno = cMsql.transCount++;

        insertTLst(transList,tlist);

if (transFlg) 
        printf ("Leave : %s\n",tmpstr);
        
}

void MWEnter(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
        XbaeMatrixEnterCellCallbackStruct *cbs =
	      (XbaeMatrixEnterCellCallbackStruct*) call;
        char   tmpstr[80];
        int    i, j;

        TransList  *tlist = (TransList *)malloc(sizeof(TransList));

        cMsql.currentFld = cbs->column;
if (transFlg)
        fprintf(debugfp,"Enter row: %d\tcol: %d\n",cbs->row,cbs->column);

        bzero(tmpstr,sizeof(tmpstr));
        makeEnterSql(cbs, tmpstr);
        sprintf(tlist->list,"%s",tmpstr);
        tlist->transno = cMsql.transCount++;

        insertTLst(transList,tlist);

if (transFlg) 
        printf ("Enter : %s\n",tmpstr);
        
}

void MWHighLight(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
    XbaeMatrixLabelActivateCallbackStruct *cbs =
	(XbaeMatrixLabelActivateCallbackStruct*) call;
    Pixel row_color[cMsql.fldsCount];
    Pixel column_color[cMsql.rowsCount];
    int   i;

    fprintf(debugfp,"Row/Column: %d/%d\n",cbs->row,cbs->column);

    if (hs.lastrow > -1) {  
            for (i = 0; i < cMsql.fldsCount; i++)
                     row_color[i]=blue;
            XbaeMatrixSetRowBackgrounds(tableMW, hs.lastrow,row_color,
                     1);
            for (i = 0; i < cMsql.fldsCount; i++)
                     row_color[i]=black;
            XbaeMatrixSetRowColors(tableMW, hs.lastrow,row_color,
                     1);
            XbaeMatrixUnhighlightRow(tableMW, hs.lastrow);
    }
    if (hs.lastcolumn > -1) {
            for (i = 0; i < cMsql.rowsCount; i++)
                     column_color[i]=blue;
            XbaeMatrixSetColumnBackgrounds(tableMW, hs.lastcolumn,
                     column_color,1);
            for (i = 0; i < cMsql.fldsCount; i++)
                     column_color[i]=black;
            XbaeMatrixSetColumnColors(tableMW, hs.lastcolumn,
                     column_color,1);
            XbaeMatrixUnhighlightColumn(tableMW, hs.lastcolumn);
    }
    if (cbs->row != -1) {
            for (i = 0; i < cMsql.fldsCount; i++)
                     row_color[i]=black;
            XbaeMatrixSetRowBackgrounds(tableMW, cbs->row,row_color,
                     1);
            for (i = 0; i < cMsql.fldsCount; i++)
                     row_color[i]=green;
            XbaeMatrixSetRowColors(tableMW, cbs->row,row_color,
                     1);
            XbaeMatrixHighlightRow(tableMW, cbs->row);
            hs.lastrow = cbs->row;
    }
    else if (cbs->column != -1) {
            for (i = 0; i < cMsql.fldsCount; i++)
                     column_color[i]=black;
            XbaeMatrixSetColumnBackgrounds(tableMW, cbs->column,
                     column_color,1);
            for (i = 0; i < cMsql.fldsCount; i++)
                     column_color[i]=green;
            XbaeMatrixSetColumnColors(tableMW, cbs->column,
                     column_color,1);
            XbaeMatrixHighlightColumn(tableMW, cbs->column);
            hs.lastcolumn = cbs->column;
    }     
    
}

void LoadMatrix(w)
Widget w;
{
        char   **rowLabels;
        char   **columnLabels;
        short  *columnWidths;
        int    i;
        

        fprintf(debugfp,"Enter LoadMatrix\n");
        if (cMsql.rowsCount == 0) cMsql.rowsCount=1;
	rowLabels = (char **)calloc(cMsql.rowsCount+2,sizeof(char *));
	for (i = 0; i < cMsql.rowsCount; i++) 
        {
		rowLabels[i] = (char *)malloc(4);		
                sprintf(rowLabels[i], "%d",i+1);
	}

	fprintf(debugfp,"fldsCount : %d\n", cMsql.fldsCount);
	fprintf(debugfp,"rowsCount : %d\n", cMsql.rowsCount);
	columnWidths = (short *)malloc((cMsql.fldsCount+1) * sizeof(short));
	columnLabels = (char **)calloc(cMsql.fldsCount+2,sizeof(char *));

        rewindFlds();
 
	for (i = 0; i < cMsql.fldsCount; i++) 
        {
		columnLabels[i] = (char *)malloc(50 * sizeof (char));
	        sprintf(columnLabels[i] ,"%s", cMsql.flist->fld);	
                columnWidths[i] = cMsql.flist->length;
if (debug)
		fprintf(debugfp,"%s %d\n", columnLabels[i],columnWidths[i]);
		cMsql.flist = cMsql.flist->next; 
	}

        XtVaSetValues(w,
                  XmNrowLabels,       rowLabels,
                  XmNcolumns,         cMsql.fldsCount,
                  XmNrows,            cMsql.rowsCount,
                  XmNcolumnLabels,    columnLabels,
                  XmNcolumnWidths,    columnWidths,
		  XmNallowColumnResize,True,
		  XmNcells,           cMsql.cells,
                  XmNbuttonLabels,    True,
		  NULL);

        free((String **)cMsql.cells);

        if (cMsql.rowsCount == 1) cMsql.rowsCount=0;

        XtVaSetValues(tableMW,         /* disable Traverse */
                  XmNvisibleRows,     0,
                  XmNvisibleColumns,  0,
                  XmNfixedRows,       0,
                  XmNfixedColumns,    0,
                  XmNtrailingFixedRows,    0,
                  XmNtrailingFixedColumns, 0,
                  XmNtraverseFixedCells,   True,
		  NULL);
        if (cMsql.rowsCount == 0) 
                XbaeMatrixDeleteRows(tableMW, 0, 1);

        free ((short *)columnWidths);
        free ((char **)rowLabels);
        free ((char **)columnLabels);

        XbaeMatrixRefresh(tableMW);
        cMsql.fldsCount = XbaeMatrixNumColumns(tableMW);
}






















