/*--------------------------------------------------------------*/
/* 								*/
/* xmsql version 0.4						*/
/*								*/
/* xmsql is a X interface to the mSQL database			*/
/*								*/
/* xmsql is distributed WITHOUT ANY WARRENTY; 			*/
/* see README for details.					*/
/* Copyright (C) 1995 Stefan Dupont-Christ			*/
/* Heavily modified by Debursky Ko (debursky@deb.lumax.com.tw)  */
/*--------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>

#include "common.h"
#include "flist.h"

FILE     *fp;

void insertFld(Flist *head, Flist *flist)
{     
    flist->next = head;
    flist->prev = head->prev;
    head->prev->next = flist;
    head->prev = flist;
}          

void removeFld()
{
    cMsql.flist->prev->next = cMsql.flist->next;
    cMsql.flist->next->prev = cMsql.flist->prev;
}          

void reorderFlds()
{
   int i;

   for (i = 0; i < cMsql.fldsCount ; i++) {
             if (cMsql.flist->fldno == -1) break;
             cMsql.flist->fldno = i;
             cMsql.flist = cMsql.flist->next;
   }

}

void rewindFlds()
{

   if (cMsql.flist->fldno == -1) 
             cMsql.flist = cMsql.flist->prev;
   
   while (cMsql.flist->fldno > 0) {
             cMsql.flist = cMsql.flist->prev;
if (debug)   fprintf(fp,"Flist Rewinding %s(%d)\n",
                     cMsql.flist->fld, cMsql.flist->type);
    }         
}

void emptyFlds()
{
    Flist *tmpflist = cMsql.flist;
 
    if (cMsql.fldsCount == 0) return;
    while (cMsql.fldsCount-- > 0) {
             cMsql.flist = cMsql.flist->prev; 
             removeFld();
if (debug)   fprintf(debugfp,"Flist Removing %s(%d)\n",
                            cMsql.flist->fld, cMsql.flist->type);
    }
    cMsql.flist = tmpflist;
}          

void seekFld(int pos)
{

   rewindFlds();
   while ((cMsql.flist = cMsql.flist->next)->fldno < pos) {
if (debug)   fprintf(debugfp,"Flist Rewinding %s(%d)\n",
                     cMsql.flist->fld, cMsql.flist->type);
   }         
}

void DecreaseField()
{

   seekFld(hs.lastcolumn);
   removeFld(cMsql.flist);
}

void debugField(Widget widget, XtPointer clientData, XtPointer callData)
{
  int  i=0;
  
  setStatusLine("On Debugging Xmsql Fileds!");

  fp = fopen("/xmsql-0.4/xmsql.log","w+");

  rewindFlds();
   
  while (cMsql.flist->fldno > -1) {
        fprintf(fp,"%d Field: type %c\tname %s  \tlen %d\n",
                cMsql.flist->fldno,
                cMsql.flist->type,
                cMsql.flist->fld,
                cMsql.flist->length);
        cMsql.flist = cMsql.flist->next;
  }
  fclose (fp);
  view(widget,clientData,callData);
}  




