/*--------------------------------------------------------------*/
/* 								*/
/* xmsql version 0.4						*/
/*								*/
/* xmsql is a X interface to the mSQL database			*/
/*								*/
/* xmsql is distributed WITHOUT ANY WARRENTY; 			*/
/* see README for details.					*/
/* Copyright (C) 1995 Stefan Dupont-Christ			*/
/* Heavily modified by Debursky Ko (debursky@deb.lumax.com.tw)  */
/*--------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <Xm/Xm.h>
#include <Xm/BulletinB.h>
#include <Xm/ArrowB.h>
#include <Xm/Frame.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/PushB.h>
#include <Xm/FileSB.h>
#include <Xm/Label.h>
#include <Xm/PushBG.h>
#include <Xm/SeparatoG.h>
#include <Xm/MenuShell.h>
#include <Xm/MainW.h>
#include <Xm/MessageB.h>
#include <Xm/FileSB.h>
#include <Xm/DialogS.h>
#include <Xm/TextF.h>

#include <ctype.h>
#include <stdio.h>
#include <string.h>

#include "common.h"
#include "dialog.h"

void okCB(Widget w, XtPointer client, XtPointer call)
{
}

void cancelCB(Widget w, XtPointer client, XtPointer call)
{
}

void helpCB(Widget w, XtPointer client, XtPointer call)
{
}

void filecancelCB(Widget w, XtPointer client, XtPointer call)
{
        XtDestroyWidget(w);
}

void okPromptCB(Widget w, XtPointer client, XtPointer call)
{
        XmSelectionBoxCallbackStruct*  ptr;
        char*                          string;
        int                            type = (int) client;
        
        ptr = (XmSelectionBoxCallbackStruct*) call;
        
        XmStringGetLtoR(ptr->value, XmSTRING_DEFAULT_CHARSET,&string);
        fprintf(debugfp,"Prompted Value: %s\n",string);

        switch (type) 
        {
        case SQL_type   : 
        case APPEND_type: updateSQL(string,type);
                          break;
        case DBASE_type : saveDB(string);
                          break;
        default         : break;
        }                  
                        
        XtFree(string);
}

void AddPromptDlgCB(w, name, type)
Widget  w;
char    *name;
int     type;
{
        XtAddCallback(w, XmNokCallback, okPromptCB, (XtPointer)type);
        XtAddCallback(w, XmNapplyCallback, okPromptCB, (XtPointer)type);
        XtAddCallback(w, XmNcancelCallback, cancelCB, NULL);
        XtAddCallback(w, XmNhelpCallback, helpCB, NULL);
}

void AddDlgCB(w, name)
Widget  w;
char    *name;
{
        XtAddCallback(w, XmNokCallback, okCB, NULL);
        XtAddCallback(w, XmNcancelCallback, cancelCB, NULL);
        XtAddCallback(w, XmNhelpCallback, helpCB, NULL);
}

void CreatePromptDialog(w, name, type)
Widget  w;
char    *name;
int     type;
{
        Widget    prompt;
        Arg       args[5];
        Cardinal  n;
        XmString  item;
        
        item = XmStringCreateSimple(name);
        n = 0;
        XtSetArg(args[n], XmNselectionLabelString, item); n++;
        prompt = XmCreatePromptDialog(w, "Prompt", args, n);

        AddPromptDlgCB(prompt, name, type);

        XtManageChild(prompt);
        XmStringFree(item);
        return;
}

void CreateInfoDialog(w, name)
Widget  w;
char    *name;
{
        Widget    info, cancel;
        Arg       args[5];
        Cardinal  n;
        XmString  item;
        
        item = XmStringCreateSimple(name);
        n = 0;
        XtSetArg(args[n], XmNmessageString, item); n++;
        info = XmCreateInformationDialog(w, "Information", args, n);

        AddDlgCB(info, name);
        
        cancel = XmMessageBoxGetChild(info, XmDIALOG_CANCEL_BUTTON);
        XtUnmanageChild(cancel);
 
        XtManageChild(info);
        XmStringFree(item);
        return;
}

void CreateErrorDialog(w, name)
Widget  w;
char    *name;
{
        Widget    info, cancel;
        Arg       args[5];
        Cardinal  n;
        XmString  item;
        
        item = XmStringCreateSimple(name);
        n = 0;
        XtSetArg(args[n], XmNmessageString, item); n++;
        info = XmCreateInformationDialog(w, "Error", args, n);

        AddDlgCB(info, name);
        
        cancel = XmMessageBoxGetChild(info, XmDIALOG_CANCEL_BUTTON);
        XtUnmanageChild(cancel);
 
        XtManageChild(info);
        XmStringFree(item);
        return;
}

void appendCB(Widget w, XtPointer client, XtPointer call)
{
        CreatePromptDialog(w,"Enter Appended Table Name",APPEND_type);
}

void sqlTableCB(Widget w, XtPointer client, XtPointer call)
{
        CreatePromptDialog(w,"Enter Table Name",SQL_type);
}

void dbaseCB(Widget w, XtPointer client, XtPointer call)
{
        CreatePromptDialog(w,"Enter Dbase File Name",DBASE_type);
}
