/*--------------------------------------------------------------*/
/* 								*/
/* xmsql version 0.4						*/
/*								*/
/* xmsql is a X interface to the mSQL database			*/
/*								*/
/* xmsql is distributed WITHOUT ANY WARRENTY; 			*/
/* see README for details.					*/
/* Copyright (C) 1995 Stefan Dupont-Christ			*/
/* Heavily modified by Debursky Ko (debursky@deb.lumax.com.tw)  */
/*--------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <Xm/Xm.h>
#include <Xm/TextF.h>

#include "ComboBox.h"
#include <Xbae/Matrix.h>
#include <Xbae/Caption.h>

#include <ctype.h>
#include <stdio.h>
#include <string.h>

#include "common.h"
#include "flist.h"
#include "cmlist.h"
#include "matrix.h"
#include "dbtool.h"

/*
extern void connectRemoteServer(Widget, XEvent*, String*, Cardinal*);
*/

void openDbase()
{

    static char  record[400];
    static char  fstring[48];
    static char  qstr[1024];
    static char  tmp[80];
    static char  nulstr[40];
    static char  isnull[40];
    static char  *tmpstr;

    static int   i, field;
    static int   rec_len;
    static int   rec_no;
  
    FILE         *fptr;

if (debug)    fprintf(debugfp,"Enter OpenDbase !\n");
    sprintf(qstr,"cp %s tmp.dbf",cMsql.file);
    system(qstr);
    fptr=fopen("tmp.dbf","rb");
    if (fptr == NULL) fprintf(debugfp,"\nOPEN Failed !");

    fread(fstring,1, 32, fptr);

    printf("VER: %d\tmm/dd/yy: %d/%d/%d\n",fstring[0],
           fstring[1],fstring[2],fstring[3]);
    printf("NDR: %x/%x/%x/%x\n",fstring[4],
           fstring[5],fstring[6],fstring[7]);
    printf("HSZ: %x/%x\tDRS: %x/%x\n",fstring[8],
           fstring[9],fstring[10],fstring[11]);

    emptyFlds();

if (debug)    fprintf(debugfp,"After emptyFlds !\n");

    while (fread(fstring,1,32,fptr) > 0)  {
         Flist   *flist = (Flist *)malloc(sizeof(Flist));
         if (fstring[0] == 0xd) break;

         i = 0;
         while (fstring[i++] != 0);
 
         flist->fld = (char *)malloc(i+1);
         strncpy (flist->fld,fstring,i+1);

         flist->type      = fstring[11];
         flist->length    = fstring[16];
         flist->decimal   = fstring[17];
         flist->fldno     = 
         cMsql.currentFld = cMsql.fldsCount++;

         insertFld(cMsql.flist,flist);

         rec_len += fstring[16];
    }
    
    sprintf(qstr,"drop table %s",cMsql.table);
    if (msqlQuery(cMsql.connection, qstr) == -1)
if (debug)    fprintf(debugfp,"Query Failed !");

if (debug)    fprintf(debugfp,"After drop table, Rec_len : %d\n",rec_len);
    bzero(qstr,sizeof(qstr));
    sprintf(qstr,"create table %s(",cMsql.table);
    
    rewindFlds();

    for (i=0; i < cMsql.fldsCount; i++) {
         switch (cMsql.flist->type)  {
         case 'C': sprintf(tmp, " %s char(%d)",cMsql.flist->fld,
                                               cMsql.flist->length);
                   break;
         case 'N': if (cMsql.flist->decimal == 0)
                       sprintf(tmp, " %s int",cMsql.flist->fld);
                   else
                       sprintf(tmp, " %s real",cMsql.flist->fld);
                   break;
         default : break;
         }
         strcat (qstr, tmp);
         if (i == (cMsql.fldsCount-1)) 
              strcat (qstr, ")");
         else strcat (qstr, ",");
         
         cMsql.flist = cMsql.flist->next; 
    }     
    
    msqlQuery(cMsql.connection, qstr);
if (debug)    fprintf(debugfp,"\nAfter %s", qstr);
    
    rewindFlds();
    fseek(fptr,-30,SEEK_CUR);
    i = rec_no = 0; 
    while ((fread(record,1,cMsql.flist->length,fptr))>0)  {
          if (i == 0)  { 
                 rec_no++;
                 bzero(qstr,sizeof(qstr));
                 sprintf(qstr,"insert into %s values (",cMsql.table);
          }    
          if (i > 0) 
                 strcat (qstr, ",");
          
          tmpstr = strtok(record,"  ");

          if (cMsql.flist->type == 'C') {
                 sprintf(isnull,"%s",tmpstr);
                 if (!strcmp(isnull,"(null)")) 
                     sprintf(nulstr,"'!n'");
                 else
                     sprintf(nulstr,"'%s'",tmpstr);
	  }

/* Type Real is included here. No code needed! */

          if (cMsql.flist->type == 'N')  
                 if (record[cMsql.flist->length - 1] == ' ') 
                     sprintf(nulstr,"%s","0");
                 else
                     sprintf(nulstr,"%s",tmpstr);
          strcat(qstr, nulstr);
          i++;       
          if (i == cMsql.fldsCount) {
                 i = 0;
                 strcat(qstr, ")");
                 if (msqlQuery(cMsql.connection, qstr) == -1) {
if (debug) fprintf(debugfp,"\n ec_no : %d-->Insert Failed %s",rec_no,qstr);
                 }
                 fseek(fptr,1,SEEK_CUR);
                 cMsql.flist = cMsql.flist->next;    
          }   

          bzero(record,sizeof(record));
          bzero(isnull,sizeof(isnull));
          bzero(nulstr,sizeof(nulstr));
          
          cMsql.flist = cMsql.flist->next;    
    }
    
    fclose(fptr);

}   

void createSQLtable(table,type)
char *table;
int  type;
{

        static char      tmpstr[50];
        static char      qstr[1024];

        int              i, j, k;
        int              len;  

        fprintf(debugfp,"Start to do Table %s\n",table);
        bzero(qstr,sizeof(qstr));
        if (type == SQL_type) {
                strcpy(qstr,"drop table ");
                strcat(qstr,table);
                fprintf(debugfp,"Start %s\n",qstr);
                if (msqlQuery(cMsql.connection, qstr) == -1)
                        setStatusLine(msqlErrMsg);
                bzero(qstr,sizeof(qstr));
                fprintf(debugfp,"After drop table\n");
                sprintf(qstr,"create table ");
                strcat(qstr,table);
                strcat(qstr,"(");
        }
        fprintf(debugfp,"Start analyze field data\n");

        rewindFlds();

        for (i = 0; i < cMsql.fldsCount; i++) {
                switch (cMsql.flist->type) {
                case 'C' : sprintf(tmpstr, " %s char(%d)",cMsql.flist->fld
                                                         ,cMsql.flist->length);
                           break;
                case 'N' : sprintf(tmpstr, " %s int",cMsql.flist->fld);
                           break;
                case 'R' : sprintf(tmpstr, " %s real",cMsql.flist->fld);
                           break;
                default  : 
if (debug)
                           fprintf(debugfp,"Field in cMsql: %s/%d\n",
                                  cMsql.flist->fld,cMsql.flist->type);
                           break;
                }
                strcat (qstr, tmpstr);
if (debug)
                fprintf(debugfp,"tmpstr: %s\n",tmpstr);
                if (i == (cMsql.fldsCount-1)) 
                        strcat (qstr, ")");
                else strcat (qstr, ",");
                
                cMsql.flist = cMsql.flist->next; 
        }        

        if (type == SQL_type) {
                msqlQuery(cMsql.connection, qstr);
                fprintf(debugfp,"After %s\n", qstr);
        }
        
}

void insertSQLtable(table)
char *table;
{

        char             *nullstr = "''";
        char             tmpstr[50];

        static char      qstr[1024];
        int              i,j;
    
        FILE  *ofptr;

        ofptr=fopen("xmsql.log","wb");

        fprintf(debugfp,"Start to insert Table %s,C:%d/R:%d\n",table,
                        cMsql.fldsCount,cMsql.rowsCount);

        bzero(qstr,sizeof(qstr));
        for (i=0; i < cMsql.rowsCount; i++) {
                  sprintf(tmpstr,"insert into %s values(",table);
                  strcpy(qstr,tmpstr);
                  rewindFlds();
                  for (j=0; j < cMsql.fldsCount; j++) {
		            cMsql.tempCell=XbaeMatrixGetCell(tableMW,i,j);
                            if (j > 0) strcat(qstr,",");
		            switch (cMsql.flist->type) {
                            case 'C' : sprintf(tmpstr,"'%s'",cMsql.tempCell);
                                       if (!strcmp(tmpstr,nullstr)) 
                                                strcat(qstr,"'!n'");
                                       else     strcat(qstr,tmpstr);
                                       break;
                            case 'N' :           
                            case 'R' : sprintf(tmpstr,"%s",cMsql.tempCell);
                                       if (!strcmp(tmpstr,"")) 
                                                strcat(qstr,"0");
                                       else     strcat(qstr,tmpstr);
                                       break;
                            default  : 
if (debug)
                                       fprintf(debugfp,"Why an unknown type %d(%s) ?\n",
                                               cMsql.flist->type,
                                               cMsql.flist->fld);
                                       break;           
                                       
                            }
                            cMsql.flist = cMsql.flist->next;
                  }
                  strcat(qstr,")");
                  if (msqlQuery(cMsql.connection, qstr) == -1) {
                          fprintf(ofptr,"\nInsert Failed %s",qstr);
                  }
                  bzero(qstr,sizeof(qstr));
        }
        
        fclose(ofptr);
}

void updateSQL(table,type)
char *table;
int  type;
{

        cMsql.fldsCount = XbaeMatrixNumColumns(tableMW);
        cMsql.rowsCount = XbaeMatrixNumRows(tableMW);
        fprintf(debugfp,"Start to do Table %s,C:%d/R:%d\n",table,
                        cMsql.fldsCount,cMsql.rowsCount);

        if ((cMsql.fldsCount == -1) || (cMsql.rowsCount == -1))
                return;

        createSQLtable(table,type);

        insertSQLtable(table);
}

void countField()
{
  int              i;
  m_field          *field;
  char             tmp[50];

  fprintf(debugfp,"Enter countField\n");

  emptyFlds(cMsql.flist);

  cMsql.fldsCount = msqlNumFields(cMsql.res);
  fprintf(debugfp,"Total %d Fields Saw !\n",cMsql.fldsCount);

  for (i = 0; i < cMsql.fldsCount; i++) {
      Flist  *flist = (Flist *)malloc(sizeof(Flist));
      field = msqlFetchField(cMsql.res);
      flist->fld = (char *)malloc(strlen(field->name)+1);

      strcpy(flist->fld , field->name);

      switch (field->type) {
      case CHAR_TYPE : flist->type = 'C';
                       break;
      case INT_TYPE  : flist->type = 'N';
                       break;          
      case REAL_TYPE : flist->type = 'R';
                       break;
      default  :       break;           
      }

      if ((field->type != CHAR_TYPE) ||
          (field->length < strlen(field->name)))
              flist->length = strlen(field->name);
      else
              flist->length = field->length;

if (debug)
      fprintf(debugfp,"countField : %s %d\n",flist->fld,flist->length);
      flist->fldno = i;
      insertFld(cMsql.flist, flist);
  }

}

void dumpTable(index)
        int     index;
{

        char		query[1024], tmp[35];
	m_row 		row;
        char            *space=" ";
	static char     ***rows_str;
	int		i, j;
        CmList          *flist;
	
if (debug) 
        fprintf(debugfp,"Sending SELECT query...\n");
        
        if (index != inputQuery) {
                sprintf(query, "SELECT * FROM %s", cMsql.tbls[index]);
                 
                cMsql.table = cMsql.tbls[index];
                flist = (CmList *)malloc(sizeof(CmList));
                flist->list = (char *)malloc(strlen(query)+1); 
                strcpy(flist->list , query);
                flist->length = strlen(flist->list);
                insertLst(cmList,flist);

         	if (msqlQuery(cMsql.connection, query) == -1) {
         	        strcat(query," Failed!");
                        setStatusLine(query);
      		        return;
                }
                
                if (!(cMsql.res=msqlStoreResult())) { 
                        setStatusLine("Store Query Result Failed !");
                  	return;
                }
        }
        else countField();
        
        cMsql.rowsCount = msqlNumRows(cMsql.res);

	sprintf(tmp,"Retrieved %d rows. Processing...\n", 
			cMsql.rowsCount );
        setStatusLine(tmp);

        if (cMsql.rowsCount < 2) cMsql.rowsCount=5; /*Xbae's Fault*/

        cMsql.cells = (String **)malloc((cMsql.rowsCount+2) * 
                      (cMsql.fldsCount+2) * sizeof(String *));

        rows_str = (char ***)cMsql.cells;        

        j = 0;
	while (row=msqlFetchRow(cMsql.res)) 
	{
                rows_str[j] = (char **)malloc((msqlNumFields(cMsql.res)+1)*
                                               sizeof(char **));
		for (i = 0; i < msqlNumFields(cMsql.res); i++) 
		{
			rows_str[j][i] = (char *)calloc((strlen(row[i])+1),sizeof(char));
			strcpy(rows_str[j][i], row[i]);	
 		}
	      
	        cMsql.cells[j] = &rows_str[j][0];
               
	        j++;
	 }

	while (j < cMsql.rowsCount) 
	{
                rows_str[j] = (char **)malloc((msqlNumFields(cMsql.res)+1)*
                                               sizeof(char **));
		for (i = 0; i < cMsql.fldsCount; i++) 
		{
			rows_str[j][i] = (char *)calloc((strlen(space)+1),sizeof(char));
			strcpy(rows_str[j][i], space);	
 		}
		
	        cMsql.cells[j] = &rows_str[j][0];
                
	        j++;
	 }
	 
         fprintf(debugfp,"Leaving DumpTable !\n"); 
}

void resetComboDB()
{
         XmComboBoxDeleteAllItems(comboDB);
         setStatusLine("Clear DB !");
}

void resetComboTable()
{
         XmComboBoxDeleteAllItems(comboTable);
         setStatusLine("Clear Tables !");
}

void listFields(Widget widget, XtPointer clientData, XtPointer callData)
{
  int              i;
  m_field          *field;
  XmString         item;

/* 
  if (!clientData)
    return;
*/

  if (-1 == cMsql.connection) {
     setStatusLine("Not tableSelected.");
     return;
  }   

  fprintf(debugfp,"Enter Fields Connect for Table\n");

  i = XmComboBoxGetSelectedPos(comboTable);

  if ( i == 0) {
     setStatusLine("Choose the wrong Table !\n");
     return;
  }   		

  fprintf(debugfp,"Fields Connect for Table: %s !\n",cMsql.tbls[--i]);

  cMsql.currentTbl = i;

  cMsql.res = msqlListFields(cMsql.connection, cMsql.tbls[i]);

  if (!cMsql.res) {
     setStatusLine("Fields Connect Fail !");
     return;
  }

  countField();

  msqlFreeResult(cMsql.res);
  dumpTable(cMsql.currentTbl);

  fprintf(debugfp,"After dumpTable\n");

  LoadMatrix (tableMW);
  fprintf(debugfp,"After loadMatrix\n");
  
  hs.lastrow = -1;
  hs.lastcolumn = -1;
}    

void listTables(Widget widget, XtPointer clientData, XtPointer callData)
{  
  m_row row;
  XmString  item;
  int i, n;
  char tmp[35]; 

  if (-1 == cMsql.connection) {
    setStatusLine("Not connected.");
    return;
  }   

  cMsql.res = msqlListTables(cMsql.connection);
  if (cMsql.res) {
    
    cMsql.tblsCount = msqlNumRows(cMsql.res);
    cMsql.tbls = (char **)XtMalloc((cMsql.tblsCount+1) * sizeof(char *));
    for (i = 0; i < cMsql.tblsCount; i++) {
      row = msqlFetchRow(cMsql.res);
      cMsql.tbls[i] = (char *)XtCalloc((strlen(row[0])+1), sizeof(char));
      item = XmStringCreateSimple(row[0]);
      XmComboBoxAddItem(comboTable, item, 0);
      XmStringFree(item);
      strcpy(cMsql.tbls[i], row[0]);
    }

    cMsql.tbls[i] = NULL;

    XmStringFree(item); 

    msqlFreeResult(cMsql.res);

    sprintf(tmp,"%d Tables Got! Choose Table Now!",cMsql.tblsCount);
    setStatusLine(tmp);       
  }
  else
    setStatusLine("No info available.");  
}

void handleQuery()
{
  if (msqlQuery(cMsql.connection, cMsql.qbuf) == -1) {
          setStatusLine("Query Failed !");          
	  return;
  }

  if (!(cMsql.res=msqlStoreResult())) {
          setStatusLine("Query Failed !");          
          return;
  }

  dumpTable(inputQuery);

  LoadMatrix (tableMW);
  
  hs.lastrow = -1;
  hs.lastcolumn = -1;
}

void commandInput(Widget w, XtPointer client, XtPointer call)
{
  CmList  *flist = (CmList *)malloc(sizeof(CmList));

  flist->list = XmTextFieldGetString(w);
  flist->length = strlen(flist->list);

  cMsql.qbuf = XmTextFieldGetString(w);
  
  insertLst(cmList,flist);

  handleQuery();
  bzero(cMsql.qbuf,sizeof(cMsql.qbuf));

}

void selectDB(Widget widget, XtPointer clientData, XtPointer callData)
{
  int i;

  if (cMsql.connection != -1) {

    i = XmComboBoxGetSelectedPos(comboDB);
    if ( i == 0) {
            fprintf(debugfp,"Choose the wrong DB !\n");
            return;
    }   		

    resetComboTable();

    if (-1 == msqlSelectDB(cMsql.connection, cMsql.dbs[--i])) {
      cMsql.currentDB = -1;
      setStatusLine(msqlErrMsg);
      return;
    }
    cMsql.currentDB = i;

    listTables(comboTable, (Arg *)NULL, 0);
  
    setStatusLine("Database selected & Table Updated."); 
  }
}  

void connectDBServer(String hostname)
{
  int sock, dbCount, i;
  m_result *dbs;
  m_row row;
  XmString item;

  sock = msqlConnect(hostname); /* make connection to DB server */
  if (sock == -1) {
    setStatusLine((String)msqlErrMsg);
    return;
  }  
  setStatusLine("Connect Msql OK ! Choose DB Now !!");
  dbs = msqlListDBs(sock);
  if (!dbs) {
    setStatusLine(msqlErrMsg);
    cMsql.connection = -1;
    return;
  }
  
  resetComboDB();
  
  /* set global data */
  cMsql.connection = sock;
  dbCount = msqlNumRows(dbs);
  cMsql.dbs = (char **)XtMalloc((dbCount+1) * sizeof(char *));

  for (i = 0; i < dbCount; i++) {
           row = msqlFetchRow(dbs);
           cMsql.dbs[i] = (char *)XtCalloc((strlen(row[0])+1), sizeof(char));
           item = XmStringCreateSimple(row[0]);
           XmComboBoxAddItem(comboDB, item, 0);
           strcpy(cMsql.dbs[i], row[0]);
  }
  cMsql.dbs[i] = NULL; /* end list with  NULL  */
  cMsql.count = dbCount;  /* number of DBs */
  
  XmStringFree(item); 
  msqlFreeResult(dbs);
    
  setStatusLine("Successfully connected to msql-Server.");     
}  

void connectLocalServer(Widget widget, XtPointer clientData, XtPointer callData)
{
  connectDBServer(NULL);
}  

void connectRemoteServer(Widget widget, XtPointer clientData, XtPointer callData)
{
  connectDBServer(NULL);
}  

void debugOnXmsql(Widget widget, XtPointer clientData, XtPointer callData)
{
  debug = 1;
  
  debugfp = fopen("/xmsql-0.4/xmsql.log","w+");
  setStatusLine("On Debugging Xmsql!");
}  

void debugOffXmsql(Widget widget, XtPointer clientData, XtPointer callData)
{
  debug = 0;
   
  fclose(debugfp);
  setStatusLine("Off Debugging Xmsql!");
}  





