/*--------------------------------------------------------------*/
/* 								*/
/* xmsql version 0.4						*/
/*								*/
/* xmsql is a X interface to the mSQL database			*/
/*								*/
/* xmsql is distributed WITHOUT ANY WARRENTY; 			*/
/* see README for details.					*/
/* Copyright (C) 1995 Stefan Dupont-Christ			*/
/* Heavily modified by Debursky Ko (debursky@deb.lumax.com.tw)  */
/*--------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/TextF.h>

#include <ctype.h>
#include <stdio.h>
#include <string.h>

#include "common.h"
#include "cmlist.h"
#include "dbtool.h"

CmList           *cmList;
FILE             *fp;


void initLst(CmList *clist)
{
    clist = (CmList *)malloc(sizeof(CmList));
    clist->next = clist->prev = clist;
}

void insertLst(CmList *head, CmList *clist)
{     
    clist->next = head;
    clist->prev = head->prev;
    head->prev->next = clist;
    head->prev = clist;
  
    cMsql.cmCount++;
}          

void removeLst(CmList *clist)
{
    clist->prev->next = clist->next;
    clist->next->prev = clist->prev;
}          

void emptyLsts(CmList *clist)
{
    CmList *tmpcmlist = clist;

    if (cMsql.cmCount == 0) return;
    while (cMsql.cmCount-- > 0) {
             clist = clist->prev; 
             removeFld(clist);
    }
    clist = tmpcmlist;
}          

void rewindLst(CmList *clist)
{
    int i=cMsql.cmCount;

    while (i-- > 0) {
             clist = clist->prev;
if (debug)   fprintf(fp,"CmList Rewinding %s(%d)\n",
                     clist->list, clist->length);
    }         
}

void debugLst(Widget widget, XtPointer clientData, XtPointer callData)
{
    int  i=0;
  
    setStatusLine("On Debugging Xmsql Command Lists!");

    fp = fopen("/xmsql-0.4/xmsql.log","w+");

    fprintf(fp,"Command Input are: %d\n",cMsql.cmCount);
  
    rewindLst(cmList);

    while (i++ < cMsql.cmCount) {
          cmList = cmList->next;
          fprintf(fp,"%d: Command List: %s\n",
                  i,cmList->list);
    }
    cmList = cmList->next;
    fclose (fp);
    view(widget,clientData,callData);
}  

void cmPush(Widget w, XtPointer client, XtPointer call)
{
     int        i = 0;
     XmString	items[cMsql.cmCount];
     CmList     *clist; 
     Widget	dialog = (Widget)client;

     clist = cmList;
     rewindLst(clist);
     while (i < cMsql.cmCount) {
            clist = clist->next;
            items[i++] = XmStringCreateSimple(clist->list);
     }       

     XtVaSetValues(dialog, XmNlistItems,	items,
			   XmNlistItemCount,	cMsql.cmCount,
		           NULL);
     
     XtManageChild(dialog);
}

void execmBox(Widget w, XtPointer client, XtPointer call)
{
    XmSelectionBoxCallbackStruct *cbp = (XmSelectionBoxCallbackStruct *)call;
    char *s;

    if (XmStringGetLtoR(cbp->value, XmFONTLIST_DEFAULT_TAG, &s)) {

if (debug)	
        fprintf(fp, "Selection : %s\n", cMsql.qbuf);
  
    XmTextFieldSetString(cMsql.tf, s);
    commandInput(cMsql.tf,client,call); 
    } else
if(debug)
	fprintf(stderr, "Could not convert\n");

}

