/*
 * AUTHOR: Jay Schmidgall <jay.schmidgall@spdbump.sungardss.com>
 *
 * $Id: choice.c,v 1.6 1997/02/08 06:04:52 lister Exp $
 */

#include <Xm/Xm.h>
#include <Xm/BulletinB.h>
#include <Xm/DialogS.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ToggleB.h>
#include <Xm/TextF.h>
#include <Xm/Text.h>

#include <stdio.h>
#include <string.h>

#include "common.h"
#include "ComboBox.h"
#include "Xbae/Matrix.h"
typedef struct {
    Widget  mw;
    int	    value;
} SetValueStruct;

SetColValueStruct  *tableCol;

void cbRadio(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
    XmComboBoxSelectionCallbackStruct *svs = 
                           (XmComboBoxSelectionCallbackStruct *) call;

    switch(svs->index) {
    case 1:  tableCol->type = CHAR_TYPE;
             break;
    case 2:  tableCol->type = INT_TYPE;
             break;
    case 3:  tableCol->type = REAL_TYPE;
             break;
    default: break;
    }         
}

void cbRadioLen(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
    XmComboBoxSelectionCallbackStruct *svs = 
                           (XmComboBoxSelectionCallbackStruct *) call;

    switch(svs->index) {
    case 1:  tableCol->ColLen = (short) 3;
             break;
    case 2:  tableCol->ColLen = (short) 5;
             break;
    case 3:  tableCol->ColLen = (short) 6;
             break;
    case 4:  tableCol->ColLen = (short) 8;
             break;
    case 5:  tableCol->ColLen = (short) 12;
             break;
    case 6:  tableCol->ColLen = (short) 20;
             break;
    default: tableCol->ColLen = (short) 2;
             break;
    }         
}

void cbScale(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
    XmScaleCallbackStruct *cbs = (XmScaleCallbackStruct *) call;
    tableCol->ColLen = (short) cbs->value;

if (debug)
    fprintf(debugfp,"ColLen Set Value is : %d\n", tableCol->ColLen);
}

void ColData(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
    tableCol->ColData = XmTextFieldGetString(w);

if (debug)
    fprintf(debugfp,"ColData is : %s\n", tableCol->ColData);
    
}

void ColLabel(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{

    tableCol->ColLabel = XmTextFieldGetString(w);

if (debug)
    fprintf(debugfp,"ColLabel is : %s\n", tableCol->ColLabel);
    
}


Widget createButtonBox(parent, name)
Widget parent;
char *name;
{
    Widget frame, frame2, label, rc;
    
    frame = XtVaCreateManagedWidget(
	"frame", xmFrameWidgetClass, parent,
	NULL);

    frame2 = XtVaCreateManagedWidget(
	"frame", xmFrameWidgetClass, frame,
	XmNchildType,		    XmFRAME_TITLE_CHILD,
	XmNchildHorizontalAlignment,   XmALIGNMENT_CENTER,
	XmNchildVerticalAlignment,	    XmALIGNMENT_CENTER,
	XmNmarginWidth,		    4,
	NULL);
    
    label = XtVaCreateManagedWidget(
	name, xmLabelWidgetClass, frame2,
	NULL);
    
    rc = XtVaCreateManagedWidget(
	"rc", xmRowColumnWidgetClass, frame,
	XmNchildType,	    XmFRAME_WORKAREA_CHILD,
	XmNadjustLast,	    False,
	XmNradioBehavior,   True,
	XmNradioAlwaysOne,  True,
	XmNorientation,     XmHORIZONTAL,
	XmNpacking,	    XmPACK_COLUMN,
	NULL);
    return rc;
}


Widget createScaleBox(parent, name, min, max)
Widget parent;
char *name;
int min, max;
{
    Widget frame, frame2, label, scale;

    frame = XtVaCreateManagedWidget(
	"frame", xmFrameWidgetClass, parent,
				    NULL);

    frame2 = XtVaCreateManagedWidget(
	"frame", xmFrameWidgetClass, frame,
	XmNchildType,		    XmFRAME_TITLE_CHILD,
	XmNchildHorizontalAlignment,   XmALIGNMENT_CENTER,
	XmNchildVerticalAlignment,	    XmALIGNMENT_CENTER,
	XmNmarginWidth,		    4,
	NULL);

    label = XtVaCreateManagedWidget(
	name, xmLabelWidgetClass, frame2,
	NULL);
    
    scale = XtVaCreateManagedWidget(
	"scale", xmScaleWidgetClass, frame,
	XmNchildType,     XmFRAME_WORKAREA_CHILD,
	XmNorientation,   XmHORIZONTAL,
	XmNminimum,	  min,
	XmNmaximum,	  max,
	XmNscaleMultiple, 1,
	XmNshowValue,     True,
	NULL);
    return scale;
}


void createColType(parent, mw, type)
Widget parent;
Widget mw;
int    type;
{
    XmString   item;
    Widget rc, combo;
    SetValueStruct *svs;

    rc = createButtonBox(parent, "Column Type");

    combo = XtVaCreateManagedWidget(
	"TYPE", xmComboBoxWidgetClass, rc,
	NULL);
/*    
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->value = CHAR_TYPE;
   
    XtAddCallback(button, XmNvalueChangedCallback, cbRadio, (XtPointer) svs);
 */   
    XtAddCallback(combo, XmNselectionCallback, cbRadio, NULL);
    item = XmStringCreateSimple("Char");
    XmComboBoxAddItem(combo, item, 0);
    XmComboBoxSelectItem(combo, item, False);
    XmStringFree(item);

    tableCol->type = CHAR_TYPE;

    item = XmStringCreateSimple("Integer");
    XmComboBoxAddItem(combo, item, 0);
    XmStringFree(item);
    item = XmStringCreateSimple("Real");
    XmComboBoxAddItem(combo, item, 0);
    XmStringFree(item);

}

void createColLen(parent, mw, type)
Widget parent;
Widget mw;
int    type;
{
    int       len;
    XmString  item;
    Widget    rc, combo;
/*
    SetValueStruct *svs;
*/
    rc = createButtonBox(parent, "Column Length");

    combo = XtVaCreateManagedWidget(
	"COLLEN", xmComboBoxWidgetClass, rc,
	NULL);
/*
    svs = XtNew(SetValueStruct);
    svs->mw = mw;
    svs->value = 3;
    XtAddCallback(button, XmNvalueChangedCallback, cbRadioLen, (XtPointer) svs);
*/
    XtAddCallback(combo, XmNselectionCallback, cbRadioLen, NULL);

    item = XmStringCreateSimple("3");
    XmComboBoxAddItem(combo, item, 0);
    XmComboBoxSelectItem(combo, item, False);
    XmStringFree(item);

    tableCol->ColLen = (short) 3;
    item = XmStringCreateSimple("5");
    XmComboBoxAddItem(combo, item, 0);
    XmStringFree(item);
    item = XmStringCreateSimple("6");
    XmComboBoxAddItem(combo, item, 0);
    XmStringFree(item);
    item = XmStringCreateSimple("8");
    XmComboBoxAddItem(combo, item, 0);
    XmStringFree(item);
    item = XmStringCreateSimple("12");
    XmComboBoxAddItem(combo, item, 0);
    XmStringFree(item);
    item = XmStringCreateSimple("20");
    XmComboBoxAddItem(combo, item, 0);
    XmStringFree(item);

}

void createColData(top, mw, type)
Widget top;
Widget mw;
int    type;
{
    Widget cap, label, tf;
    cap = XtVaCreateManagedWidget("rc",
          xmRowColumnWidgetClass, formdlg,
          XmNtopAttachment,	XmATTACH_WIDGET,
	  XmNtopWidget,	top,
	  XmNtopOffset,	4,
	  XmNleftAttachment,	XmATTACH_FORM,
	  XmNleftOffset,	4,
	  XmNrightAttachment,	XmATTACH_FORM,
	  XmNrightOffset,	4,
	  XmNadjustLast,		True,
	  XmNorientation,	        XmHORIZONTAL,
	  /*XmNnumColumns,		2,*/
	  XmNpacking,		XmPACK_TIGHT,
	  NULL);

    if ((type == SetColumnName) || (type == AddColumn) 
         || (type == AddTailColumn)) { 
          label = XtVaCreateManagedWidget(
        	  "Label Name:" , xmLabelWidgetClass, cap,
                  NULL);

          tf = XtVaCreateManagedWidget("tf",
		  xmTextFieldWidgetClass, cap,
                  XmNcolumns, 20,
                  XmNeditable, True,
        	  NULL);

          tableCol->labelW = tf;

          XtAddCallback(tf,XmNactivateCallback,ColLabel,NULL);
    }
    
    if ((type == SetColumnData) || (type == AddColumn) 
         || (type == AddTailColumn)) { 
          label = XtVaCreateManagedWidget(
	          "Data:" , xmLabelWidgetClass, cap,
                  NULL);

          tf = XtVaCreateManagedWidget("tf",
		  xmTextFieldWidgetClass, cap,
                  XmNcolumns, 20,
                  XmNeditable, True,
        	  NULL);
     
          tableCol->dataW = tf;

          XtAddCallback(tf,XmNactivateCallback,ColData,NULL);
    
    }
}

void SetColumnLen()
{
   char      tmp[80];
   short     *widths;
   int       i; 

if (debug)
   fprintf(debugfp,"Desired Len: %d\n",tableCol->ColLen);

   widths = (short *)malloc((cMsql.rowsCount+2)*sizeof(short));

   XtVaGetValues(tableMW,
                 XmNcolumnWidths, &widths,
                 NULL);

   /* Check if shrinking */
   if (widths[hs.lastcolumn] < tableCol->ColLen) 
           widths[hs.lastcolumn] = tableCol->ColLen; 

   seekFld(hs.lastcolumn);
           
   cMsql.flist->length = tableCol->ColLen;
   cMsql.flist->type = 'C';

if (debug) {

   sprintf(tmp,"%s:C%d",cMsql.flist->fld,tableCol->ColLen);       
   fprintf(debugfp,"Producing Fieldlist %s\n",tmp);

   }

   XtVaSetValues(tableMW,
                 XmNcolumnWidths, widths,
                 NULL);

   XbaeMatrixRefresh(tableMW);

   free((short *)widths);
}

void updateColumnData()
{
   char      tmp[80];
   int       i, j;


   tableCol->ColData = XmTextFieldGetString(tableCol->dataW);

   cMsql.cells = (String **)malloc((cMsql.rowsCount+2) * 
                   (cMsql.fldsCount+2) * sizeof(String *));

   XtVaGetValues(tableMW,
                 XmNcells, &cMsql.cells,
                 NULL);
   for (i = 0; i < cMsql.rowsCount; i++) 
            cMsql.cells[i][hs.lastcolumn] = &tableCol->ColData[0];     
   
   XtVaSetValues(tableMW,
                 XmNcells, cMsql.cells,
                 NULL);
   XbaeMatrixRefresh(tableMW);

}

void okChoiceCB(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
   int       type = (int)client;

   char      tmp[80];
   char      tmpswap[80];
   int       i, j;
   short     *widths;
   String    *coldatas;
   Flist     *flist;
   
   XtDestroyWidget(formdlg);

   if (type == SetColumnWidth) {
            SetColumnLen();
            return;
   }

if (debug)
   fprintf(debugfp,"Not SetColumnLen!\n");

   if (type == SetColumnData) {
            updateColumnData();
            return;
   }

if (debug)
   fprintf(debugfp,"Not updateColumData\n");

   if (hs.lastcolumn == -1) hs.lastcolumn = 0;
   if (type == AddTailColumn) hs.lastcolumn += 1;

   tableCol->ColData  = XmTextFieldGetString(tableCol->dataW);
   tableCol->ColLabel = XmTextFieldGetString(tableCol->labelW);

if (debug)
   fprintf(debugfp,"Start do AddColumn pos: %d\n",hs.lastcolumn);

   widths = (short *)malloc((cMsql.rowsCount+1)*sizeof(short));
   coldatas = (String *)malloc((cMsql.rowsCount+1)*sizeof(String));
   
   for (i = 0; i < cMsql.rowsCount; i++) {
	    widths[i] = tableCol->ColLen;
	    coldatas[i]=(char *)malloc(sizeof(tableCol->ColData)+1);
            strcpy(coldatas[i] ,tableCol->ColData);
   }

if (debug)
   fprintf(debugfp,"Before do XbaeAddColumns\n");

   XbaeMatrixAddColumns(tableMW, hs.lastcolumn, coldatas,
          (String *)&tableCol->ColLabel, widths, NULL, NULL, NULL, NULL, 1);  

   free ((short *)widths); 
   free ((String *)coldatas);
   XbaeMatrixRefresh(tableMW);

if (debug)
   fprintf(debugfp,"After Add Column\n");

   cMsql.fldsCount = XbaeMatrixNumColumns(tableMW);
   cMsql.rowsCount = XbaeMatrixNumRows(tableMW);

if (debug)
   fprintf(debugfp,"Enter okChoiceCB2 %d\n",cMsql.fldsCount);   
		   
   if (hs.lastcolumn < (cMsql.fldsCount - 1)) seekFld(hs.lastcolumn);

   flist = (Flist *)malloc(sizeof(Flist));      
				 
   switch (tableCol->type) {
   case CHAR_TYPE : flist->type = 'C';
                    break;
   case INT_TYPE  : flist->type = 'N';
                    break; 
   case REAL_TYPE : flist->type = 'R';
                    break;
   default        : break;
   }
                   
   flist->fld = (char *)malloc(strlen(tableCol->ColLabel)+1);
   strcpy(flist->fld,tableCol->ColLabel);
   flist->length = tableCol->ColLen;
   flist->fldno  = 999;
   insertFld(cMsql.flist,flist);      

if (debug)
   fprintf(debugfp,"After Add Flds: %s(%d)\n",cMsql.flist->fld,cMsql.fldsCount);   
   rewindFlds();
   reorderFlds();
   hs.lastcolumn ++ ;
}

void cancelChoiceCB(w, client, call)
Widget w;
XtPointer client;
XtPointer call;
{
    XtDestroyWidget(formdlg);
}

void AddChoiceDlgCB(w, name, type)
Widget  w;
char    *name;
int     type;
{
    Widget rc, button;

    rc = createButtonBox(w, "Reply:");

    button = XtVaCreateManagedWidget(
	"OK", xmPushButtonWidgetClass, rc,
	NULL);
    XtAddCallback(button, XmNactivateCallback, okChoiceCB, (XtPointer)type);

    button = XtVaCreateManagedWidget(
	"Cancel", xmPushButtonWidgetClass, rc,
	NULL);
    XtAddCallback(button, XmNactivateCallback, cancelChoiceCB, NULL);
    
}


void ColChoice(type)
int type;
{
    Widget    rc, cap, tf, label;
    Arg       args[20];
    Cardinal  n;
    char      *name="ColChoice";
    XmString  item;

    tableCol = XtNew(SetColValueStruct);

    n = 0;
    XtSetArg(args[n], XmNallowResize, True); n++;

    formdlg = XmCreateFormDialog(toplevel,"Column Choice",args,n);

    rc = XtVaCreateManagedWidget(
	"rc", xmRowColumnWidgetClass, formdlg,
	XmNtopAttachment,	XmATTACH_FORM,
	XmNleftAttachment,	XmATTACH_FORM,
	XmNadjustLast,		True,
	XmNorientation,	        XmHORIZONTAL,
	XmNnumColumns,		3,
	XmNpacking,		XmPACK_TIGHT,
	NULL);

    if ((type != SetColumnWidth) && (type != SetColumnData))
            createColType(rc, tableMW, type);

    if (type != SetColumnData)
            createColLen(rc, tableMW, type);

    if (type != SetColumnWidth) {
            createColData(rc, tableMW, type);
    }
    
    AddChoiceDlgCB(rc,name,type);

                         
    XtManageChild(formdlg);    
}












