/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB

   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.	The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* The old structures from unireg */

struct st_form;
struct st_table;
class FIELD;

typedef struct st_date_format {		/* How to print date */
  uint pos[6];				/* Positions to YY.MM.DD HH:MM:SS */
} DATE_FORMAT;


union un_ref {
  ulong lastpos;
  byte refpos[MAX_REFLENGTH];		/* When long is not enough */
};

typedef struct st_keyfile_info {	/* used with ha_info() */
  union un_ref ref;			/* Position for last used record */
  uint ref_length;			/* Length of ref (4 or 6) */
  File filenr;				/* (uniq) filenr for table */
  ulong records;			/* Records i datafilen */
  ulong deleted;			/* Deleted records */
  int errkey,sortkey;			/* Last errorkey and sorted by */
  long	create_time;			/* When table was created */
  long	check_time;
  long	update_time;
  ulong mean_rec_length;		/* physical reclength */
  ulong *rec_per_key;
} KEYFILE_INFO;


typedef struct st_key_part {		/* Info about a key part */
  FIELD *field;
  uint  length;				/* Length of key_part */
  uint16 offset;			/* offset in record (from 0) */
  uint16 key_type;
  uint16 fieldnr;			/* F{ltnummer i standarformul{r */
  uint8  key_part_flag;			/* 0 or HA_REVERSE_SORT */
} KEY_PART_INFO ;


typedef struct st_key_info {
  uint	key_length;			/* Tot length of key */
  uint	dupp_key;			/* != 0 om dupp. f}r f|rekomma */
  uint	key_parts;			/* How many key_parts */
  uint  usable_key_parts;		/* Should normally be = key_parts */
  KEY_PART_INFO *key_part;
  char  *name;				/* Name of key */
} KEY;


enum reginfo_type { RI_NORMAL,RI_SYSTEM,RI_REPEAT,RI_REF,RI_CONST,RI_PROG };
enum db_type { DB_TYPE_DIAB_ISAM=1,DB_TYPE_HASH,DB_TYPE_MISAM,DB_TYPE_PISAM,
		 DB_TYPE_RMS_ISAM, DB_TYPE_HEAP, DB_TYPE_ISAM,
		 DB_TYPE_MRG_ISAM};

typedef union st_indexfield {		/* Used as indexfield to key */
  struct st_unpack {
    uint regnr;
    uint fieldnr;
  } unpack;
  FIELD *field;
} REF_FIELD;


typedef struct st_reginfo {		/* Extra info about reg */
  char	*name,*alias,
	formname[MAX_FORM_NAME];
  REF_FIELD ref_field[MAX_REF_PARTS];	/* Fields used as key */
  uint	ref_fields;
  ulong reg_used;			/* a bit set for all ref_regs */
  int	ref_key,user_key;		/* Keynr to use */
  uint	ref_length,key_length,user_keylength; /* Length of key used */
  string key_buff;			/* Senaste s|knyckel */
  int  se_err;				/* Om nyckeln byter */
  uint	update;				/* If database is being updated */
  int7 findall;				/* Om l{st f|rbi sista posten */
  int7 search_started;			/* Om vi l{st en post */
  int7 last_read_type;			/* Type of last read */
  enum reginfo_type type;		/* How to use database */
} REGINFO;

typedef struct st_form {		/* Anv{nds med formatfiler */
  byte* file;				/* File-descriptor */
  File dfile;				/* Key-file-descriptor */
  FIELD *field;				/* Pekare till f{ltbeskr. */
  byte *record[3];			/* Pekare till record */
  uint fields;				/* Antal f{lt */
  uint reclength;			/* Recordl{ngd */
  uint keys,key_parts,max_key_length;
  uint null_fields;			/* null fields */
  KEY  *key_info;			/* Data om nycklarna i databasen */
  TYPELIB keynames;			/* Pointers to keynames */
  KEYFILE_INFO keyfile_info;		/* Data om nyckelfilen */
  ulong max_records;			/* Data vid skapande av databas */
  ulong reloc;				/* Data vid skapande av databas */
  TYPELIB fieldnames;			/* Pointer to fieldnames */
  TYPELIB *intervalls;			/* pointer to intervall info */
  enum db_type db_type;			/* type of database */
  uint db_capabilities;
  uint db_create_options;		/* Create options from database */
  uint db_record_offset;		/* if HA_REC_IN_SEQ */
  uint db_stat;				/* mode of file as in handler.h */
  uint status;				/* Used by postfix.. */
  uint found;				/* If record is in memory */
  int locked;				/* Type of lock on database */
  int save_lock;			/* used by update_next_number */
  uint system;				/* Set if system record */
  uint time_stamp;			/* Set to offset+1 of record */
  uint next_number_index;
  FIELD *next_number_field,		/* Set if next_number is activated */
	*found_next_number_field,	/* Set on open */
	*timestamp_field;
  string info;				/* Beskrivning av formul{ret */
  REGINFO reginfo;			/* Registerkopplingar & extra data */
  bool	has_blob;			/* 1 if table has a blob */
} FORM;

typedef union un_str_or_double {	/* Stack for postfix-values */
  double nr;				/* Number is saved here */
  struct str_and_length {
    char str[MAX_EQV_AOSBUFF];		/* String is saved here */
    uint length;			/* Length of string */
  } str;
} STR_OR_DOUBLE;


typedef struct st_sort_field {		/* Struktur om sorteringsnycklarna */
  FIELD *field;				/* Nyckeln */
  uint	 length;			/* L{ngd av nyckel packad */
  my_bool reverse;			/* if descending sort */
  uint	 regnr;
  uint	 fieldnr;
} SORT_FIELD;

typedef struct st_formfile_info {	/* Anv{nds vid read_forminfo */
  uint8 form_type;			/* Typ av formul{r; 1-3 (pos 1) */
  uint8 forms;				/* Antal formul{rnamn i filen */
  int7	no_file_ok;			/* Intern hantering i testform */
  enum db_type db_type;			/* Ifall form_type == 1 (se handler) */
  char	ref_file[FN_REFLEN];		/* Referensfil */
  TYPELIB formnames;			/* Pointers to different formnames  */
  string ref_formname,			/* Namn f|r referensformul{r */
	 ref_info;			/* Beskrivning av referensformul{r */
  ulong records,reloc;			/* Ifall form_type == 1 */
} FORMFILE_INFO;

typedef struct st_label {		/* To handle update with labels */
  int16 flag;				/* Marker for own prog */
  uint16 label_reg,label_field,		/* As in st_update.special */
	goto_pos;			/* UPDATE index */
} LABEL;


/* det som beh|vs n{r man arbetar med selekterings-funktioner */

typedef union un_select_type {		/* Typ i f{lt- & j{mf|relse kolumnen */
  struct {				/* F{lt som skall j{mf|ras */
    int regnr;
    FIELD *regfield;
  } field;
  double nr;				/* Ifall numerisk konstant */
  string str;				/* Ifall str{ng eller formel */
} SELECT_TYPE;

typedef struct st_select_quick_region { /* save a key-region */
  uint min_flag,max_flag;
  STR_OR_DOUBLE min_arg,max_arg;
} SELECT_QUICK_REGION;

typedef struct _st_select_quick {
  FIELD		*field;			/* Field used by quick-select */
  int		index;			/* Quick-index (for quick_field) */
  int		next;			/* If in active quick */
  ulong		records;
  SELECT_QUICK_REGION *region,*pos,*end;
} SELECT_QUICK;


enum select_cmp_type {
  SEL_ALLOW_NOT_FORMULA=-2, SEL_ALLOW_ANYTHING,
  SEL_CMP_NUM, SEL_CMP_STR, SEL_CMP_BINARY_STR,SEL_CMP_WILD_STR };

enum select_field_type {
  SEL_FIELD_NOT_USED,SEL_FIELD_FIELD,SEL_FIELD_CONST_STR,SEL_FIELD_CONST_NUM,
  SEL_FIELD_FORMULA };

typedef struct st_select_row {		/* Inneh}llet i en selekteringsrad */
  uint flag;				/* Typ av j{mf|relse */
  ulong reg_used;			/* Register som anv{nds denna rad */
  enum select_cmp_type cmp_type;	/* Flag om str{ng-j{mf|relse */
  enum select_field_type field_type,	/* F{lt-typ i f{lt-kolumnen */
			 diff_type;	/* F{lt-typ i j{mf|relse-kolumnen */
  SELECT_TYPE field,diff;		/* F{lt & j{mf|relsebegrepp */
  struct st_select_row *jump;		/* next row if this is skipped */
  my_bool jump_found_brace;
} SELECT_ROW;

typedef struct st_select_stack {
  uint8 result;
  uint flag;
} SELECT_STACK;

typedef struct st_select {		/* Parameter till sel.rutinerna */
  uint	maxreg;				/* Antal register i anv{ndning */
  ulong reg_used,			/* Regs used by select */
	reg_skipped,			/* true for formula-rows with these */
	reg_init_read,			/* Reg:s with are already read */
	reg_read,			/* Regs read by select */
	used_reg_skipped,		/* if select gave ok on reg_skipped */
	const_reg,			/* These are read and dosen't change */
	neaded_reg,			/* Refs neaded in quick-select */
	quick_keys;			/* Possible quick keys */
  struct st_table **forms;		/* Databases and databases read */
  struct st_table *head;
  SELECT_ROW *row;			/* Selekteringsraderna */
  IO_CACHE file;			/* Position till valda poster */
  SELECT_QUICK	*quick;			/* If quick-select used */
  uint		max_brace_level;	/* Max '(' -levels */
  SELECT_STACK	*stack;			/* stack for recursion */
  my_bool keys_optimized;
  ulong records;			/* Antal selekterade poster vid file */
} SELECT;


struct st_read_record;				/* For referense later */

typedef struct st_read_record {			/* Parameter to read_record */
  FORM	*form;					/* Head-form */
  FORM	**forms;				/* head and ref forms */
  int (*read_record)(struct st_read_record *);
  SELECT *select;
  int key;
  uint cache_records;
  uint ref_length,struct_length,reclength;
  byte *ref_pos;				/* pointer to form->refpos */
  byte *record;
  byte	*cache,*cache_pos,*cache_end,*read_positions,*start_positions;
  IO_CACHE *io_cache;
} READ_RECORD;

typedef struct st_time {
  uint year,month,day,hour,minute,sec;
} TIME;


typedef struct st_sort_buffer {
  uint index;					/* 0 or 1 */
  uint sort_orders;
  uint change_pos;				/* If sort-fields changed */
  char **buff;
  SORT_FIELD *sortorder;
} SORT_BUFFER;

	/* Bits in form->update */
#define REG_MAKE_DUPP		1	/* Make a copy of record when read */
#define REG_NEW_RECORD		2	/* Write a new record if not found */
#define REG_UPDATE		4	/* Uppdate record */
#define REG_DELETE		8	/* Delete found record */
#define REG_PROG		16	/* User is updateing database */
#define REG_CLEAR_AFTER_WRITE	32
#define REG_MAY_BE_UPDATED	64
#define REG_AUTO_UPDATE		64	/* Used in D-forms for scroll-tables */
#define REG_OVERWRITE		128
#define REG_SKIPP_DUPP		256

	/* Bits in form->status */
#define STATUS_NO_RECORD	(1+2)	/* Record isn't usably */
#define STATUS_GARBAGE		1
#define STATUS_NOT_FOUND	2	/* No record in database when neaded */
#define STATUS_NO_PARENT	4	/* Parent record wasn't found */
#define STATUS_NOT_READ		8	/* Record isn't read */
#define STATUS_UPDATED		16	/* Record is updated by formula */
