/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB
   
   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.
   
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.  The License grants you the right to 
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* Update of records */

#include "mysql_priv.h"

int mysql_update(THD *thd,const char *table_name,List<Item> &fields,
		 List<Item> &values, COND *conds)
{
  TABLE		*table,**table_ptr;
  tname_t	table_list;
  int		error;
  SELECT	*select;
  FORM		*form;
  READ_RECORD	info;
  DBUG_ENTER("mysql_update");

  if (!(table = open_ltable(thd,table_name,&table_list)))
    DBUG_RETURN(-1);
  table_ptr= &table;
  form= &table->form;
  form->reginfo.update=1;			/* Write lock */
  if (!(thd->lock=mysql_lock_tables(thd,table_ptr,1)))
    DBUG_RETURN(-1);
  ha_info(&table->form,2);			// sync record count

  /*
  ** Find the offsets of the given fields and condition
  */

  if (setup_fields(thd,&table_list,fields,1) ||
      setup_fields(thd,&table_list,values,0) ||
      setup_conds(thd,&table_list,conds))
    DBUG_RETURN(-1);

  select=make_unireg_select(&table,1,0,0,conds,&error);
  if (error || fix_select(select,0))			/* No records */
  {
    end_select(select);
    if (error)
    {
      DBUG_RETURN(-1);				// Error in where
    }
    else
    {						// No matching records
      send_ok(&thd->net);
      DBUG_RETURN(0);
    }
  }

  VOID(ha_extra(form,HA_EXTRA_NO_READCHECK));
  init_read_record(&info,form,0,(IO_CACHE *) 0,select);

  ulong updated=0L;
  while ((error=info.read_record(&info)) <= 0 && !abort_loop)
  {
    if (error == 0 && skipp_record(select) == 0)
    {
      store_record(form,1);
      if (fill_record(fields,values))
	break;
      if (cmp_record(form,1))
      {
	if (!(error=ha_update(form,form->record[1],form->record[0])))
	  updated++;
	else
	{
	  ha_error(form,error,MYF(0));
	  error= 0;
	  break;
	}
      }
    }
  }
  end_read_record(&info);
  VOID(ha_extra(form,HA_EXTRA_READCHECK));
  mysql_unlock_tables(thd->lock); thd->lock=0;
  end_select(select);
  if (error <= 0)
      send_error(&thd->net,abort_loop ? ER(ER_SERVER_SHUTDOWN) : NullS);
  else
    send_ok(&thd->net,updated);
  DBUG_RETURN(0);
}
