/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB
   
   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.
   
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.  The License grants you the right to 
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* create and drop of databases */

#include "mysql_priv.h"
#include <my_dir.h>

void mysql_createDB(THD *thd,char *db)
{
  char	 path[FN_REFLEN];
  MY_DIR *dirp;
  DBUG_ENTER("mysql_createDB");

  if (!stripp_sp(db))
  {
    send_error(&thd->net,ER(ER_NO_DB_ERROR));
    DBUG_VOID_RETURN;
  }
  VOID(pthread_mutex_lock(&LOCK_mysql_createDB));

  /* Check directory */
  (void)sprintf(path,"%s/%s", mysql_data_home, db);
  if ((dirp = my_dir(path,MYF(MY_DONT_SORT))))
  {
    my_dirend(dirp);
    net_printf(&thd->net,ER(ER_DB_CREATE_EXISTS),db);
    goto exit;
  }

  /* Create the directory */
  if (mkdir(path,0700) < 0)
  {
    net_printf(&thd->net,ER(ER_CANT_CREATE_DB),db,my_errno);
    goto exit;
  }
  send_ok(&thd->net);

exit:
  VOID(pthread_mutex_unlock(&LOCK_mysql_createDB));
  DBUG_VOID_RETURN;
}


void mysql_rm_db(THD *thd,char *db)
{
  uint index;
  char	path[FN_REFLEN],filePath[FN_REFLEN];
  MY_DIR *dirp;
  FILEINFO *file;
  ulong deleted=0;
  DBUG_ENTER("mysql_rm_db");

  if (!stripp_sp(db))
  {
    send_error(&thd->net,ER(ER_NO_DB_ERROR));
    DBUG_VOID_RETURN;
  }

  VOID(pthread_mutex_lock(&LOCK_mysql_createDB));
  VOID(pthread_mutex_lock(&LOCK_open));

  /* See if the directory exists */
  (void) sprintf(path,"%s/%s",mysql_data_home,db);
  if (!(dirp = my_dir(path,MYF(MY_WME | MY_DONT_SORT))))
  {
    net_printf(&thd->net,ER(ER_DB_DROP_EXISTS),db);
    goto exit;
  }

  remove_db_from_cache(db);

  /* remove all files except . and .. */

  for (index=2 ;
       index < (uint) dirp->number_off_files && !abort_loop ;
       index++)
  {
    file=dirp->dir_entry+index;
    sprintf(filePath,"%s/%s",path,file->name);
    if (my_delete(filePath,MYF(MY_WME)))
    {
      net_printf(&thd->net,ER(ER_DB_DROP_DELETE),filePath,my_error);
      my_dirend(dirp);
      goto exit;
    }
    deleted++;
  }

  my_dirend(dirp);
  if (!abort_loop && rmdir(path) < 0)
  {
    net_printf(&thd->net,ER(ER_DB_DROP_RMDIR), path,my_error);
    goto exit;
  }
  if (abort_loop)
    send_error(&thd->net,ER(ER_SERVER_SHUTDOWN));
  else
    send_ok(&thd->net,deleted);
exit:
  VOID(pthread_mutex_unlock(&LOCK_open));
  VOID(pthread_mutex_unlock(&LOCK_mysql_createDB));
  DBUG_VOID_RETURN;
}
