/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB
   
   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.
   
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.  The License grants you the right to 
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

#include "mysql_priv.h"
#include <stdarg.h>

static const head_length=4;
#define MAX_MESSAGE_SIZE 160

	/* Send a error string to client */

void send_error(NET *net,char *err)
{
  uint length;
  DBUG_ENTER("send_error");
  VOID(net_flush(net));
  if (!err && !(err=net->last_error)[0])
    err="Unknown error";
  length=strlen(err);
  VOID(net_write_command(net,(uchar) 255,err,
			 min(length,sizeof(net->last_error)-1)));
  DBUG_VOID_RETURN;
}

/**
** write error package and flush to client
** It's a little too low level, but I don't want to allow another buffer
*/
/* VARARGS3 */

void
net_printf(NET *net,const string format,...)
{
  va_list args;
  uint length;
  va_start(args,format);
  VOID(net_flush(net));
  (void) vsprintf((char*) net->buff+head_length+1,format,args);
  length=strlen((char*) net->buff+head_length+1)+1;
  if (length >= sizeof(net->last_error))
    length=sizeof(net->last_error)-1;
  va_end(args);

  int3store(net->buff,length);
  net->buff[3]=(uchar) (net->pkt_nr++);
  net->buff[4]=(uchar) 255;			/* Error package */
  VOID(net_real_write(net,(byte*) net->buff,length+5));
}


void
send_ok(NET *net,ulong affected_rows,ulong id,char *message)
{
  byte buff[MAX_MESSAGE_SIZE+10],*pos;
  DBUG_ENTER("send_ok");
  buff[0]=0;					// No fields
  pos=net_store_length(buff+1,affected_rows);
  pos=net_store_length(pos,id);
  if (message)
    pos=net_store_data(pos,message);
  VOID(net_write(net,buff,(uint) (pos-buff)));
  VOID(net_flush(net));
  DBUG_VOID_RETURN;
}

void
send_eof(NET *net)
{
  byte buff[1];
  DBUG_ENTER("send_eof");
  buff[0]=(char) 254;				/* Marker for end of fields */
  VOID(net_write(net,buff,1));
  VOID(net_flush(net));
  DBUG_VOID_RETURN;
}


/****************************************************************************
** Store a field length in logical packet
****************************************************************************/

byte *
net_store_length(byte *pkg,ulong length)
{
  uchar *packet=(uchar*) pkg;
  if (length < 251L)
  {
    *packet=(uchar) length;
    return (byte*) packet+1;
  }
  if (length == NULL_LENGTH)
  {
    *packet= (uchar) 251;
    return (byte*) packet+1;
  }
  if (length < 65536L)
  {
    *packet++=252;
    int2store(packet,(uint) length);
    return (byte*) packet+2;
  }
  if (length < (65536L*256))
  {
    *packet++=253;
    int3store(packet,(uint) length);
    return (byte*) packet+3;
  }
  *packet++=254;
  int4store(packet,(uint) length);
  return (byte*) packet+4;
}


byte *
net_store_data(byte *to,const char *from,uint length)
{
  to=net_store_length(to,(ulong) length);
  memcpy(to,from,length);
  return to+length;
}

byte *
net_store_data(byte *to,const char *from)
{
  uint length=strlen(from);
  to=net_store_length(to,(ulong) length);
  memcpy(to,from,length);
  return to+length;
}
