/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB

   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.

   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.	The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* classes for sum functions */
#pragma interface

class Item_sum :public Item_result_field
{
  virtual void fix_length_and_dec()=0;
public:
  enum Sumfunctype {COUNT_FUNC,SUM_FUNC,AVG_FUNC,MIN_FUNC,MAX_FUNC,
		    MIN_STR_FUNC,MAX_STR_FUNC,INT_FUNC,UNIQUE_USERS_FUNC};
  Item *item;
  bool quick_group;

  Item_sum(Item *item_par) :item(item_par),quick_group(1) {}
  ~Item_sum() { delete item; result_field=0;}
  enum Type type() const { return SUM_FUNC_ITEM; }
  virtual enum Sumfunctype sum_func () const=0;
  virtual void reset()=0;
  virtual void add()=0;
  virtual void reset_field()=0;
  virtual void update_field(int offset)=0;
};


class Item_sum_num :public Item_sum
{
  void fix_length_and_dec();
public:
  Item_sum_num(Item *item_par) :Item_sum(item_par) {}
  FIELD *make_field(FIELD *field);
  bool fix_fields(THD *,struct tlist_s *,const string);
  String *str(String*str);
  void reset_field();
};


class Item_sum_str :public Item_sum
{
  void fix_length_and_dec();
protected:
  String value,tmp_value;
public:
  enum Item_result result_type () const { return STRING_RESULT; }
  Item_sum_str(Item *item_par) :Item_sum(item_par) {}
  FIELD *make_field(FIELD *field);
  bool fix_fields(THD *,struct tlist_s *,const string);
  double val();
  void reset_field();
  void min_max_update_field(int offset,int sign);
};


class Item_sum_sum :public Item_sum_num
{
  double sum;
  void fix_length_and_dec();

  public:
  Item_sum_sum(Item *item_par) :Item_sum_num(item_par) {}
  enum Sumfunctype sum_func () const {return SUM_FUNC;}
  void reset();
  void add();
  double val();
  void reset_field();
  void update_field(int offset);
};


class Item_sum_count :public Item_sum_num
{
  ulong count;
  void fix_length_and_dec();

  public:
  Item_sum_count(Item *item_par) :Item_sum_num(item_par) {}
  enum Sumfunctype sum_func () const {return COUNT_FUNC;}
  void reset();
  void add();
  double val();
  void reset_field();
  void update_field(int offset);
};


class Item_sum_avg :public Item_sum_num
{
  void fix_length_and_dec();
  double sum;
  ulong count;

  public:
  Item_sum_avg(Item *item_par) :Item_sum_num(item_par) {}
  enum Sumfunctype sum_func () const {return AVG_FUNC;}
  void reset();
  void add();
  double val();
  void reset_field();
  void update_field(int offset);
};


class Item_sum_min :public Item_sum_num
{
  double sum;

  public:
  Item_sum_min(Item *item_par) :Item_sum_num(item_par) {}
  enum Sumfunctype sum_func () const {return MIN_FUNC;}

  void reset();
  void add();
  double val();
  void update_field(int offset);
};


class Item_sum_max :public Item_sum_num
{
  double sum;

  public:
  Item_sum_max(Item *item_par) :Item_sum_num(item_par) {}
  enum Sumfunctype sum_func () const {return MAX_FUNC;}

  void reset();
  void add();
  double val();
  void update_field(int offset);
};


class Item_sum_min_str :public Item_sum_str
{
  public:
  Item_sum_min_str(Item *item_par,char *name_par) :Item_sum_str(item_par)
  { max_length=item_par->max_length ; this->name=name_par; }
  enum Sumfunctype sum_func () const {return MIN_STR_FUNC;}

  void reset();
  void add();
  String *str(String *);
  void update_field(int offset);
};


class Item_sum_max_str :public Item_sum_str
{
  public:
  Item_sum_max_str(Item *item_par,char *name_par) :Item_sum_str(item_par)
  { max_length=item_par->max_length ; this->name=name_par; }
  enum Sumfunctype sum_func () const {return MAX_STR_FUNC;}

  void reset();
  void add();
  String *str(String *);
  void update_field(int offset);
};
