/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB
   
   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.
   
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.  The License grants you the right to 
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* Sum functions (COUNT, MIN...) */

#pragma implementation

#include "mysql_priv.h"

/*
** Implementation of sum functions
*/

String *
Item_sum_num::str(String *str)
{
  double nr=val();
  if (null_value)
    return 0;
  str->set(nr,decimals);
  return str;
}

bool
Item_sum_num::fix_fields(THD *thd,tname_t *tables,const string where)
{
  if (item->fix_fields(thd,tables,where))
    return 1;
  decimals=item->decimals;
  result_field=0;
  max_length=float_length(decimals);
  maybe_null=item->maybe_null;
  fix_length_and_dec();
  return 0;
}

void Item_sum_num::fix_length_and_dec()
{
}

FIELD *Item_sum_num::make_field(FIELD *tmp_field)
{
  tmp_field->table_name="";
  tmp_field->field_name=name;
  tmp_field->flags=0;
  if (!maybe_null)
    tmp_field->flags|= NOT_NULL_FLAG;
  tmp_field->length=max_length;
  tmp_field->decimals=decimals;
  tmp_field->type=FIELD_TYPE_DOUBLE;
  return tmp_field;
}


double Item_sum_str::val()
{
  return 0.0;					// Never called
}


bool Item_sum_str::fix_fields(THD *thd,tname_t *tables,const string where)
{
  if (item->fix_fields(thd,tables,where))
    return 1;
  decimals=0;
  result_field=0;
  max_length=item->max_length;
  maybe_null=item->maybe_null;
  fix_length_and_dec();
  return 0;
}


void Item_sum_str::fix_length_and_dec()
{
}


/*
** This is assumes that a string sum function dosen't result a bigger
** result than the field argument
*/

FIELD *Item_sum_str::make_field(FIELD *tmp_field)
{
  tmp_field->table_name="";
  tmp_field->field_name=name;
  tmp_field->flags=0;
  if (!maybe_null)
    tmp_field->flags|= NOT_NULL_FLAG;
  tmp_field->length=max_length;
  tmp_field->decimals=decimals;
  if (item->type() == Item::FIELD_ITEM)
    return ((Item_field*) item)->field;
  return tmp_field;
}


/***********************************************************************
** reset and add of sum_func
***********************************************************************/

void Item_sum_sum::reset()
{
  sum=item->val();
}

void Item_sum_sum::add()
{
  sum+=item->val();
}

double Item_sum_sum::val()
{
  return sum;
}

void Item_sum_sum::fix_length_and_dec()
{
  maybe_null=0;
}


void Item_sum_count::reset()
{
  count=0; add();
}

void Item_sum_count::add()
{
  if (!item->maybe_null)
    count++;
  else
  {
    (void) item->val();
    if (!item->null_value)
      count++;
  }
}

double Item_sum_count::val()
{
  return count;
}

void Item_sum_count::fix_length_and_dec()
{
  decimals=0;
  max_length=11;
  maybe_null=0;
}


void Item_sum_avg::reset()
{
  sum=0.0; count=0; Item_sum_avg::add();
}

void Item_sum_avg::add()
{
  double nr=item->val();
  if (!item->null_value)
  {
    sum+=nr;
    count++;
  }
}

double Item_sum_avg::val()
{
  if (!count)
  {
    null_value=1;
    return 0.0;
  }
  null_value=0;
  return sum/(double) count;
}

void Item_sum_avg::fix_length_and_dec()
{
  decimals+=4;
  maybe_null=1;
}


void Item_sum_min::reset()
{
  sum=0.0; null_value=1; Item_sum_min::add();
}


void Item_sum_min::add()
{
  double nr=item->val();
  if (!item->null_value && (null_value || nr < sum))
  {
    sum=nr;
    null_value=0;
  }
}

double Item_sum_min::val()
{
  return sum;
}


void Item_sum_max::reset()
{
  sum=0.0; null_value=1; Item_sum_max::add();
}


void Item_sum_max::add()
{
  double nr=item->val();
  if (!item->null_value && (null_value || nr > sum))
  {
    sum=nr;
    null_value=0;
  }
}

double Item_sum_max::val()
{
  return sum;
}


void Item_sum_min_str::reset()
{
  value.length(0); null_value=1; Item_sum_min_str::add();
}


void Item_sum_min_str::add()
{
  String *result=item->str(&tmp_value);
  if (!item->null_value && (null_value || sortcmp(value,*result) > 0))
  {
    value.copy(*result);
    null_value=0;
  }
}

/* ARGSUSED */
String *Item_sum_min_str::str(String *str)
{
  return &value;
}

void Item_sum_max_str::reset()
{
  value.length(0); null_value=1; Item_sum_max_str::add();
}


void Item_sum_max_str::add()
{
  String *result=item->str(&tmp_value);

  if (!item->null_value && (null_value || sortcmp(value,*result) < 0))
  {
    value.copy(*result);
    null_value=0;
  }
}

/* ARGSUSED */
String *Item_sum_max_str::str(String *str)
{
  return &value;
}


/************************************************************************
** reset result of a Item_sum with is saved in a tmp_table
*************************************************************************/

void Item_sum_num::reset_field()
{
  double nr=item->val();
  char *res=result_field->str;

  if (maybe_null)
  {
    if (item->null_value)
    {
      nr=0.0;
      mark_as_null(result_field);
    }
    else
      mark_as_not_null(result_field);
  }
  memcpy(res,(char*) &nr,sizeof(double));
}


void Item_sum_str::reset_field()
{
  char buff[MAX_FIELD_WIDTH];
  String tmp(buff,sizeof(buff)),*res;

  res=item->str(&tmp);
  if (item->null_value)
  {
    mark_as_null(result_field);
    f_fieldinit(result_field->str,result_field->pack_flag,result_field->length);
  }
  else
  {
    if (maybe_null)
      mark_as_not_null(result_field);
    store_string(*res,result_field);
  }
}


void Item_sum_sum::reset_field()
{
  double nr=item->val();			// Nulls also return 0
  char *pos=result_field->str;
  memcpy(pos,(char*) &nr,sizeof(double));
}


void Item_sum_count::reset_field()
{
  char *res=result_field->str;
  ulong nr=0;

  if (!item->maybe_null)
    nr=1;
  else
  {
    (void) item->val();
    if (!item->null_value)
      nr=1;
  }
  longstore(res,nr);
}


void Item_sum_avg::reset_field()
{
  double nr=item->val();
  char *res=result_field->str;

  if (item->null_value)
    bzero(res,sizeof(double)+sizeof(long));
  else
  {
    doublestore(res,nr);
    longstore(res+sizeof(double),1);
  }
}


/*
** calc next value and merge it with field_value
*/

void Item_sum_sum::update_field(int offset)
{
  double old_nr,nr;
  char *res=result_field->str;

  doubleget(old_nr,res+offset);
  nr=item->val();
  if (!item->null_value)
    old_nr+=nr;
  doublestore(res,old_nr);
}


void Item_sum_count::update_field(int offset)
{
  ulong nr;
  char *res=result_field->str;

  ulongget(nr,res+offset);
  if (!item->maybe_null)
    nr++;
  else
  {
    (void) item->val();
    if (!item->null_value)
      nr++;
  }
  longstore(res,nr);
}


void Item_sum_avg::update_field(int offset)
{
  double nr,old_nr;
  ulong field_count;
  char *res=result_field->str;

  doubleget(old_nr,res+offset);
  ulongget(field_count,res+offset+sizeof(double));

  nr=item->val();
  if (!item->null_value)
  {
    old_nr+=nr;
    field_count++;
  }
  doublestore(res,old_nr);
  longstore(res+sizeof(double),field_count);
}


void Item_sum_min::update_field(int offset)
{
  double nr,old_nr;
  char *res=result_field->str;

  doubleget(old_nr,res+offset);
  nr=item->val();
  if (!item->null_value)
  {
    if (old_nr > nr ||
	(maybe_null && test_if_null_offset(result_field,offset)))
      old_nr=nr;
    if (maybe_null)
      mark_as_not_null(result_field);
  }
  else if (maybe_null && test_if_null_offset(result_field,offset))
    mark_as_null(result_field);
  doublestore(res,old_nr);
}


void Item_sum_max::update_field(int offset)
{
  double nr,old_nr;
  char *res=result_field->str;

  doubleget(old_nr,res+offset);
  nr=item->val();
  if (!item->null_value)
  {
    if (old_nr < nr ||
	(maybe_null && test_if_null_offset(result_field,offset)))
      old_nr=nr;
    if (maybe_null)
      mark_as_not_null(result_field);
  }
  else if (maybe_null && test_if_null_offset(result_field,offset))
    mark_as_null(result_field);
  doublestore(res,old_nr);
}


void
Item_sum_str::min_max_update_field(int offset,int sign)
{
  String *res_str=item->str(&value);

  if (item->null_value)
    copy_field_from_tmp_record(result_field,offset); // Use old value
  else
  {
    result_field->str+=offset;
    String *field_str=field_to_string(tmp_value,result_field);
    result_field->str-=offset;

    res_str->strip_sp();
    if (sign * sortcmp(*res_str,*field_str) < 0 ||
	(result_field->null_pos && test_if_null_offset(result_field,offset)))
      store_string(*res_str,result_field);
    else
    {
      char *res=result_field->str;
      memcpy(res,res+offset,result_field->packlength);	// Old is better
    }
    if (result_field->null_pos)
      mark_as_not_null(result_field);		// Can't be null anymore
  }
}


void
Item_sum_min_str::update_field(int offset)
{
  min_max_update_field(offset,1);
}

void
Item_sum_max_str::update_field(int offset)
{
  min_max_update_field(offset,-1);
}
