/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB

   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.	The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */


#pragma interface

class Item;

class FIELD :public Sql_alloc {
public:
  uint16	pack_flag;		/* flag for field-packing */
  uint8		unireg_type;		/* Type of field */
  uint8		null_bit;
  char		*str;			/* Position to field in record */
  TYPELIB	*intervall;		/* Which intervall to use */
  uchar		*null_pos;		/* Byte where null_bit is */
  struct 	st_table *table;	/* Pointer for table */
  char		*table_name,*field_name;
  enum	 	enum_field_types type;	/* Sql type */
  ulong  	query_id;		/* For quick test of used fields */
  ulong 	key_parts;		/* Which keys a field is in  */
  uint	 	length,decimals,packlength,flags;
  FIELD() {}
};


class create_field :public Sql_alloc {
public:
  char  *field_name;
  char	*change;				/* If done with alter table */
  Item	*def;					/* Default value */
  enum	enum_field_types type;			/* Sql type */  
  uint length,decimals,flags,unireg_type;
  TYPELIB *intervall;				/* Which intervall to use */
  FIELD *field;					/* For alter table */
  uint8 row,col,sc_length;			/* For rea_create_table */
  uint  offset,pack_flag;
  create_field() {}
  create_field(FIELD *field);
};


	/* The following defines is used with reg-form-input-handler */

#define MTYP_TYPENR(type) (type & 127)	/* Remove bits from type */

#define MTYP_DATE 1
#define MTYP_SKYDD 2
#define MTYP_NOEMPTY 3
#define MTYP_CASEUP 4
#define MTYP_PNR 5
#define MTYP_BGNR 6
#define MTYP_PGNR 7
#define MTYP_JA 8
#define MTYP_NEJ 9
#define MTYP_REL 10
#define MTYP_CHECK 11
#define MTYP_TOM 12
#define MTYP_CASEDN 14
#define MTYP_NEXT_NUMBER 15
#define MTYP_INTERVALL	16
#define MTYP_BITFIELD	17
#define MTYP_TIMESTAMP	18
#define MTYP_CAPITALIZE 19
#define MTYP_BLOB	20

#define MTYP_NOEMPTY_BIT 128


	/* The following are for using with inputflag */

#define FIELDFLAG_DECIMAL		1
#define FIELDFLAG_BINARY		1	/* Shares same flag */
#define FIELDFLAG_NUMBER		2
#define FIELDFLAG_ZEROFILL		4
#define FIELDFLAG_PACK			120	/* Bits used for packing */
#define FIELDFLAG_OLD_RESET		64	/* Reset on old frm */
#define FIELDFLAG_INTERVALL		256
#define FIELDFLAG_BITFIELD		512	/* mangled with dec! */
#define FIELDFLAG_BLOB			1024	/* mangled with dec! */
#define FIELDFLAG_LEFT_FULLSCREEN	8192
#define FIELDFLAG_RIGHT_FULLSCREEN	16384
#define FIELDFLAG_FORMAT_NUMBER		16384	/* predit: ###,,## in output */
#define FIELDFLAG_SUM			((uint) 32768)/* predit: +#fieldflag */
#define FIELDFLAG_MAYBE_NULL		((uint) 32768)/* sql */
#define FIELDFLAG_PACK_SHIFT		3
#define FIELDFLAG_DEC_SHIFT		8
#define FIELDFLAG_MAX_DEC		31
#define FIELDFLAG_NUM_SCREEN_TYPE	0x7F01
#define FIELDFLAG_ALFA_SCREEN_TYPE	0x7800

#define FIELD_SORT_REVERSE		16384

#define f_is_dec(x)		((x) & FIELDFLAG_DECIMAL)
#define f_is_num(x)		((x) & FIELDFLAG_NUMBER)
#define f_is_zerofill(x)	((x) & FIELDFLAG_ZEROFILL)
#define f_is_packed(x)		((x) & FIELDFLAG_PACK)
#define f_packtype(x)		(((x) >> FIELDFLAG_PACK_SHIFT) & 15)
#define f_decimals(x)		(((x) >> FIELDFLAG_DEC_SHIFT) & FIELDFLAG_MAX_DEC)
#define f_is_alpha(x)		(!f_is_num(x))
#define f_is_binary(x)		((x) & FIELDFLAG_BINARY)
#define f_is_intervall(x)	((x) & FIELDFLAG_INTERVALL)
#define f_is_bitfield(x)	((x) & FIELDFLAG_BITFIELD)
#define f_is_blob(x)		(((x) & (FIELDFLAG_BLOB | FIELDFLAG_NUMBER)) == FIELDFLAG_BLOB)
#define f_is_equ(x)		((x) & (1+2+FIELDFLAG_PACK+31*256))
#define f_settype(x)		(((int) x) << FIELDFLAG_PACK_SHIFT)
#define f_maybe_null(x)		(x & FIELDFLAG_MAYBE_NULL)

#define SC_INFO_LENGTH 4			/* Form format constant */
#define TE_INFO_LENGTH 3
