/* Copyright (C) 1979-1997 TcX AB & Monty Program KB & Detron HB

   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.

   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.	The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */


/*****************************************************************************
**
** This file implements classes defined in field.h
**
*****************************************************************************/


#pragma implementation				// gcc: implement sql_class.h

#include "mysql_priv.h"

/*****************************************************************************
** Instansiate templates
*****************************************************************************/

#ifdef __GNUC__
template class List<create_field>;
template class List_iterator<create_field>;
#endif


/*****************************************************************************
** Handling of field and create_field
*****************************************************************************/

create_field::create_field(FIELD *old_field)
{
  field=     old_field;
  field_name=change=old_field->field_name;
  length=    old_field->length;
  decimals=  old_field->decimals;
  flags=     old_field->flags;
  unireg_type=old_field->unireg_type;
  intervall= old_field->intervall;
  if (field->flags & BLOB_FLAG)
    type = (enum enum_field_types) f_packtype(field->pack_flag);
  else
    type= old_field->type;
  if (field && (flags & NOT_NULL_FLAG) && ! (flags & BLOB_FLAG) &&
      old_field->type != FIELD_TYPE_TIMESTAMP)
  {
    char buff[MAX_FIELD_WIDTH],*tmp;
    uint length=r_unpackf_stripp(field,buff);
    tmp=sql_memdup(buff,length+1);
    def=new Item_string(tmp,length);
  }
  else
    def=0;
};

