/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB
   
   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.  The License grants you the right to 
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* Diverse funktioner som anv{nds allt som oftast i datanet */

#include "mysql_priv.h"
#include <m_ctype.h>
#include <errno.h>

	/* Functions defined in this file */

static int read_string(File file, gptr *to, uint length);
static void fix_type_pointers(string **array, TYPELIB *point_to_type,
			      uint types, string *names);
static int find_str_type(string x, string typelib, char separator,
			 bool full_name);

	/* Open a .frm file */

int openfrm(string name, string formname, uint db_stat, uint prgflag,
	    FORM *outparam)
{
  reg1 uint i;
  reg2 uchar *strpos;
  int	 j,error,flag,funktpos,skr;
  uint	 rec_buff_length,n_length,int_length,records,key_parts,keys,dlength,
	 length,a_length,new_field_pack_flag,intervall_count,intervall_parts;
  ulong  pos;
  char	 index_file[FN_REFLEN],*names;
  uchar  head[288],*disk_buff;
  string record,keynames,*int_array;
  bool	 new_frm_ver;
  File	 file;
  FIELD  *field;
  KEY	 *keyinfo;
  KEY_PART_INFO *key_part;
  DBUG_ENTER("openfrm");
  DBUG_PRINT("enter",("name: '%s'  formname: '%s'  form: %lx",name,formname,
		      outparam));

  /* Empty struct except of REGINFO */

  bzero((byte*) outparam,sizeof(*outparam));
  disk_buff=NULL; record= NULL; keynames=NullS;
  outparam->db_stat = db_stat;
  funktpos=0; key_parts=0;

  VOID(strmov(outparam->reginfo.formname,formname));
  flag= (prgflag & CHANGE_FRM) ? O_RDWR : O_RDONLY | O_SHARE;
  if ((file=my_open(fn_format(index_file,name,"",reg_ext,4),flag,
		    MYF(0)))
      < 0)
  {
    error=1;
    goto err_end;
  }
  error=4;
  if (my_read(file,(char*) head,64,MYF(MY_NABP))) goto err;
  if (head[0] != (uchar) 254 || head[1] != 1 ||
      (head[2] != FRM_VER && head[2] != FRM_VER+1))
    goto err;
  new_field_pack_flag=head[27];
  new_frm_ver= (head[2] == FRM_VER+1);

	/* Save name in struct */
  dlength=dirname_length(index_file);
  length=strlen(index_file);
  a_length= length-dlength-strlen(fn_ext(index_file+dlength));

  error=7;
  if (!(outparam->reginfo.name=my_strdup(index_file,MYF(MY_WME))))
    goto err;

  error=3;
  if (!(pos=get_form_pos(file,head,formname,
			 (((specialflag & SPECIAL_SAME_DB_NAME) ||
			   a_length > MAXREGNAME) ? NullS :
			  index_file+dlength),
			 (TYPELIB*) 0)))
    goto err;
  if ((specialflag & SPECIAL_SAME_DB_NAME) ||
      a_length > MAXREGNAME)
    *fn_ext(index_file)='\0';			/* Remove extension */

  outparam->db_type=ha_checktype((enum db_type) (uint) *(head+3));
  outparam->db_create_options=uint2korr(head+30);
  outparam->db_record_offset=1;
  keys=0;

  error=4;
  if (prgflag & (READ_ALL+READ_KEYINFO))
  {
    outparam->max_records=uint4korr(head+18);
    outparam->reloc=uint4korr(head+22);

    VOID(my_seek(file,(ulong) uint2korr(head+6),MY_SEEK_SET,MYF(0)));
    if (read_string(file,(gptr*) &disk_buff,(uint) uint2korr(head+28)))
      goto err;
    outparam->keys=keys=disk_buff[0];
    key_parts=disk_buff[1];
    n_length=keys*sizeof(KEY)+key_parts*sizeof(KEY_PART_INFO);
    if (!(keyinfo = (KEY*)
	  my_malloc(n_length+uint2korr(disk_buff+4),MYF(MY_WME))))
      goto err;
    bzero((gptr) keyinfo,n_length);
    outparam->key_info=keyinfo;
    outparam->max_key_length=0;
    key_part= (KEY_PART_INFO*) (keyinfo+keys);
    strpos=disk_buff+6;
    for (i=0 ; i < keys ; i++, keyinfo++)
    {
      keyinfo->dupp_key=   (uint) strpos[0];
      keyinfo->key_length= (uint) uint2korr(strpos+1);
      keyinfo->key_parts=  (uint) strpos[3];  strpos+=4;
      keyinfo->key_part=   key_part;
      set_if_bigger(outparam->max_key_length,keyinfo->key_length);
      for (j=keyinfo->key_parts ; j-- ; key_part++)
      {
	key_part->fieldnr=	(uint16) uint2korr(strpos);
	key_part->offset=	(uint) uint2korr(strpos+2)-1;
	key_part->key_type=	(uint) uint2korr(strpos+5);
	key_part->field=	(FIELD*) 0;	// Will be fixed laiter
	if (new_frm_ver)
	{
	  key_part->key_part_flag=	*(strpos+4);
	  key_part->length=	(uint) uint2korr(strpos+7);
	  strpos+=9;
	}
	else
	{
	  key_part->length=	*(strpos+4);
	  key_part->key_part_flag=0;
	  if (key_part->length > 128)
	  {
	    key_part->length&=127;
	    key_part->key_part_flag=HA_REVERSE_SORT;
	  }
	  strpos+=7;
	}
      }
    }
    VOID(strmov(keynames= (string) key_part,(string) strpos));
  }
  outparam->reclength = uint2korr((head+16));
  if (*(head+26))
    outparam->system=1;				/* one-record-database */

  error=2;
  if ((ha_open(outparam,index_file,
	       (db_stat & HA_READ_ONLY ? O_RDONLY : O_RDWR),
	       (db_stat & HA_WAIT_IF_LOCKED ||
		specialflag & SPECIAL_WAIT_IF_LOCKED ?
		HA_OPEN_WAIT_IF_LOCKED :
		(db_stat & (HA_ABORT_IF_LOCKED | HA_GET_INFO)) ?
		HA_OPEN_ABORT_IF_LOCKED : HA_OPEN_IGNORE_IF_LOCKED))))
    goto err;
  error=4; funktpos=1;
  outparam->reginfo.update= (outparam->db_stat & HA_READ_ONLY ||
			     db_stat & HA_READ_ONLY) ? 0 : REG_MAKE_DUPP;

  if (db_stat & HA_OPEN_KEYFILE || prgflag  & DELAYED_OPEN) records=2;
  else records=1;
  if (prgflag & (READ_ALL+EXTRA_RECORD)) records++;
  rec_buff_length=ALIGN_SIZE(outparam->reclength);
  if (!(outparam->record[0]= record =
	(char *) my_malloc(rec_buff_length * records,MYF(MY_WME))))
    goto err;

  if (my_pread(file,record,(uint) outparam->reclength,
	       (ulong) (uint2korr(head+6)+uint2korr(head+14)),
	       MYF(MY_NABP)))
    goto err;

  for (i=0 ; i < records ; i++, record+=rec_buff_length)
  {
    outparam->record[i]=record;
    if (i)
      memcpy(record,record-rec_buff_length,(uint) outparam->reclength);
  }

  if (records == 2)
  {						/* fix for select */
    outparam->record[2]=outparam->record[1];
    if (db_stat & HA_READ_ONLY)
      outparam->record[1]=outparam->record[0];
  }

  VOID(my_seek(file,pos,MY_SEEK_SET,MYF(0)));
  if (my_read(file,(char*) head,288,MYF(MY_NABP))) goto err;
  outparam->fields= uint2korr(head+258);
  pos=uint2korr(head+260);			/* Length of all screens */
  n_length=uint2korr(head+268);
  intervall_count=uint2korr(head+270);
  intervall_parts=uint2korr(head+272);
  int_length=uint2korr(head+274);
  outparam->time_stamp=uint2korr(head+276);
  VOID(my_seek(file,pos,MY_SEEK_CUR,MYF(0)));

  DBUG_PRINT("form",("i_count: %d  i_parts: %d  index: %d  n_length: %d  int_length: %d", intervall_count,intervall_parts, outparam->keys,n_length,int_length));
  if (!(outparam->field = field =
	(FIELD*) my_malloc((uint) (outparam->fields*sizeof(FIELD)+
				   intervall_count*sizeof(TYPELIB)+
				   (outparam->fields+intervall_parts+
				    keys+3)*sizeof(string)+
				   (n_length+int_length)),MYF(MY_WME))))
    goto err;

  if (read_string(file,(gptr*) &disk_buff,(uint) (outparam->fields*11)))
    goto err;

  outparam->intervalls= (TYPELIB*) (outparam->field+outparam->fields);
  int_array= (string*) (outparam->intervalls+intervall_count);
  names= (char*) (int_array+outparam->fields+intervall_parts+keys+3);
  if (my_read(file, names, (uint) (n_length+int_length),MYF(MY_NABP)))
    goto err;

  fix_type_pointers(&int_array,&outparam->fieldnames,1,&names);
  outparam->fieldnames.name=outparam->reginfo.name; /* Save for input */
  fix_type_pointers(&int_array,outparam->intervalls,intervall_count,
		    &names);
  if (keynames)
    fix_type_pointers(&int_array,&outparam->keynames,1,&keynames);

  if (db_stat || !(prgflag & CHANGE_FRM)) VOID(my_close(file,MYF(MY_WME)));
  else outparam->dfile= file;

  strpos= disk_buff;
  record=outparam->record[0]-1;			/* Fieldstart = 1 */
  bzero((gptr) field,sizeof(field[0])*outparam->fields); /* For purify */
  for (i=0 ; i < outparam->fields; i++, strpos+= 11, field++)
  {
    uint tmp;
    field->length=	strpos[3];
    field->str =	record+uint2korr(strpos+4);
    field->pack_flag =	uint2korr(strpos+6);
    if (!new_field_pack_flag)			// Very old .frm file
      field->pack_flag&= ~FIELDFLAG_OLD_RESET;
    field->unireg_type =strpos[8];
    skr=		strpos[10];
    field->intervall=	skr == 0 ? (TYPELIB*) 0 : outparam->intervalls+skr-1;
    if (f_maybe_null(field->pack_flag))
      outparam->null_fields++;
    if (MTYP_TYPENR(field->unireg_type) == MTYP_NEXT_NUMBER)
      if ((int) (outparam->next_number_index= (uint)
		 find_ref_key(outparam,field,1,&tmp)) < 0)
	field->unireg_type-=MTYP_TYPENR(field->unireg_type);
      else
	outparam->found_next_number_field=field;
    if (MTYP_TYPENR(field->unireg_type) == MTYP_TIMESTAMP &&
	!outparam->timestamp_field)
      outparam->timestamp_field=field;
    if (f_is_blob(field->pack_flag))
      outparam->has_blob=1;
  }
  outparam->key_parts=key_parts;

  /* Fix key->name and key_part->field */
  if (key_parts)
  {
    key_part=outparam->key_info->key_part;
    for (uint key=0 ; key < outparam->keys ; key++)
    {
      outparam->key_info[key].name=outparam->keynames.type_names[key];
      for (i=0 ; i++ < outparam->key_info[key].key_parts ; key_part++)
      {
	key_part->fieldnr=(uint16) find_field(outparam,
					      (uint) key_part->offset,
					      (uint) key_part->length);
	if (key_part->fieldnr)
	  key_part->field=outparam->field+key_part->fieldnr-1;
	DBUG_PRINT("loop",("key: %d  field:  %d",i,key_part->fieldnr));
      }
    }
  }
  x_free((gptr) disk_buff);
  if (prgflag & GET_NAME_OF_INDEXFILE)
  {
    my_free(outparam->reginfo.name,MYF(0));
    outparam->reginfo.name=my_strdup(index_file,MYF(MY_WME));
  }
  DBUG_RETURN (0);

 err:
  if (funktpos)
  {
    VOID(ha_close(outparam));
    outparam->file=0;				/* For easyer errorchecking */
    outparam->fields=0;
  }

  x_free((gptr) outparam->field);
  x_free((gptr) disk_buff);
  x_free((gptr) outparam->record[0]);
  x_free((gptr) outparam->key_info);
  x_free((gptr) outparam->reginfo.name);
  VOID(my_close(file,MYF(MY_WME)));

 err_end:					/* Here when no file */
  outparam->reginfo.name=name;			/* For frm_error */
  if (!(prgflag & DONT_GIVE_ERROR))
    frm_error(error,outparam,ME_ERROR+ME_WAITTANG);
  DBUG_RETURN (error);
} /* openfrm */


	/* st{nger en formatfil */

int closefrm(register FORM *frmfile)
{
  int error=0;
  DBUG_ENTER("closefrm");
  if (frmfile->db_stat)
    error=ha_close(frmfile);
  else if (frmfile->dfile)
    error=my_close(frmfile->dfile,MYF(MY_WME));
  x_free((gptr) frmfile->key_info);
  my_free((gptr) frmfile->field,MYF(MY_WME));
  my_free((gptr) frmfile->record[0],MYF(MY_WME));
  x_free((gptr) frmfile->reginfo.name);		/* May be freed before */
  x_free((gptr) frmfile->reginfo.alias);
  frmfile->file=0;				/* For easyer errorchecking */
  frmfile->fields=0;
  DBUG_RETURN(error);
} /* closefrm */


	/* Find where a form starts */
	/* if formname is NullS then only formnames is read */

ulong get_form_pos(File file, uchar *head, string formname,
		   string outname, TYPELIB *save_names)
{
  int nr;
  uint a_length,names,length;
  uchar *pos,*buf;
  ulong ret_value;
  DBUG_ENTER("get_form_pos");

  names=uint2korr(head+8);
  a_length=(names+2)*sizeof(string);		/* Room for two extra */

  if (!save_names)
    a_length=0;
  else
    save_names->type_names=0;			/* Clear if error */

  if (outname && head[32])
    VOID(strmake((byte*) outname,(byte*) head+32,32));

  VOID(my_seek(file,64L,MY_SEEK_SET,MYF(0)));

  length=uint2korr(head+4);
  if (!(buf= (uchar*) my_malloc((uint) length+a_length+names*4,MYF(MY_WME))) ||
      my_read(file,(byte*) buf+a_length,(uint) (length+names*4),MYF(MY_NABP)))
  {
    x_free((gptr) buf);
    DBUG_RETURN(0L);
  }
  ret_value= (ulong) -1;			/* If not formname */
  if (formname)
  {
    char *tmp_formname;
    ret_value=0L;
    if (names && (tmp_formname=my_strdup(formname,MYF(MY_WME | MY_FAE))))
    {
      stripp_sp(tmp_formname);
      if ((nr=find_str_type(tmp_formname,(string) buf+a_length+1,
			    (char) buf[a_length], 1)) > 0)
      {
	pos= buf+a_length+length+nr*4-4;
	ret_value=uint4korr(pos);
      }
      my_free(tmp_formname,MYF(0));
    }
  }
  if (! save_names)
    my_free((gptr) buf,MYF(0));
  else
  {
    char *str;
    str=(string) (buf+a_length);
    fix_type_pointers((string**) &buf,save_names,1,&str);
  }
  DBUG_RETURN(ret_value);
} /* get_form_pos */


	/* Read string from a file with malloc */

static int read_string(File file, gptr *to, uint length)
{
  DBUG_ENTER("read_string");

  x_free((gptr) *to);
  if (!(*to= (gptr) my_malloc(length+1,MYF(MY_WME))) ||
      my_read(file,(byte*) *to,length,MYF(MY_NABP)))
  {
    x_free((gptr) *to);
    *to= 0;
    DBUG_RETURN(1);
  }
  *((char*) *to+length)= '\0';
  DBUG_RETURN (0);
} /* read_string */


	/* L{gg till ett nytt formul{r till en formul{rfil */

ulong make_new_entry(File file, uchar *fileinfo, TYPELIB *formnames,
		     string newname)
{
  uint i,bufflength,maxlength,n_length,length,names;
  ulong endpos,newpos;
  char buff[IO_SIZE];
  uchar *pos;
  DBUG_ENTER("make_new_entry");

  length=strlen(newname)+1;
  n_length=uint2korr(fileinfo+4);
  maxlength=uint2korr(fileinfo+6);
  names=uint2korr(fileinfo+8);
  newpos=uint4korr(fileinfo+10);

  if (64+length+n_length+(names+1)*4 > maxlength)
  {						/* Expand file */
    newpos+=IO_SIZE;
    int4store(fileinfo+10,newpos);
    endpos=my_seek(file,0L,MY_SEEK_END,MYF(0)); /* Copy from file-end */
    bufflength= (uint) (endpos & (IO_SIZE-1));	/* IO_SIZE is a power of 2 */

    while (endpos > maxlength)
    {
      VOID(my_seek(file,(ulong) (endpos-bufflength),MY_SEEK_SET,MYF(0)));
      if (my_read(file,buff,bufflength,MYF(MY_NABP+MY_WME)))
	DBUG_RETURN(0L);
      VOID(my_seek(file,(ulong) (endpos-bufflength+IO_SIZE),MY_SEEK_SET,
		   MYF(0)));
      if ((my_write(file,buff,bufflength,MYF(MY_NABP+MY_WME))))
	DBUG_RETURN(0);
      endpos-=bufflength; bufflength=IO_SIZE;
    }
    bzero(buff,IO_SIZE);			/* Null new block */
    VOID(my_seek(file,(ulong) maxlength,MY_SEEK_SET,MYF(0)));
    if (my_write(file,buff,bufflength,MYF(MY_NABP+MY_WME)))
	DBUG_RETURN(0L);
    maxlength+=IO_SIZE;				/* Fix old ref */
    int2store(fileinfo+6,maxlength);
    for (i=names, pos= (uchar*) *formnames->type_names+n_length-1; i-- ;
	 pos+=4)
    {
      endpos=uint4korr(pos)+IO_SIZE;
      int4store(pos,endpos);
    }
  }

  if (n_length == 1 )
  {						/* First name */
    length++;
    VOID(strxmov(buff,"/",newname,"/",NullS));
  }
  else
    VOID(strxmov(buff,newname,"/",NullS));
  VOID(my_seek(file,63L+(ulong) n_length,MY_SEEK_SET,MYF(0)));
  if (my_write(file,buff,(uint) length+1,MYF(MY_NABP+MY_WME)) ||
      (names && my_write(file,*formnames->type_names+n_length-1,
			 names*4, MYF(MY_NABP+MY_WME))) ||
      my_write(file,(byte*) fileinfo+10,(uint) 4,MYF(MY_NABP+MY_WME)))
    DBUG_RETURN(0L);

  int2store(fileinfo+8,names+1);
  int2store(fileinfo+4,n_length+length);
  VOID(my_chsize(file,newpos,MYF(MY_WME)));	/* Append file with '\0' */
  DBUG_RETURN(newpos);
} /* make_new_entry */


	/* error message when opening a form file */

void frm_error(int error, FORM *form, myf errortype)
{
  int er_no;
  string datext;
  char buff[FN_REFLEN],*form_dev="";
  DBUG_ENTER("frm_error");

  switch (error) {
  case 2:
    datext=bas_ext[form->db_type][test(form->db_stat & HA_OPEN_KEYFILE)];
    er_no= (my_errno == ENOENT) ? ER_FILE_NOT_FOUND : (my_errno == EAGAIN) ?
      ER_FILE_USED : ER_CANT_OPEN_FILE;
    my_printf_error(ER(er_no),errortype,
		    fn_format(buff,form->reginfo.name,form_dev,datext,2),my_errno);
    break;
  default:
    form_error(error,form->reginfo.name,form->reginfo.formname,reg_ext,
	       errortype);
  }
  DBUG_VOID_RETURN;
} /* frm_error */


	/* error message when opening a .frm file */

void form_error(int error, string name, string formname, string form_ext,
		myf errortype)
{
  char buff[FN_REFLEN],*form_dev="";
  DBUG_ENTER("form_error");

  switch (error) {
  case 1:
    my_printf_error(ER(ER_FILE_NOT_FOUND),errortype,
		    fn_format(buff,name,form_dev,form_ext,0),my_errno);
    break;
  case 3:
    VOID(stripp_sp(formname));
    my_printf_error(ER(ER_FORM_NOT_FOUND),errortype,formname,
		    fn_format(buff,name,form_dev,form_ext,0));
    break;
  default:				/* Better wrong error than none */
  case 4:
    my_printf_error(ER(ER_NOT_FORM_FILE),errortype,
		    fn_format(buff,name,form_dev,form_ext,0));
    break;
  case 9:
    my_error(ER_CANT_FIND_SYSTEM_REC,errortype);
    break;
  }
  DBUG_VOID_RETURN;
} /* form_error */


	/* Change a bit-fieldtyp to a number */
	/* fields can be separated with space or ',' */

ulonglong find_bit_type(const string x,TYPELIB *bit_lib)
{
  int found_end;
  char *end,*i,*j;
  string *array,pos;
  ulonglong found,found_int,bit;
  DBUG_ENTER("find_bit_type");
  DBUG_PRINT("enter",("x: '%s'",x));

  found=found_end=0;
  pos=(string) x;
  do
  {
    if (!*(end=strcend(pos,',')))		/* Let end point at fieldend */
    {
      while (end > pos && end[-1] == ' ')
	end--;					/* Skipp end-space */
      found_end=1;
    }
    found_int=0;
    for (array=bit_lib->type_names, bit=1 ; (i= *array++) ; bit<<=1)
    {
      j=pos;
      while (j != end)
      {
	if (toupper(*i++) != toupper(*j++))
	  goto skipp;
      }
      if (! *i)
      {
	found_int=bit;
	break;
      } else if (j != pos)
      {					/* Half field found */
	if (found_int)
	{
	  found_int=0;			/* Could be one of two values */
	  break;
	}
	found_int=bit;
      }
skipp: ;
    }
    found|=found_int;
    if (!found_int && pos != end)
      current_thd->cuted_fields++;
    pos=end+1;
  } while (! found_end);

  DBUG_PRINT("exit",("bit-field: %ld",found));
  DBUG_RETURN(found);
} /* find_bit_type */


	/* Change a number to a bit-type (field with many values)	*/
	/* If length is set then to is appended to length without	*/
	/* closing null.						*/

void make_bit_type(register string to, ulonglong nr, TYPELIB *bit_lib, uint length)
{
  uint bitnr,left_length;
  char *start,*old;

  bitnr=0; start=to;
  if (!(left_length=length))
    left_length=MAX_FIELD_WIDTH;
  while (nr && bitnr < (uint) bit_lib->count)
  {
    if (nr & 1)
    {
      if (to != start && left_length)
      {
	*to++= ',';
	left_length--;
      }
      to=strnmov(old=to,bit_lib->type_names[bitnr],left_length);
      left_length-= (uint) (to-old);
    }
    nr>>=1;
    bitnr++;
  }
  if (length)
    VOID(strfill(to,left_length,f_fyllchar));
  else
    *to='\0';
  return;
} /* make_bit_type */


	/*
	** fix a str_type to a array type
	** typeparts sepearated with some char. differents types are separated
	** with a '\0'
	*/

static void
fix_type_pointers(string **array, TYPELIB *point_to_type, uint types,
		  string *names)
{
  string type_name,ptr;
  char chr;

  ptr= *names;
  while (types--)
  {
    point_to_type->name=0;
    point_to_type->type_names= *array;

    if ((chr= *ptr))			/* Test if empty type */
    {
      while ((type_name=strchr(ptr+1,chr)) != NullS)
      {
	*((*array)++) = ptr+1;
	*type_name= '\0';		/* End string */
	ptr=type_name;
      }
      ptr+=2;				/* Skipp end mark and last 0 */
    }
    else
      ptr++;
    point_to_type->count= (uint) (*array - point_to_type->type_names);
    point_to_type++;
    *((*array)++)= NullS;		/* End of type */
  }
  *names=ptr;				/* Update end */
  return;
} /* fix_type_pointers */



	/* free typelib */
	/* Clears struct for new use */

void free_type(TYPELIB *typelib)
{
  typelib->count=0;
  if (typelib->type_names)
  {
    my_free((gptr) typelib->type_names,MYF(0));
    typelib->type_names=0;
  }
} /* free_type */


	/* Search after a fieldtype in a string separated by some char */
	/* Returns number of found type. */
	/* Test if find hole type or unic part of type */
	/* Returns 0 if x = '\0' and empty type isn't found */
	/* Returns -1 if can't find type */

static int find_str_type(string x, string typelib, char separator,
			 bool full_name)
{
  uint antal,length,find;
  register string pos,gpos;
  char buff[3],*findpos;
  DBUG_ENTER("find_str_type");
  DBUG_PRINT("enter",("x: '%s'  lib: %lx  sep: %c",x,typelib,separator));

  findpos=0;					// Keep gcc happy
  find=0;
  if (!x[0])
  {
    if (typelib[0] == separator)
      DBUG_RETURN(1);
    buff[0]=buff[1]=(char) separator; buff[2]=0;
    if ((pos=strcasestr(typelib,buff)))
      pos++;
    length=0;
  }
  else
  {
    pos=typelib; length=strlen(x);
    while ((pos=strcasestr(pos,x)) != NullS)
    {
      if (pos == typelib || pos[-1] == (char) separator)
      {
	if (pos[length] == separator)
	  break;
	find++; findpos= pos;
      }
      pos+=length+1;
    }
  }
  if (pos == NullS)
  {
    if (length == 0)
      DBUG_RETURN(0);
    if (find != 1 || full_name)
      DBUG_RETURN(-1);
    pos=findpos;
  }
  antal=1;
  for (gpos=typelib ; gpos != pos ; gpos=strchr(gpos,(char) separator)+1)
    antal++;
  DBUG_PRINT("exit",("type: %d",antal));
  DBUG_RETURN((int) antal);
} /* find_str_type */


	/* Returns fieldname or fieldnumber if no name */

void field_name_or_number(string to, FORM *form, uint fieldnr)
{
  if (fieldnr < form->fields)
  {
    VOID(strmov(to,form->fieldnames.type_names[fieldnr]));
    if (! to[0])
      VOID(my_itoa((int) fieldnr+1,to,10));
  }
  else
    to[0]='\0';
} /* field_name_or_number */


	/* Skapar utrymme och referenserna f|r en str{ngmatris */

char **make_char_array(register uint fields, uint length, myf my_flag)
{
  register char **pos;
  char **old_pos,*char_pos;
  DBUG_ENTER("make_char_array");

  if ((old_pos= (char**) my_malloc((uint) fields*(length+sizeof(char*)),
				    my_flag)))
  {
    pos=old_pos; char_pos=((char*) (pos+fields)) -length;
    while (fields--) *(pos++) = (char_pos+= length);
  }

  DBUG_RETURN(old_pos);
} /* make_char_array */


	/* Check if a string is a valid number */
	/* Output: TRUE -> number */

int test_if_number(register string str, int *res, bool allow_wildcards)
{
  reg2 int flag;
  string start;
  DBUG_ENTER("test_if_number");

  flag=0; start=str;
  while (*str++ == ' ') ;
  if (*--str == '-' || *str == '+')
    str++;
  while (isdigit(*str) || (allow_wildcards &&
			   (*str == wild_many || *str == wild_one)))
  {
    flag=1;
    str++;
  }
  if (*str == '.')
    for (str++ ;
	 isdigit(*str) ||
	   (allow_wildcards && (*str == wild_many || *str == wild_one)) ;
	 str++, flag=1) ;
  if (*str != 0 || flag == 0)
    DBUG_RETURN(0);
  if (res)
    *res=atoi(start);
  DBUG_RETURN(1);			/* Number ok */
} /* test_if_number */


	/* Kontrollerar att integern passar inom gr{nserna */

int set_zone(register int nr, int min_zone, int max_zone)
{
  if (nr<=min_zone)
    return (min_zone);
  if (nr>=max_zone)
    return (max_zone);
  return (nr);
} /* set_zone */

	/* Justerar ett tal till n{sta j{mna diskbuffer */

ulong next_io_size(register ulong pos)
{
  reg2 ulong offset;
  if ((offset= pos & (IO_SIZE-1)))
    return pos-offset+IO_SIZE;
  return pos;
} /* next_io_size */


	/* Skapar en frm_fil */

File create_frm(register string name, uint reclength, uchar *fileinfo,
		enum db_type database, uint options, ulong records,
		ulong reloc,uint keys)
{
  register File file;
  uint length,key_length;
  char fill[IO_SIZE];

  if ((file=my_create(name,CREATE_MODE,O_RDWR | O_TRUNC,MYF(MY_WME))) > 0)
  {
    bzero((byte*) fileinfo,64);
    fileinfo[0]=(uchar) 254; fileinfo[1]= 1; fileinfo[2]= FRM_VER+1;/* Header */
    fileinfo[3]= (uchar) ha_checktype(database);
    fileinfo[4]=1;
    int2store(fileinfo+6,IO_SIZE);		/* Next block starts here */
    key_length=keys*(7+MAX_FIELD_NAME+MAX_REF_PARTS*9)+16;
    length=(uint) next_io_size((ulong) (IO_SIZE+key_length+reclength));
    int2store(fileinfo+10,length);
    int2store(fileinfo+14,key_length);
    int2store(fileinfo+16,reclength);
    int4store(fileinfo+18,records);
    int4store(fileinfo+22,reloc);
    fileinfo[27]=1;				/* Use long pack-fields */
    int2store(fileinfo+30,options);
    VOID(fn_format((char*) fileinfo+32,name,"","",3));
    bzero(fill,IO_SIZE);
    for (; length > IO_SIZE ; length-= IO_SIZE)
    {
      if (my_write(file,fill,IO_SIZE,MYF(MY_WME | MY_NABP)))
      {
	VOID(my_close(file,MYF(0)));
	VOID(my_delete(name,MYF(0)));
	return(-1);
      }
    }
  }
  return (file);
} /* create_frm */


int
rename_file_ext(const char * from,const char * to,const char * ext)
{
  char from_b[FN_REFLEN],to_b[FN_REFLEN];
  VOID(strxmov(from_b,from,ext,NullS));
  VOID(strxmov(to_b,to,ext,NullS));
  return (my_rename(from_b,to_b,MYF(MY_WME)));
}


/*
** Change the current ref in the .frm file to the current file name
*/

int fix_frm_ref(const char * name)
{
  char buff[FN_REFLEN];
  int error= -1;
  uint length;
  File file;
  DBUG_ENTER("fix_frm_ref");

  if ((file=my_open(fn_format(buff,name,"",reg_ext,2+4),O_RDWR,MYF_RW)) >= 0)
  {
    if (!(my_pread(file,buff,32,32,MYF_RW | MY_WME)))
    {
      bzero(buff+32,32);				/* Remove old name */
      length=dirname_length(name);
      if (strlen(name)-length < 32)
	strmov(buff,name+length);
      if (!my_pwrite(file,buff,32,32,MYF_RW | MY_WME))
	error=0;
    }
end:
    VOID(my_close(file,MYF(MY_WME)));
  }
  DBUG_RETURN(error);
}
