/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB
   
   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.
   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.  The License grants you the right to 
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* Makes a database from a form-file */

#include "mysql_priv.h"
#ifndef NO_HASH
#include <hashdb.h>
#endif
#include <heap.h>
#include <nisam.h>
#include <merge.h>

	/* Functions in this file */

static uint splitt_field_flag(uint fieldstart, uint length, FORM *form,
			      bool *splitt);
#ifndef NO_HASH
static int NEAR_F cre_hash(char *name,FORM *form);
#endif
static int NEAR_F cre_isam(char *name,FORM *form,uint options);


	/* Initiates form-file and calls apropriate database-creator */
	/* Returns 1 if something got wrong */

int cre_database(string name)
{
  int error;
  FORM form;
  DBUG_ENTER("cre_database");

  error=0;					// Keep lint happy
  if (openfrm(name,"",0,(uint) (READ_ALL+GET_NAME_OF_INDEXFILE),&form))
    DBUG_RETURN(1);

  name=form.reginfo.name;			/* Name of database */
#ifdef HAVE_FILE_VERSIONS
  {						/* Remove old database */
    char buff[FN_REFLEN];
    if (bas_ext[form.filetype][0][0])
      VOID(my_delete(fn_format(buff,name,form_dev,
			       bas_ext[form.filetype][0],2+4+16), MYF(0)));
    if (bas_ext[form.filetype][1][0])
      VOID(my_delete(fn_format(buff,name,form_dev,
			       bas_ext[form.filetype][1], 2+4+16), MYF(0)));
  }
#endif /* HAVE_FILE_VERSIONS */

  switch (form.db_type)
  {
#ifndef NO_HASH
    case DB_TYPE_HASH:		error=cre_hash(name,&form); break;
#endif
#ifndef NO_HEAP
    case DB_TYPE_HEAP:
      {						/* Remove old database */
	char buff[FN_REFLEN];
	error=heap_create(fn_format(buff,name,"","",1+2));
	break;
      }
#endif
    case DB_TYPE_ISAM:
      error=cre_isam(name,&form, form.db_create_options);
      break;
  case DB_TYPE_MRG_ISAM:
#ifndef NO_MERGE
      {
	char buff[FN_REFLEN];
	error=mrg_create(fn_format(buff,name,"","",2+4+16),0);
	break;
      }
#endif
    default: break;				/* impossibly */
  }
  VOID(closefrm(&form));
  if (error)
    my_error(ER_CANT_CREATE_TABLE,MYF(ME_BELL+ME_WAITTANG),name,my_errno);
  DBUG_RETURN(error != 0);
} /* cre_database */


	/* makes a hash-database */

#ifndef NO_HASH

static int NEAR_F cre_hash(string name, register FORM *form)
{
  register uint i,j;
  char buff[FN_REFLEN];
  int flag;
  KEY *pos;
  H_KEYDEF keydef[MAX_KEY];
  DBUG_ENTER("cre_hash");

  pos=form->key_info;
  for (i=0; i < form->keys ; i++, pos++)
  {
    keydef[i].hk_flag=	 pos->dupp_key ? 0 : HA_NOSAME;
    for (j=0 ; (int7) j < pos->key_parts ; j++)
    {
      uint flag=pos->key_part[j].key_type;
      if (!f_is_packed(flag) && f_packtype(flag) == (int) FIELD_TYPE_DECIMAL &&
	  !(flag & FIELDFLAG_BINARY))
	keydef[i].hk_keyseg[j].key_type= (int) HA_KEYTYPE_TEXT;
      else
	keydef[i].hk_keyseg[j].key_type= (int) HA_KEYTYPE_BINARY;
      keydef[i].hk_keyseg[j].start=  pos->key_part[j].offset;
      keydef[i].hk_keyseg[j].length= pos->key_part[j].length;
    }
    keydef[i].hk_keyseg[j].key_type= 0;
  }
  DBUG_RETURN(h_create(fn_format(buff,name,"","",2+4+16),i,
		       keydef,form->reclength,form->max_records,form->reloc,
		       0));
} /* cre_hash */
#endif


	/* makes a new-isam-database */

static int NEAR_F cre_isam(string name, register FORM *form, uint options)
{
  int error;
  uint i,j,recpos,minpos,fieldpos,flag,temp_length,length;
  bool splitt;
  enum ha_base_keytype type;
  char buff[FN_REFLEN];
  FIELD *field,*found;
  KEY *pos;
  N_KEYDEF keydef[MAX_KEY];
  N_RECINFO *recinfo,*recinfo_pos;
  DBUG_ENTER("cre_isam");

  type=HA_KEYTYPE_BINARY;				// Keep compiler happy
  LINT_INIT(flag);
  if (!(recinfo= (N_RECINFO*) my_alloca((form->fields*2+1)*sizeof(N_RECINFO))))
    DBUG_RETURN(1);

  pos=form->key_info;
  for (i=0; i < form->keys ; i++, pos++)
  {
    keydef[i].base.flag= (pos->dupp_key ? 0 : HA_NOSAME);
    for (j=0 ; (int7) j < pos->key_parts ; j++)
    {
      keydef[i].seg[j].base.flag=pos->key_part[j].key_part_flag;
      flag=splitt_field_flag((uint) pos->key_part[j].offset,
			     (uint) pos->key_part[j].length, form,&splitt);
      switch (f_packtype(flag)) {
      case FIELD_TYPE_DECIMAL:
	if (f_is_num(flag))
	{
	  type=f_is_zerofill(flag) ? HA_KEYTYPE_BINARY : HA_KEYTYPE_NUM;
	}
	else if (flag & (FIELDFLAG_BINARY+FIELDFLAG_PACK))
	  type = HA_KEYTYPE_BINARY;		/* Binary value key */
	else
	  type=HA_KEYTYPE_TEXT;			/* ASCII */
	break;
      case FIELD_TYPE_CHAR:
	type=f_is_dec(flag) ? HA_KEYTYPE_INT8 : HA_KEYTYPE_BINARY;
	break;
      case FIELD_TYPE_NULL:
	type=HA_KEYTYPE_BINARY;
	break;
      case FIELD_TYPE_SHORT:
	type=f_is_dec(flag) ? HA_KEYTYPE_SHORT_INT : HA_KEYTYPE_USHORT_INT;
	break;
      case FIELD_TYPE_TIMESTAMP:
      case FIELD_TYPE_LONG:
      case FIELD_TYPE_DATE:
	type=f_is_dec(flag) ? HA_KEYTYPE_LONG_INT : HA_KEYTYPE_ULONG_INT;
	break;
      case FIELD_TYPE_FLOAT:
	type=HA_KEYTYPE_FLOAT;
	break;					/* Short float (4 byte) */
      case FIELD_TYPE_DOUBLE:
	type=HA_KEYTYPE_DOUBLE;
	break;					/* Long float (8 byte)	*/
#ifdef HAVE_LONG_LONG
      case FIELD_TYPE_LONGLONG:
	type=f_is_dec(flag) ? HA_KEYTYPE_LONGLONG : HA_KEYTYPE_ULONGLONG;
	break;
#endif
      case FIELD_TYPE_INT24:
      case FIELD_TYPE_TIME:
	type=f_is_dec(flag) ? HA_KEYTYPE_INT24 : HA_KEYTYPE_UINT24;
      }
      if ((options & HA_OPTION_PACK_KEYS) && pos->key_part[j].length > 8 &&
	  (type == HA_KEYTYPE_TEXT ||
	   type == HA_KEYTYPE_NUM ||
	   (type == HA_KEYTYPE_BINARY && !(flag & FIELDFLAG_PACK))))
      {
	if (j == 0)
	  keydef[i].base.flag|=HA_PACK_KEY;
	if (!splitt && ! f_is_zerofill(flag) &&
	    (f_is_alpha(flag) ||
	     (pos->key_part[j].length-test(f_decimals(flag) >= 4))))
	  keydef[i].seg[j].base.flag|=HA_SPACE_PACK;
      }
      keydef[i].seg[j].base.type=(int) type;
      keydef[i].seg[j].base.start=  pos->key_part[j].offset;
      keydef[i].seg[j].base.length= pos->key_part[j].length;
    }
    keydef[i].seg[j].base.type=(int) HA_KEYTYPE_END;	/* End of key-parts */
  }

  recpos=0; recinfo_pos=recinfo;
  while (recpos < (uint) form->reclength)
  {
    minpos=form->reclength; found=0; length=0; field=form->field;
    for (i=0 ; i++ < form->fields ; field++)
    {
      if ((fieldpos=(uint) (field->str - form->record[0])) >= recpos &&
	  fieldpos <= minpos)
      {
	if (!(temp_length= packlength(field)))
	  continue;				/* Skipp null-fields */
	if (! found || fieldpos < minpos ||
	    (fieldpos == minpos && temp_length < length))
	{
	  minpos=fieldpos; found=field; length=temp_length;
	}
      }
    }
    DBUG_PRINT("loop",("found: %lx  recpos: %d  minpos: %d  length: %d",
		       found,recpos,minpos,length));
    if (recpos != minpos)
    {
      recinfo_pos->base.type=(int) FIELD_NORMAL;
      recinfo_pos++->base.length= (uint16) (minpos-recpos);
    }
    if (! found)
      break;

    flag=found->pack_flag;
    if (f_is_blob(flag))
      recinfo_pos->base.type= (int) FIELD_BLOB;
    else if (!(options & HA_OPTION_PACK_RECORD))
      recinfo_pos->base.type= (int) FIELD_NORMAL;
    else if (f_is_packed(flag) && (f_is_num(flag) || f_is_bitfield(flag)))
      recinfo_pos->base.type= (int) FIELD_SKIPP_ZERO;
    else
      recinfo_pos->base.type= (int) (length < 3 || f_is_packed(flag) ?
				     FIELD_NORMAL :
				     f_is_alpha(flag) ? FIELD_SKIPP_ENDSPACE :
				     !f_is_zerofill(flag) ?
				     FIELD_SKIPP_PRESPACE :
				     FIELD_NORMAL);

    recinfo_pos++ ->base.length=(uint16) length;
    recpos=minpos+length;
    DBUG_PRINT("loop",("length: %d  type: %d",
		       recinfo_pos[-1].base.length,recinfo_pos[-1].base.type));
  }
  recinfo_pos->base.type= (int) FIELD_LAST;	/* End of fieldinfo */
  error=ni_create(fn_format(buff,name,"","",2+4+16),form->keys,keydef,
		  recinfo,form->max_records,form->reloc,0,0);
  my_afree((gptr) recinfo);
  DBUG_RETURN(error);
} /* cre_isam */


	/* Test if a region is a field */
	/* Returns flag of found field */

static uint splitt_field_flag(uint fieldstart, uint length, FORM *form,
			      bool *splitt)
{
  uint find_flag;
  uint pack_length;
  reg2 string record;
  reg1 FIELD *f,*end;

  *splitt=0;
  find_flag=1;					/* If no find use binary */
  for(;;)
  {
    record=form->record[0];
    f=form->field;
    end=form->field+form->fields;
    for ( ; f != end ; f++)
      if ((uint) (f->str - record) == fieldstart)
	goto find;
    return(find_flag);				/* Can't find */
find:
    pack_length=packlength(f);
    if (((pack_length != length || *splitt) && f_is_packed(f->pack_flag)) ||
	(f_is_alpha(f->pack_flag) && f_is_binary(f->pack_flag)))
	 return(1);
    if (length <= pack_length)
      return(find_flag != 1 ? find_flag : (uint) f->pack_flag);
    length-= pack_length;
    fieldstart+=pack_length;
    if ((f->pack_flag &( FIELDFLAG_NUMBER+FIELDFLAG_BINARY)) == 0)
      find_flag= 0;			/* One alfa field; use alfa search */
    *splitt=1;
  }
}
