#!/bin/sh
# Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
# This file is public domain and comes with NO WARRANTY of any kind
#
# scripts to start mysql and restart it if it dies unexpectedly
#
# This should be executed in the mysql directory if you are using a
# binary installation that has other paths than you are using.
# mysql.server works by first doing a cd to the base directory and from there
# executing safe_mysqld

file=`hostname`.pid
log=`hostname`.log

# Check if we are starting this relative (for the binary release)
if test -f ./data/mysql/db.frm -a -f ./share/english/errmsg.sys -a -x ./bin/mysqld
then
  MY_BASEDIR_VERSION=`pwd`		# Where bin, share and data is
  DATADIR=$MY_BASEDIR_VERSION/data	# Where the databases are
  ledir=$MY_BASEDIR_VERSION/bin		# Where mysqld are
else
  MY_BASEDIR_VERSION=@prefix@
  DATADIR=@localstatedir@
  ledir=@libexecdir@
fi
echo "Starting mysql demon with databases from $DATADIR"

#Default communication ports
#MYSQL_TCP_PORT=3333
#MYSQL_UNIX_PORT="/tmp/mysql.sock"
#export MYSQL_TCP_PORT MYSQL_UNIX_PORT

rm -f $DATADIR/$file		# Pid file
echo "mysqld started" >> $DATADIR/$log
while true
do
  $ledir/mysqld -b $MY_BASEDIR_VERSION -h $DATADIR $* >> $DATADIR/$log 2>&1
  if test ! -f $DATADIR/$file	# This is removed if normal shutdown
  then
    break;
  fi
  echo "mysqld restarted" >> $DATADIR/$log
done

echo "mysqld end" >> $DATADIR/$log
echo "" >> $DATADIR/$log
echo "mysqld demon ended"
