# -*- perl -*-
use ExtUtils::MakeMaker;
require 5.003;

$X{CONFIGURE} = \&initialize;

WriteMakefile(%X);

#
# The headerdir and libdir is done that it should work in the TCX development
# environment, in the mysql binary distribution and in the source distribution
#

sub initialize {
    %X=(
	NAME       => "Mysql",
	"DISTNAME" => "MysqlPerl",
	"clean"    => { FILES => 'Mysql.pm.html bench/*~' },
	"dist"     => { SUFFIX   => "gz", DIST_DEFAULT => 'all uutardist',
			    COMPRESS => "gzip -9f",
			},
       );
    $srcdir = $ENV{"SRCDIR"};
    $srcdir = "." if !defined($srcdir);
    $headerdir= (-d "$srcdir/../../include") ? "$srcdir/../../include" :
      ( -d "../include-lib" ) ? "../include-lib" : "../include"; 
    die "No $headerdir/mysql.h file found\n" unless -f "$headerdir/mysql.h";
    $libdir= ( -d "../mach-lib-opt" ) ? "../mach-lib-opt" : 
	(-d "../lib/") ? "../lib/" : "../../client/";
    if ( -f "$libdir/libmysqlclient.a")
    {
      $libs="-lmysqlclient";
    }	
    else
    {
      $libs="-lmysql -lmysys -ldbug -lstrings";
    }
    open MYSQL, "$srcdir/lib/Mysql.pm" or die "open: $!";
    while (!$VERSION){
	$_=<MYSQL>;
	next unless /VERSION/;
	eval;
    }
    close MYSQL;
    if ($Config{cc} eq 'gcc' || $Config{cc} eq '')
    {
      $tmp=`gcc -print-libgcc-file-name`;
      $tmp=substr($tmp,0,rindex($tmp,"/"));
      $sysliblist=" -L$tmp -lgcc";
    }
    @headerfiles = ("$headerdir/mysql.h");
    $X{LIBS}     = "-L$libdir $libs $sysliblist";
    $X{INC}      = "-I$headerdir";
    $X{H}        = \@headerfiles;
    $X{VERSION}  = $VERSION;
    \%X;
}


