/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/* Functions to get threads more portable */

#include "mysys_priv.h"
#include <m_string.h>

pthread_key_t THR_KEY_my_errno,THR_KEY_cmp_length;
pthread_key_t THR_KEY_sigset;
pthread_mutex_t THR_LOCK_malloc=PTHREAD_MUTEX_INITIALIZER,
		THR_LOCK_open=PTHREAD_MUTEX_INITIALIZER,
		THR_LOCK_keycache=PTHREAD_MUTEX_INITIALIZER;

void my_thread_init(void)
{
  pthread_setspecific(THR_KEY_my_errno,calloc(1,sizeof(int)));
  pthread_setspecific(THR_KEY_cmp_length,calloc(1,sizeof(int)));
  pthread_setspecific(THR_KEY_sigset,calloc(1,sizeof(sigset_t)));
}

int *_my_errno(void)
{
  return (int*) my_pthread_getspecific(THR_KEY_my_errno);
}

#ifndef my_pthread_setprio
void my_pthread_setprio(pthread_t thread_id,int prior)
{
  struct sched_param sched_param;
  bzero(&sched_param,sizeof(sched_param));
  sched_param.sched_priority=prior;
  VOID(pthread_setschedparam(pthread_self(),SCHED_OTHER,&sched_param));
}
#endif

#ifndef my_pthread_attr_setprio
void my_pthread_attr_setprio(pthread_attr_t *attr, int priority)
{
  struct sched_param sched_param;
  bzero(&sched_param,sizeof(sched_param));
  sched_param.sched_priority=priority;
  VOID(pthread_attr_setschedparam(attr,&sched_param));
}
#endif

/* Some functions for RTS threads */

#ifdef HAVE_rts_threads

int my_pthread_create_detached=1;

/* To allow use of pthread_getspecific with two arguments */

void *my_pthread_getspecific(pthread_key_t key)
{
  void *value;
  if (pthread_getspecific(key,(any_t *) &value))
    return 0;
  return value;
}

int my_sigwait(sigset_t *set,int *sig)
{
  int signal=sigwait(set);
  if (signal < 0)
    return errno;
  *sig=signal;
  return 0;
}
#endif
