/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/*
  This functions is handle keyblock cacheing for MISAM and PISAM databases.
  One cache can handle many files. Every different blocksize has it owns
  set of buffers that are allocated from block_mem.
  init_key_cache() is to init cache handler.
 */

#include "mysys_priv.h"
#include "my_static.h"
#include <m_string.h>
#include <errno.h>

#if defined(MSDOS) && !defined(M_IC80386)
	/* We nead much memory */
#undef my_malloc_lock
#undef my_free_lock
#define my_malloc_lock(A,B)	halloc((long) (A/IO_SIZE),IO_SIZE)
#define my_free_lock(A,B)	hfree(A)
#endif

static uint find_next_bigger_power(uint value);
static SEC_LINK *find_key_block(int file,ulong filepos,uint block_size,
				int *error);

	/* static variables in this file */
static SEC_LINK *_my_block_root,**_my_hash_root,
		*_my_used_first[MAX_BLOCK_TYPES],*_my_used_last[MAX_BLOCK_TYPES];
static int	_my_disk_blocks;
static uint	_my_disk_blocks_used,_my_blocks_used,_my_blocks_changed,
		_my_hash_blocks;
static my_bool	_my_printed;
static ulong	_my_cache_w_requests,_my_cache_write,_my_cache_r_requests,
		_my_cache_read;
static byte	HUGE_PTR *_my_block_mem;

	/* Init of disk_buffert */
	/* Returns blocks in use */
	/* ARGSUSED */

int init_key_cache(use_mem,leave_this_much_mem)
ulong use_mem;
ulong leave_this_much_mem __attribute__((unused));
{
  uint blocks,length;
  byte *extra_mem=0;
  DBUG_ENTER("init_key_cache");

  if (key_cache_inited && _my_disk_blocks > 0)
  {
    DBUG_PRINT("warning",("key cache allready in use"));
    DBUG_RETURN(0);
  }
  if (! key_cache_inited)
  {
    key_cache_inited=TRUE;
    _my_disk_blocks= -1;
    _my_printed=0;
  }

  blocks= (uint) (use_mem/(sizeof(SEC_LINK)+sizeof(SEC_LINK*)*5/4+MIN_KEYBLOCK));
  blocks/=MAX_BLOCK_TYPES;
  blocks*=MAX_BLOCK_TYPES;

  if (blocks >= 8 && _my_disk_blocks < 0)
  {
#ifndef HAVE_ALLOCA
    if ((extra_mem=my_malloc((uint) leave_this_much_mem,MYF(0))) == 0)
      goto err;
#endif
    for (;;)
    {
      if ((_my_hash_blocks=find_next_bigger_power((uint) blocks)) < blocks*5/4)
	_my_hash_blocks<<=1;
      while ((length=(uint) blocks*sizeof(SEC_LINK)+
	      sizeof(SEC_LINK*)*_my_hash_blocks)+(ulong) blocks*MIN_KEYBLOCK >
	     use_mem)
	blocks--;
      if ((_my_block_mem=my_malloc_lock((ulong) blocks*MIN_KEYBLOCK,MYF(0))))
      {
	if ((_my_block_root=(SEC_LINK*) my_malloc((uint) length,MYF(0))) != 0)
	  break;
	my_free_lock(_my_block_mem,MYF(0));
      }
      if (blocks < 8)
	goto err;
      blocks=blocks/4*3/MAX_BLOCK_TYPES;
      blocks*=MAX_BLOCK_TYPES;
    }
    _my_disk_blocks=(int) blocks;
    _my_hash_root=	(SEC_LINK**) (_my_block_root+blocks);
    bzero((byte*) _my_hash_root,_my_hash_blocks*sizeof(SEC_LINK*));
    bzero((byte*) _my_used_first,MAX_BLOCK_TYPES*sizeof(SEC_LINK*));
    bzero((byte*) _my_used_last,MAX_BLOCK_TYPES*sizeof(SEC_LINK*));
    _my_blocks_used=_my_disk_blocks_used=_my_blocks_changed=0;
    _my_cache_w_requests=_my_cache_r_requests=_my_cache_read=_my_cache_write=0;
    DBUG_PRINT("exit",("disk_blocks: %d  block_root: %lx  _my_hash_blocks: %d  hash_root: %lx",
		       _my_disk_blocks,_my_block_root,_my_hash_blocks,
		       _my_hash_root));
#ifndef HAVE_ALLOCA
    my_free(extra_mem,MYF(0));
#endif
  }
  DBUG_RETURN((int) blocks);
err:
  if (extra_mem)
    my_free(extra_mem,MYF(0));
  my_errno=ENOMEM;
  DBUG_RETURN(0);
} /* init_key_cache */


	/* Remove key_cache from memory */

void end_key_cache()
{
  DBUG_ENTER("end_key_cache");
  if (! _my_blocks_changed)
  {
    if (_my_disk_blocks > 0)
    {
      my_free_lock((gptr) _my_block_mem,MYF(0));
      my_free((gptr) _my_block_root,MYF(0));
      _my_disk_blocks= -1;
    }
  }
  DBUG_PRINT("status",
	     ("used: %d  changed: %d  w_requests: %ld  writes: %ld  r_requests: %ld  reads: %ld",
	      _my_blocks_used,_my_blocks_changed,_my_cache_w_requests,
	      _my_cache_write,_my_cache_r_requests,_my_cache_read));
  DBUG_VOID_RETURN;
} /* end_key_cache */


static uint find_next_bigger_power(value)
uint value;
{
  uint power=0;
  while (value >0)
  {
    value>>=1;
    power++;
  }
  return (1 << power);
}

#ifndef DBUG_OFF
#define DBUG_OFF				/* This should work */
#endif

#if defined(DBUG_OFF)
static void test_key_cache(void);
#endif


	/* read a key_buffer */
	/* Returns adress to key_buffer */

byte *key_cache_read(file,filepos,buff,length,block_length,return_buffer)
File file;
ulong filepos;			/* Must point at a even MIN_KEYBLOCK block */
byte *buff;
uint length,block_length;
int return_buffer __attribute__((unused)); /* return adress to used buffer? */
{
  reg1 SEC_LINK *next;
  int error=0;
  if (_my_disk_blocks > 0)
  {						/* We have key_cacheing */
    pthread_mutex_lock(&THR_LOCK_keycache);
    if ((next=find_key_block(file,filepos,block_length/MIN_KEYBLOCK-1,&error)) != 0)
    {
      if (error)
      {						/* Didn't find it in cache */
	next->size=(uint16) block_length;
	if (my_pread(file,next->buffer,length,filepos,MYF(MY_NABP)))
	{
	  pthread_mutex_unlock(&THR_LOCK_keycache);
	  return((byte*) 0);
	}
	_my_cache_read++;
      }
      _my_cache_r_requests++;
      pthread_mutex_unlock(&THR_LOCK_keycache);
#ifndef THREAD				/* buffer may be used a long time */
      if (return_buffer)
	return (next->buffer);
#endif
      if (! (length & 511))
	bmove512(buff,next->buffer,length);
      else
	memcpy(buff,next->buffer,(size_t) length);
      return(buff);
    }
    else if (error)
      return((byte*) 0);
  }
  if (my_pread(file,(byte*) buff,length,filepos,MYF(MY_NABP)))
    error=1;
  pthread_mutex_unlock(&THR_LOCK_keycache);
  return (error ? (byte*) 0 : buff);
} /* key_cache_read */


	/* write a key_buffer */
	/* We don't have to use pwrite because of write locking */

int key_cache_write(file,filepos,buff,length,block_length,dont_write)
File file;
ulong filepos;			/* Must point at a even MIN_KEYBLOCK block */
byte *buff;
uint length,block_length;
int dont_write;
{
  reg1 SEC_LINK *next;
  int error=0;

  if (!dont_write)
  {						/* Forced write of buffer */
    if (my_pwrite(file,buff,length,filepos,MYF(MY_NABP | MY_WAIT_IF_FULL)))
      return(1);
  }

  if (_my_disk_blocks > 0)
  {						/* We have key_cacheing */
    pthread_mutex_lock(&THR_LOCK_keycache);
    if ((next=find_key_block(file,filepos,block_length/MIN_KEYBLOCK-1,&error)) != 0)
    {
      next->size=(uint16) block_length;
      if (!dont_write)
	next->changed=0;			/* Buffer is written */
      else
      {
	if (!next->changed)
	{
	  next->changed=1;
	  _my_blocks_changed++;			/* New block */
	}
      }
      if (!(length & 511))
	bmove512(next->buffer,buff,length);
      else
	memcpy(next->buffer,buff,(size_t) length);
      _my_cache_w_requests++;
      error=0;
      goto end;
    }
    else if (error)
      goto end;
  }

  if (dont_write)
  {						/* We must write, no cache */
    if (my_pwrite(file,(byte*) buff,length,filepos,
		  MYF(MY_NABP | MY_WAIT_IF_FULL)))
      error=1;
  }
end:
  pthread_mutex_unlock(&THR_LOCK_keycache);
  return(error);
} /* key_cache_write */


	/* Find block in cache */
	/* IF found sector and error is set then next->changed is cleared */

static SEC_LINK *find_key_block(file,filepos,block_size,error)
int file;
ulong filepos;
uint block_size;
int *error;
{
  reg1 SEC_LINK *next,**start;

  *error=0;
  next= *(start= &_my_hash_root[((filepos/MIN_KEYBLOCK)+(ulong) file) &
				(_my_hash_blocks-1)]);
  while (next && (next->diskpos != filepos || next->file != file))
    next= next->next;

  if (next)
  {						/* Found block */
    if (next != _my_used_last[block_size])
    {						/* Relink used-chain */
      if (next == _my_used_first[block_size])
	_my_used_first[block_size]=next->next_used;
      else
      {
	next->prev_used->next_used = next->next_used;
	next->next_used->prev_used = next->prev_used;
      }
      next->prev_used=_my_used_last[block_size];
      _my_used_last[block_size]->next_used=next;
    }
  }
  else
  {						/* New block */
    if (_my_disk_blocks_used+block_size+1 <= (uint) _my_disk_blocks)
    {						/* There are unused blocks */
      next= &_my_block_root[_my_blocks_used++]; /* Link in hash-chain */
      next->buffer=ADD_TO_PTR(_my_block_mem,
			      (ulong) _my_disk_blocks_used*MIN_KEYBLOCK,byte*);
      next->changed=0;
      _my_disk_blocks_used+=block_size+1;
      if (!_my_used_first[block_size])
	_my_used_first[block_size]=next;
      if (_my_used_last[block_size])
	_my_used_last[block_size]->next_used=next; /* Last in used-chain */
    }
    else
    {						/* Reuse old block */
      if ((next=_my_used_first[block_size]) == 0)
	return ((SEC_LINK*) 0);			/* No room for cacheing !!! */
      if (next->changed)
      {
	if (my_pwrite(next->file,next->buffer,(uint) next->size,next->diskpos,
		      MYF(MY_NABP | MY_WAIT_IF_FULL)))
	{
	  *error=1;
	  return((SEC_LINK*) 0);
	}
	_my_cache_write++;
	_my_blocks_changed--;
      }
      if (next->prev)				/* If in hash-link */
	if ((*next->prev=next->next) != 0)	/* Relink hash-chain */
	  next->next->prev= next->prev;

      _my_used_last[block_size]->next_used=next;
      _my_used_first[block_size]=next->next_used;
    }
    if (*start)					/* Link in first in h.-chain */
      (*start)->prev= &next->next;
    next->next= *start; next->prev=start; *start=next;
    next->prev_used=_my_used_last[block_size];
    next->file=file;
    next->diskpos=filepos;
    next->block_size=(int7) block_size;
    *error=1;					/* Block wasn't in memory */
    next->changed=0;
  }
  _my_used_last[block_size]=next;
#ifndef DBUG_OFF
  if (*error)
    DBUG_EXECUTE("exec",test_key_cache(););
#endif
  return next;
} /* find_key_block */


	/* Flush all changed blocks to disk. Free used blocks if requested */

int flush_key_blocks(file,free_used_blocks)
File file;
pbool free_used_blocks;
{
  reg1 uint blocks;
  reg2 SEC_LINK *used;
  int block_size;
  DBUG_ENTER("flush_key_blocks");
  DBUG_PRINT("enter",("file: %d  blocks_used: %d  blocks_changed: %d  _my_used_first: %lx",
		      file,_my_blocks_used,_my_blocks_changed,_my_used_first));

  pthread_mutex_lock(&THR_LOCK_keycache);
  if (_my_disk_blocks > 0)
  {
    used=_my_block_root;
    blocks=_my_blocks_used;
    while (blocks--)
    {
      if (used->file == file)
      {
	block_size=used->block_size;
	if (used->changed)
	{
	  used->changed=0;
	  _my_blocks_changed--;
	  if (my_pwrite(file,used->buffer,(uint) used->size,used->diskpos,
		       MYF(MY_NABP | MY_WAIT_IF_FULL)))
	    goto err;
	  _my_cache_write++;
	}
	if (free_used_blocks)
	{
	  used->file=0;
	  if (used != _my_used_first[block_size]) /* Relink used-chain */
	  {
	    if (used == _my_used_last[block_size])
	      _my_used_last[block_size]=used->prev_used;
	    else
	    {
	      used->prev_used->next_used = used->next_used;
	      used->next_used->prev_used = used->prev_used;
	    }
	    used->next_used=_my_used_first[block_size];
	    used->next_used->prev_used=used;
	    _my_used_first[block_size]=used;
	  }
	  if ((*used->prev=used->next) != 0)	/* Relink hash-chain */
	    used->next->prev= used->prev;
	  used->prev=0; used->next=0;
	}
      }
      used++;
    }
  }
  pthread_mutex_unlock(&THR_LOCK_keycache);
  DBUG_RETURN(0);
err:
  DBUG_RETURN(1);
} /* flush_key_blocks */



#ifndef DBUG_OFF

	/* Test if disk-cachee is ok */

static void test_key_cache()
{
  reg1 uint i,found,error;
  SEC_LINK *pos,**prev;

  found=error=0;
  for (i= 0 ; i < _my_hash_blocks ; i++)
  {
    pos= *(prev= &_my_hash_root[i]);
    while (pos && found < _my_blocks_used+2)
    {
      if (prev != pos->prev)
      {
	error=1;
	DBUG_PRINT("error",
		   ("hash: %d  pos: %lx  : prev: %lx  !=  pos->prev: %lx",
		    i,pos,prev,pos->prev));
      }

      if (((pos->diskpos/MIN_KEYBLOCK)+pos->file)%_my_hash_blocks != i)
      {
	DBUG_PRINT("error",("hash: %d  pos: %lx  : Wrong disk_buffer %ld",
			    i,pos,pos->diskpos));
	error=1;
      }
      found++; pos= *(prev= &pos->next);
    }
  }
  if (found > _my_blocks_used)
  {
    DBUG_PRINT("error",("Found too many hash_pointers"));
    error=1;
  }
  if (error && !_my_printed)
  {						/* Write all hash-pointers */
    _my_printed=1;
    for (i= 0 ; i < _my_hash_blocks ; i++)
    {
      DBUG_PRINT("loop",("hash: %d  _my_hash_root: %lx",i,&_my_hash_root[i]));
      pos= _my_hash_root[i]; found=0;
      while (pos && found < 10)
      {
	DBUG_PRINT("loop",("pos: %lx  prev: %lx  next: %lx  file: %d  disk_buffer: %ld", pos,pos->prev,pos->next,pos->file,pos->diskpos));
	found++; pos= pos->next;
      }
    }
  }

  found=0;
  for (i=0 ; i < MAX_BLOCK_TYPES ; i++)
  {
    if ((pos=_my_used_first[i]))
      found++;
    while (pos != _my_used_last[i] && found < _my_blocks_used+2)
    {
      found++;
      if (pos->next_used->prev_used != pos || pos->block_size != i)
	DBUG_PRINT("error",("pos: %lx  next_used: %lx  next_used->prev: %lx",
			    pos,pos->next_used,pos->next_used->prev));
      pos=pos->next_used;
    }
  }
  if (found != _my_blocks_used)
    DBUG_PRINT("error",("Found %d of %d keyblocks",found,_my_blocks_used));
  return ;
} /* test_key_cache */
#endif
