/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */
/* This file is originally from the mysql distribution. Coded by monty */

#pragma implementation				// gcc: implement sql_string.h

#include <global.h>
#include <my_sys.h>
#include <m_string.h>
#include <m_ctype.h>
#ifdef HAVE_FCONVERT
#include <floatingpoint.h>
#endif

extern gptr sql_alloc(unsigned size);
extern void sql_element_free(void *ptr);

#include "sql_string.h"

/*****************************************************************************
** String functions
*****************************************************************************/

void String::free()
{
  if (alloced)
  {
    alloced=0;
    my_free(Ptr,MYF(0));
    Ptr=0;
  }
}

bool String::alloc(uint length)
{
  length=ALIGN_SIZE(length+1);
  if (Alloced_length < length)
  {
    free();
    if (!(Ptr=my_malloc(length,MYF(MY_WME))))
    {
      str_length=0;
      return TRUE;
    }
    Alloced_length=length;
    alloced=1;
  }
  Ptr[0]=0;
  str_length=0;
  return FALSE;
}


/*
** Check that string is big enough. Set string[alloc_length] to 0 (for C functions)
*/

bool String::realloc(uint alloc_length)
{
  uint length=ALIGN_SIZE(alloc_length+1);
  if (Alloced_length < length)
  {
    char *new_ptr;
    if (alloced)
    {
      if ((new_ptr= (char*) my_realloc(Ptr,length,MYF(MY_WME))))
      {
	Ptr=new_ptr;
	Alloced_length=length;
      }
      else
	return TRUE;				// Signal error
    }
    else if ((new_ptr= (char*) my_malloc(length,MYF(MY_WME))))
    {
      memcpy(new_ptr,Ptr,str_length);
      new_ptr[str_length]=0;
      Ptr=new_ptr;
      Alloced_length=length;
      alloced=1;
    }
    else
      return TRUE;				// Signal error
  }
  Ptr[alloc_length]=0;				// This make other functions shorter
  return FALSE;
}


void String::set(long num)
{
  if (!alloc(14))
    str_length=(uint) (int2str(num,Ptr,-10)-Ptr);
}

void String::set(double num,uint decimals)
{
#ifdef HAVE_FCONVERT
  char buff[330],*pos,*to;
  int decpt,sign;

  VOID(fconvert(num,(int) decimals,&decpt,&sign,buff));
  if (alloc((uint) ((uint) decpt+test(sign)+2+decimals)))
    return;
  to=Ptr;
  if (sign)
    *to++='-';

  pos=buff;
  if (decpt < 0)
  {					/* value is < 0 */
    *to++='0';
    if (!decimals)
      goto end;
    *to++='.';
    if ((uint) -decpt > decimals)
      decpt= - (int) decimals;
    decimals=(uint) ((int) decimals+decpt);
    while (decpt++ < 0)
      *to++='0';
  }
  else if (decpt == 0)
  {
    *to++= '0';
    if (!decimals)
      goto end;
    *to++='.';
  }
  else
  {
    while (decpt-- > 0)
      *to++= *pos++;
    if (!decimals)
      goto end;
    *to++='.';
  }
  while (decimals--)
    *to++= *pos++;

end:
  *to=0;
  str_length=(uint) (to-Ptr);
#else
  char buff[330];
  sprintf(buff,"%.*lf",decimals,num);
  copy(buff,strlen(buff));
#endif
}


void String::copy()
{
  if (!alloced)
  {
    Alloced_length=0;				// Force realloc
    (void) realloc(str_length);
  }
}

void String::copy(const String &str)
{
  if (!alloc(str.str_length))
  {
    str_length=str.str_length;
    bmove(Ptr,str.Ptr,str_length);		// May be overlapping
    Ptr[str_length]=0;
  }
}

void String::copy(const char *str,uint length)
{
  if (!alloc(length))
  {
    str_length=length;
    memcpy(Ptr,str,length);
    Ptr[length]=0;
  }
}

void String::fill(uint max_length,char fill)
{
  if (str_length > max_length)
    Ptr[str_length=max_length]=0;
  else
  {
    if (!realloc(max_length))
    {
      bfill(Ptr+str_length,max_length-str_length,fill);
      str_length=max_length;
    }
  }
}

void String::strip_sp()
{
   while (str_length && isspace(Ptr[str_length-1]))
    str_length--;
}

void String::append(const String &s)
{
  if (!realloc(str_length+s.length()))
  {
    memcpy(Ptr+str_length,s.ptr(),s.length());
    str_length+=s.length();
  }
}

int String::strstr(const String &s,uint offset)
{
  register const char *str = Ptr+offset;
  register const char *search=s.ptr();
  register char *i,*j;

  if (s.length()+offset <= str_length)
  {
    const char *end=Ptr+str_length-s.length()+1;
    const char *search_end=s.ptr()+s.length();
skipp:
    while (str != end) {
      if (*str++ == *search) {
	i=(char*) str; j=(char*) search+1;
	while (j != search_end)
	  if (*i++ != *j++) goto skipp;
	return (int) (str-Ptr) -1;
      }
    }
  }
  return -1;
}


/*
** replace substring with string
** If wrong parameter or not enough memory, do nothing
*/


void String::replace(uint offset,uint length,const String &to)
{
  int diff = (int) (to.length()-length);
  if (offset+length <= str_length &&
      (diff <= 0 || !realloc(str_length+(uint) diff))) 
  {
    if (diff < 0)
    {
      memcpy(Ptr+offset,to.ptr(),to.length());
      memcpy(Ptr+offset+to.length(),Ptr+offset+length,
	     str_length-offset-length);
    }
    else
    {
      if (diff)
	bmove_upp(Ptr+str_length+diff,Ptr+str_length,
		  str_length-offset-length);
      memcpy(Ptr+offset,to.ptr(),to.length());
    }
    str_length+=(uint) diff;
  }
}


int sortcmp(const String &x,const String &y)
{
  const char *s= x.ptr();
  const char *t= y.ptr();
  uint x_len=x.length(),y_len=y.length(),len=min(x_len,y_len);

  while (len--)
  {
    if (my_sort_order[(uchar) *s++] != my_sort_order[(uchar) *t++])
      return ((int) my_sort_order[(uchar) s[-1]] -
	      (int) my_sort_order[(uchar) t[-1]]);
  }
  return (int) (x_len-y_len);
}


int stringcmp(const String &x,const String &y)
{
  const char *s= x.ptr();
  const char *t= y.ptr();
  uint x_len=x.length(),y_len=y.length(),len=min(x_len,y_len);

  while (len--)
  {
    if (*s++ != (uchar) *t++)
      return ((int) (uchar) s[-1] - (int) (uchar) t[-1]);
  }
  return (int) (x_len-y_len);
}


String *copy_if_not_alloced(String &to,String &from,uint length)
{
  if (from.Alloced_length >= length)
    return &from;
  if (from.alloced)
  {
    (void) from.realloc(length);
    return &from;
  }
  if (to.realloc(length))
    return &from;				// Actually error 
  to.str_length=min(from.str_length,length);
  memcpy(to.Ptr,from.Ptr,to.str_length);
  return &to;
}
